/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.osgi.util.NLS;

public class JSDocValidatorFactory {

    public static abstract class AbstractTypeChecker
    implements ITypeChecker {
        private int defaults = 1;

        public int getDefaults() {
            return this.defaults;
        }

        public void setDefaults(int defaults) {
            this.defaults = defaults;
        }

        public void checkType(JSType type, ISourceNode node) {
            this.checkType(type, node, this.getDefaults());
        }

        public void checkType(JSType type, ISourceNode tag, int flags) {
            if (type == null) {
                return;
            }
            if (type instanceof UnionType) {
                for (JSType targetType : ((UnionType)type).getTargets()) {
                    this.checkType(targetType, tag, flags);
                }
            } else if (type instanceof RecordType) {
                for (Member member : ((RecordType)type).getMembers()) {
                    this.checkType(member.getType(), tag, flags);
                }
            } else if (type instanceof FunctionType) {
                FunctionType func = (FunctionType)type;
                this.checkType(((FunctionType)type).getReturnType(), tag, flags);
                for (Parameter parameter : func.getParameters()) {
                    this.checkType(parameter.getType(), tag, flags);
                }
            } else if (!(type instanceof AnyType) && !(type instanceof UndefinedType)) {
                if (type instanceof ArrayType) {
                    this.checkType(((ArrayType)type).getItemType(), tag, flags);
                } else if (type instanceof MapType) {
                    this.checkType(((MapType)type).getKeyType(), tag, flags);
                    this.checkType(((MapType)type).getValueType(), tag, flags);
                } else if (type instanceof SimpleType) {
                    if (type instanceof ParameterizedType) {
                        for (JSType param : ((ParameterizedType)type).getActualTypeArguments()) {
                            this.checkType(param, tag, flags);
                        }
                    }
                    Type t = ((SimpleType)type).getTarget();
                    this.checkType(t, tag, flags);
                } else if (type instanceof ClassType) {
                    Type t = ((ClassType)type).getTarget();
                    if (t == null) {
                        return;
                    }
                    this.checkType(t, tag, flags);
                }
            }
        }

        public abstract void checkType(Type var1, ISourceNode var2, int var3);
    }

    private static class QueueItem {
        private final Type type;
        private final ISourceNode tag;
        private final IValueCollection collection;
        private final int flags;

        public QueueItem(Type type, ISourceNode tag, IValueCollection collection, int flags) {
            this.type = type;
            this.tag = tag;
            this.collection = collection;
            this.flags = flags;
        }
    }

    public static class TypeChecker
    extends AbstractTypeChecker {
        private List<QueueItem> queue = new ArrayList<QueueItem>();
        private final TypeInferencer2 context;
        private final JSProblemReporter reporter;

        public TypeChecker(TypeInferencer2 context, JSProblemReporter reporter) {
            this.context = context;
            this.reporter = reporter;
        }

        public void checkType(Type type, ISourceNode tag, int flags) {
            if (type.getKind() == TypeKind.UNKNOWN || type.getKind() == TypeKind.UNRESOLVED) {
                this.queue.add(new QueueItem(type, tag, this.context.currentCollection(), flags));
            } else {
                this.checkDeprecatedType(type, tag);
            }
        }

        public void validate() {
            for (QueueItem item : this.queue) {
                this.checkType(item.tag, this.context.resolveType(item.type), item.collection, item.flags);
            }
        }

        protected void checkType(ISourceNode tag, Type type, IValueCollection collection, int flags) {
            Assert.isTrue((type.getKind() != TypeKind.UNRESOLVED ? 1 : 0) != 0);
            if (type.getKind() == TypeKind.UNKNOWN) {
                if ((flags & 1) != 0 && collection != null) {
                    if (collection.getChild(type.getName()).exists()) {
                        return;
                    }
                    String className = type.getName();
                    if (className.indexOf(46) != -1) {
                        StringTokenizer st = new StringTokenizer(className, ".");
                        IValueReference child = null;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (child == null) {
                                child = collection.getChild(token);
                            } else {
                                IValueCollection function;
                                if (child.getKind() == ReferenceKind.FUNCTION && (function = (IValueCollection)child.getAttribute("FUNCTION_SCOPE")) != null) {
                                    child = function.getThis();
                                }
                                child = child.getChild(token);
                            }
                            if (child.exists()) continue;
                            child = null;
                            break;
                        }
                        if (child != null) {
                            return;
                        }
                    }
                }
                this.reportUnknownType(tag, TypeUtil.getName(type));
            } else {
                this.checkDeprecatedType(type, tag);
            }
        }

        private void checkDeprecatedType(Type type, ISourceNode tag) {
            if (type.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)TypeUtil.getName(type)), tag.start(), tag.end());
            }
        }

        public void reportUnknownType(ISourceNode tag, String name) {
            this.reportUnknownType(JavaScriptProblems.UNKNOWN_TYPE, tag, name);
        }

        public void reportUnknownType(IProblemIdentifier identifier, ISourceNode node, String name) {
            int start;
            int end;
            if (node instanceof JSDocTag) {
                int index2;
                JSDocTag tag = (JSDocTag)node;
                end = tag.end();
                start = end - tag.value().length();
                int index = tag.value().indexOf(123);
                if (index != -1 && (index2 = tag.value().indexOf(125, index)) != -1) {
                    start = start + index + 1;
                    end = start + index2 - 1;
                }
            } else {
                start = node.start();
                end = node.end();
            }
            this.reporter.reportProblem(identifier, NLS.bind((String)ValidationMessages.UnknownType, (Object)name), start, end);
        }
    }
}

