/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BinaryOperator implements Enumerator
{
    MUL(1, "mul", "*"),
    DIV(2, "div", "/"),
    MOD(3, "mod", "%"),
    ADD(4, "add", "+"),
    SUB(5, "sub", "-"),
    LSH(6, "lsh", "<<"),
    RSH(7, "rsh", ">>"),
    URSH(8, "ursh", ">>>"),
    LESS(9, "less", "<"),
    GREATER(10, "greater", ">"),
    LEQ(11, "leq", "<="),
    GEQ(12, "geq", ">="),
    INSTANCEOF(13, "instanceof", "instanceof"),
    IN(14, "in", "in"),
    EQ(15, "eq", "=="),
    NEQ(16, "neq", "!="),
    SAME(17, "same", "==="),
    NSAME(18, "nsame", "!=="),
    BW_AND(19, "bwAnd", "&"),
    BW_XOR(20, "bwXor", "^"),
    BW_OR(21, "bwOr", "|"),
    LOG_AND(22, "logAnd", "&&"),
    LOG_OR(23, "logOr", "||"),
    ASSIGN(24, "assign", "="),
    MUL_ASSIGN(25, "mulAssign", "*="),
    DIV_ASSIGN(26, "divAssign", "/="),
    MOD_ASSIGN(27, "modAssign", "%="),
    ADD_ASSIGN(28, "addAssign", "+="),
    SUB_ASSIGN(29, "subAssign", "-="),
    LSH_ASSIGN(30, "lshAssign", "<<="),
    RSH_ASSIGN(31, "rshAssign", ">>="),
    URSH_ASSIGN(32, "urshAssign", ">>>="),
    AND_ASSIGN(33, "andAssign", "&="),
    XOR_ASSIGN(34, "xorAssign", "^="),
    OR_ASSIGN(35, "orAssign", "|="),
    COMMA(36, "comma", ",");

    public static final int MUL_VALUE = 1;
    public static final int DIV_VALUE = 2;
    public static final int MOD_VALUE = 3;
    public static final int ADD_VALUE = 4;
    public static final int SUB_VALUE = 5;
    public static final int LSH_VALUE = 6;
    public static final int RSH_VALUE = 7;
    public static final int URSH_VALUE = 8;
    public static final int LESS_VALUE = 9;
    public static final int GREATER_VALUE = 10;
    public static final int LEQ_VALUE = 11;
    public static final int GEQ_VALUE = 12;
    public static final int INSTANCEOF_VALUE = 13;
    public static final int IN_VALUE = 14;
    public static final int EQ_VALUE = 15;
    public static final int NEQ_VALUE = 16;
    public static final int SAME_VALUE = 17;
    public static final int NSAME_VALUE = 18;
    public static final int BW_AND_VALUE = 19;
    public static final int BW_XOR_VALUE = 20;
    public static final int BW_OR_VALUE = 21;
    public static final int LOG_AND_VALUE = 22;
    public static final int LOG_OR_VALUE = 23;
    public static final int ASSIGN_VALUE = 24;
    public static final int MUL_ASSIGN_VALUE = 25;
    public static final int DIV_ASSIGN_VALUE = 26;
    public static final int MOD_ASSIGN_VALUE = 27;
    public static final int ADD_ASSIGN_VALUE = 28;
    public static final int SUB_ASSIGN_VALUE = 29;
    public static final int LSH_ASSIGN_VALUE = 30;
    public static final int RSH_ASSIGN_VALUE = 31;
    public static final int URSH_ASSIGN_VALUE = 32;
    public static final int AND_ASSIGN_VALUE = 33;
    public static final int XOR_ASSIGN_VALUE = 34;
    public static final int OR_ASSIGN_VALUE = 35;
    public static final int COMMA_VALUE = 36;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{MUL, DIV, MOD, ADD, SUB, LSH, RSH, URSH, LESS, GREATER, LEQ, GEQ, INSTANCEOF, IN, EQ, NEQ, SAME, NSAME, BW_AND, BW_XOR, BW_OR, LOG_AND, LOG_OR, ASSIGN, MUL_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, ADD_ASSIGN, SUB_ASSIGN, LSH_ASSIGN, RSH_ASSIGN, URSH_ASSIGN, AND_ASSIGN, XOR_ASSIGN, OR_ASSIGN, COMMA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 1: {
                return MUL;
            }
            case 2: {
                return DIV;
            }
            case 3: {
                return MOD;
            }
            case 4: {
                return ADD;
            }
            case 5: {
                return SUB;
            }
            case 6: {
                return LSH;
            }
            case 7: {
                return RSH;
            }
            case 8: {
                return URSH;
            }
            case 9: {
                return LESS;
            }
            case 10: {
                return GREATER;
            }
            case 11: {
                return LEQ;
            }
            case 12: {
                return GEQ;
            }
            case 13: {
                return INSTANCEOF;
            }
            case 14: {
                return IN;
            }
            case 15: {
                return EQ;
            }
            case 16: {
                return NEQ;
            }
            case 17: {
                return SAME;
            }
            case 18: {
                return NSAME;
            }
            case 19: {
                return BW_AND;
            }
            case 20: {
                return BW_XOR;
            }
            case 21: {
                return BW_OR;
            }
            case 22: {
                return LOG_AND;
            }
            case 23: {
                return LOG_OR;
            }
            case 24: {
                return ASSIGN;
            }
            case 25: {
                return MUL_ASSIGN;
            }
            case 26: {
                return DIV_ASSIGN;
            }
            case 27: {
                return MOD_ASSIGN;
            }
            case 28: {
                return ADD_ASSIGN;
            }
            case 29: {
                return SUB_ASSIGN;
            }
            case 30: {
                return LSH_ASSIGN;
            }
            case 31: {
                return RSH_ASSIGN;
            }
            case 32: {
                return URSH_ASSIGN;
            }
            case 33: {
                return AND_ASSIGN;
            }
            case 34: {
                return XOR_ASSIGN;
            }
            case 35: {
                return OR_ASSIGN;
            }
            case 36: {
                return COMMA;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

