/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.manipulation.RefactoringChecks;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.internal.javascript.core.manipulation.JavascriptManipulationPlugin;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.Checks;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.structure.BodyUpdater;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.NodeFinder;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.dom.rewrite.RewriteAnalyzer;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.ChangeMethodSignatureDescriptor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSignatureProcessor
extends RefactoringProcessor {
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private List<ParameterInfo> fParameterInfos;
    private TextChangeManager fChangeManager;
    private IMethod fMethod;
    private SearchResultGroup[] fReferences;
    private String fMethodName;
    private BodyUpdater fBodyUpdater;

    public ChangeSignatureProcessor(IMethod method) {
        this.fMethod = method;
        if (this.fMethod != null) {
            this.fParameterInfos = ChangeSignatureProcessor.createParameterInfoList(method);
            this.fMethodName = this.fMethod.getElementName();
        }
    }

    private static List<ParameterInfo> createParameterInfoList(IMethod method) {
        try {
            String[] oldNames = method.getParameterNames();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(oldNames.length);
            int i = 0;
            while (i < oldNames.length) {
                ParameterInfo parameterInfo = new ParameterInfo("", oldNames[i], i);
                result.add(parameterInfo);
                ++i;
            }
            return result;
        }
        catch (ModelException e) {
            JavascriptManipulationPlugin.log(e);
            return new ArrayList<ParameterInfo>(0);
        }
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_modify_Parameters;
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setNewMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fMethodName = newMethodName;
    }

    public boolean canChangeNameAndReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (ModelException e) {
            JavascriptManipulationPlugin.log(e);
            return false;
        }
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setBodyUpdater(BodyUpdater bodyUpdater) {
        this.fBodyUpdater = bodyUpdater;
    }

    public RefactoringStatus checkSignature() {
        return this.checkSignature(false);
    }

    private RefactoringStatus checkSignature(boolean resolveBindings) {
        RefactoringStatus result = new RefactoringStatus();
        this.checkMethodName(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkParameterNamesAndValues(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkForDuplicateParameterNames(result);
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    public boolean isSignatureSameAsInitial() throws ModelException {
        if (!this.isMethodNameSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getParameters().length == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && this.areParameterTypesSameAsInitial();
    }

    private boolean areParameterTypesSameAsInitial() {
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodNameSameAsInitial() {
        return this.fMethodName.equals(this.fMethod.getElementName());
    }

    private void checkParameterNamesAndValues(RefactoringStatus result) {
        int i = 1;
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isDeleted()) continue;
            this.checkParameterName(result, info, i);
            if (result.hasFatalError()) {
                return;
            }
            if (!info.isAdded()) continue;
            this.checkParameterDefaultValue(result, info);
            if (!result.hasFatalError()) continue;
            return;
        }
    }

    private void checkParameterName(RefactoringStatus result, ParameterInfo info, int position) {
        if (info.getNewName().trim().length() == 0) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_param_name_not_empty, Integer.toString(position)));
        } else {
            result.merge(Checks.validateIdentifier(info.getNewName()));
        }
    }

    private void checkMethodName(RefactoringStatus result) {
        if (this.isMethodNameSameAsInitial() || !this.canChangeNameAndReturnType()) {
            return;
        }
        if ("".equals(this.fMethodName.trim())) {
            String msg = RefactoringCoreMessages.ChangeSignatureRefactoring_method_name_not_empty;
            result.addFatalError(msg);
            return;
        }
        result.merge(Checks.validateIdentifier(this.fMethodName));
    }

    private void checkParameterDefaultValue(RefactoringStatus result, ParameterInfo info) {
        if (info.getDefaultValue().trim().equals("")) {
            String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_default_value, info.getNewName());
            result.addFatalError(msg);
            return;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            RefactoringStatus result = RefactoringChecks.checkIfCuBroken((IMember)this.fMethod);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fMethod == null || !this.fMethod.exists()) {
                String message = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_method_deleted, this.getCu().getResource().getName());
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)message);
                return refactoringStatus;
            }
            monitor.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_checking_preconditions, 8);
            RefactoringStatus result = new RefactoringStatus();
            if (this.isSignatureSameAsInitial()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ChangeSignatureRefactoring_unchanged);
                return refactoringStatus;
            }
            result.merge(this.checkSignature(true));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fReferences = this.findReferences((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            RefactoringChecks.addModifiedFilesToChecker((IFile[])this.getAllFilesToModify(), (CheckConditionsContext)context);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected void clearManagers() {
        this.fChangeManager = null;
    }

    public String getOldMethodSignature() throws ModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.fMethod.getElementName()).append("(").append(this.getOldMethodParameters()).append(")");
        return buff.toString();
    }

    public String getNewMethodSignature() throws ModelException {
        StringBuffer buff = new StringBuffer();
        buff.append("function ").append(this.getMethodName()).append("(").append(this.getMethodParameters()).append(")");
        return buff.toString();
    }

    private void checkForDuplicateParameterNames(RefactoringStatus result) {
        HashSet<String> found = new HashSet<String>();
        HashSet<String> doubled = new HashSet<String>();
        for (ParameterInfo info : this.getNotDeletedInfos()) {
            String newName = info.getNewName();
            if (found.contains(newName) && !doubled.contains(newName)) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_duplicate_name, newName));
                doubled.add(newName);
                continue;
            }
            found.add(newName);
        }
    }

    private ISourceModule getCu() {
        return this.fMethod.getSourceModule();
    }

    private String getOldMethodParameters() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        Iterator<ParameterInfo> iterator = this.getNotAddedInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo element;
            ParameterInfo info = element = iterator.next();
            if (!first) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureProcessor.createDeclarationString(info));
            first = false;
        }
        return buff.toString();
    }

    private String getMethodParameters() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (ParameterInfo info : this.getNotDeletedInfos()) {
            if (!first) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureProcessor.createDeclarationString(info));
            first = false;
        }
        return buff.toString();
    }

    private List<ParameterInfo> getAddedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        for (ParameterInfo info : this.fParameterInfos) {
            if (!info.isAdded()) continue;
            result.add(info);
        }
        return result;
    }

    private List<ParameterInfo> getDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        for (ParameterInfo info : this.fParameterInfos) {
            if (!info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private List<ParameterInfo> getNotAddedInfos() {
        ArrayList<ParameterInfo> all = new ArrayList<ParameterInfo>(this.fParameterInfos);
        all.removeAll(this.getAddedInfos());
        return all;
    }

    private List<ParameterInfo> getNotDeletedInfos() {
        ArrayList<ParameterInfo> all = new ArrayList<ParameterInfo>(this.fParameterInfos);
        all.removeAll(this.getDeletedInfos());
        return all;
    }

    private boolean areNamesSameAsInitial() {
        for (ParameterInfo info : this.fParameterInfos) {
            if (!info.isRenamed()) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int i = 0;
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isDeleted() || info.getOldIndex() != i) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles((ISourceModule[])this.fChangeManager.getAllSourceModules());
    }

    public Change[] getAllChanges() {
        return this.fChangeManager.getAllChanges();
    }

    public Change createChange(IProgressMonitor pm) {
        pm.beginTask("", 1);
        try {
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((RefactoringDescriptor)this.createDescriptor(), this.doGetRefactoringChangeName(), this.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.clearManagers();
            pm.done();
        }
    }

    public ScriptRefactoringDescriptor createDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IScriptProject scriptProject = this.fMethod.getScriptProject();
        if (scriptProject != null) {
            project = scriptProject.getElementName();
        }
        ChangeMethodSignatureDescriptor descriptor = null;
        String description = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_descriptor_description_short, this.fMethod.getElementName());
        descriptor = new ChangeMethodSignatureDescriptor(project, description, "", arguments, this.getDescriptorFlags());
        arguments.put("input", ScriptRefactoringDescriptor.elementToHandle((String)project, (IModelElement)this.fMethod));
        arguments.put("name", this.fMethodName);
        int count = 1;
        for (ParameterInfo info : this.fParameterInfos) {
            StringBuffer buffer = new StringBuffer(64);
            if (info.isAdded()) {
                buffer.append("{added}");
            } else {
                buffer.append(info.getOldTypeName());
            }
            buffer.append(" ");
            if (info.isAdded()) {
                buffer.append("{added}");
            } else {
                buffer.append(info.getOldName());
            }
            buffer.append(" ");
            buffer.append(info.getOldIndex());
            buffer.append(" ");
            if (info.isDeleted()) {
                buffer.append("{deleted}");
            } else {
                buffer.append(info.getNewTypeName().replaceAll(" ", ""));
            }
            buffer.append(" ");
            if (info.isDeleted()) {
                buffer.append("{deleted}");
            } else {
                buffer.append(info.getNewName());
            }
            buffer.append(" ");
            buffer.append(info.isDeleted());
            arguments.put(ATTRIBUTE_PARAMETER + count, buffer.toString());
            String value = info.getDefaultValue();
            if (value != null && !"".equals(value)) {
                arguments.put(ATTRIBUTE_DEFAULT + count, value);
            }
            ++count;
        }
        return descriptor;
    }

    protected int getDescriptorFlags() {
        return 589830;
    }

    protected String doGetRefactoringChangeName() {
        return RefactoringCoreMessages.ChangeSignatureRefactoring_restructure_parameters;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ChangeSignatureRefactoring_preview, 1);
        this.fChangeManager = new TextChangeManager();
        boolean decl = false;
        int i = 0;
        while (i < this.fReferences.length) {
            SearchResultGroup group = this.fReferences[i];
            ISourceModule cu = group.getSourceModule();
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.processCu(cu, group.getSearchResults(), result);
            if (cu.equals(this.fMethod.getSourceModule())) {
                decl = true;
            }
            ++i;
        }
        if (!decl) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.processCu(this.fMethod.getSourceModule(), Collections.EMPTY_LIST, result);
        }
        pm.done();
        return this.fChangeManager;
    }

    private void processCu(ISourceModule cu, List<SearchMatch> searchResults, RefactoringStatus result) throws ModelException {
        Node node;
        if (cu == null) {
            return;
        }
        Source root = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)cu));
        Node[] nodes = NodeFinder.findNodes(root, searchResults);
        ChangeRecorder cr = new ChangeRecorder((EObject)root);
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            node = nodeArray[n2];
            CallExpression call = RefactoringUtils.getFunctionReference(node);
            if (call != null) {
                Identifier id = node instanceof Identifier ? (Identifier)node : ((VariableReference)node).getVariable();
                id.setName(this.fMethodName);
                if (call.getArguments().size() != this.fMethod.getParameters().length) {
                    result.addWarning(RefactoringCoreMessages.ChangeSignatureRefactoring_different_num_of_args, ScriptStatusContext.create((ISourceModule)cu, (ISourceRange)new SourceRange(node.getBegin(), node.getEnd() - node.getBegin())));
                }
                this.reshuffleElements(call.getArguments(), new NewElementsProvider<Expression>(){

                    @Override
                    Expression createElement(ParameterInfo info) {
                        VariableReference ref = DomFactory.eINSTANCE.createVariableReference();
                        Identifier id = DomFactory.eINSTANCE.createIdentifier();
                        if (info.getDefaultValue() == null) {
                            id.setName("undefined");
                        } else {
                            id.setName(info.getDefaultValue());
                        }
                        ref.setVariable(id);
                        return ref;
                    }
                });
            } else {
                result.addError(RefactoringCoreMessages.ChangeSignatureRefactoring_unknown_reference, ScriptStatusContext.create((ISourceModule)cu, (ISourceRange)new SourceRange(node.getBegin(), node.getEnd() - node.getBegin())));
                this.tryRename(node);
            }
            ++n2;
        }
        if (cu.equals(this.fMethod.getSourceModule())) {
            node = NodeFinder.findNode(root, this.fMethod.getNameRange());
            FunctionExpression expr = null;
            if (node == null) {
                Node anon = NodeFinder.findNode(root, this.fMethod.getSourceRange());
                if (anon.eClass().getClassifierID() == 56) {
                    expr = (FunctionExpression)anon;
                }
            } else {
                expr = RefactoringUtils.getFunctionDeclaration(node);
            }
            if (expr != null) {
                if (node != null) {
                    ((Identifier)node).setName(this.fMethodName);
                } else {
                    Identifier id = DomFactory.eINSTANCE.createIdentifier();
                    id.setName(this.fMethodName);
                    expr.setIdentifier(id);
                }
                this.reshuffleElements(expr.getParameters(), new NewElementsProvider<Parameter>(){

                    @Override
                    Parameter createElement(ParameterInfo info) {
                        Parameter param = DomFactory.eINSTANCE.createParameter();
                        Identifier id = DomFactory.eINSTANCE.createIdentifier();
                        id.setName(info.getNewName());
                        param.setName(id);
                        return param;
                    }
                });
                this.modifyElements(expr.getParameters());
                result.merge(this.checkIfDeletedParametersUsed(expr.getBody(), cu));
                this.updateBody(expr.getBody());
                if (this.fBodyUpdater != null) {
                    this.fBodyUpdater.updateBody(expr);
                }
            } else {
                result.addError(RefactoringCoreMessages.ChangeSignatureRefactoring_unknown_reference, ScriptStatusContext.create((ISourceModule)cu, (ISourceRange)this.fMethod.getNameRange()));
                this.tryRename(node);
            }
        }
        ChangeDescription cd = cr.endRecording();
        RewriteAnalyzer rewrite = new RewriteAnalyzer(cd, cu.getSource());
        rewrite.rewrite(root);
        cd.apply();
        SourceModuleChange change = new SourceModuleChange(cu.getElementName(), cu);
        change.setEdit(rewrite.getEdit());
        this.fChangeManager.manage(cu, (TextChange)change);
    }

    private RefactoringStatus checkIfDeletedParametersUsed(Node node, ISourceModule cu) {
        HashSet<String> deleted = new HashSet<String>();
        for (ParameterInfo info : this.getDeletedInfos()) {
            if (!info.isDeleted()) continue;
            deleted.add(info.getOldName());
        }
        List<Identifier> refs = VariableLookup.findReferences(node, deleted, true);
        RefactoringStatus status = new RefactoringStatus();
        for (Identifier ref : refs) {
            SourceRange range = new SourceRange(ref.getBegin(), ref.getEnd() - ref.getBegin());
            RefactoringStatusContext context = ScriptStatusContext.create((ISourceModule)cu, (ISourceRange)range);
            Object[] keys = new String[]{ref.getName(), this.fMethodName};
            String msg = Messages.format(RefactoringCoreMessages.ChangeSignatureRefactoring_parameter_used, keys);
            status.addWarning(msg, context);
        }
        return status;
    }

    private void updateBody(Node node) {
        HashMap<String, String> renaming = new HashMap<String, String>();
        for (ParameterInfo info : this.getNotDeletedInfos()) {
            if (info.isDeleted()) continue;
            renaming.put(info.getOldName(), info.getNewName());
        }
        List<Identifier> refs = VariableLookup.findReferences(node, renaming.keySet());
        for (Identifier ref : refs) {
            ref.setName((String)renaming.get(ref.getName()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final <T extends Node> void reshuffleElements(EList<T> original, NewElementsProvider<T> provider) {
        dst = new ArrayList<Node>();
        deleted = new HashSet<Node>();
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isDeleted()) {
                if (info.getOldIndex() >= original.size()) continue;
                deleted.add((Node)original.get(info.getOldIndex()));
                continue;
            }
            if (info.isAdded() || info.getOldIndex() >= original.size()) {
                dst.add((Node)provider.createElement(info));
                continue;
            }
            dst.add((Node)original.get(info.getOldIndex()));
        }
        i = 0;
        ** GOTO lbl30
        {
            original.remove(i);
            do {
                if (i < original.size() && deleted.contains(original.get(i))) continue block1;
                if (i == dst.size()) break block1;
                node = (Node)dst.get(i);
                if (i >= original.size() || original.get(i) != node) {
                    if (original.contains((Object)node)) {
                        original.move(i, (Object)node);
                    } else {
                        original.add(i, (Object)((Node)dst.get(i)));
                    }
                }
                ++i;
lbl30:
                // 2 sources

            } while (i < dst.size() + 1);
        }
    }

    private final <T extends Node> void modifyElements(EList<Parameter> original) {
        int i = 0;
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isDeleted()) break;
            if (!info.isAdded() && info.isRenamed()) {
                ((Parameter)original.get(i)).getName().setName(info.getNewName());
            }
            ++i;
        }
    }

    private IDLTKSearchScope createRefactoringScope() throws ModelException {
        return RefactoringScopeFactory.create((IModelElement)this.fMethod, (boolean)true, (boolean)false);
    }

    private SearchResultGroup[] findReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor(true);
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)this.fMethod, (int)1);
        return RefactoringSearchEngine.search((SearchPattern)pattern, (IDLTKSearchScope)this.createRefactoringScope(), (CollectingSearchRequestor)requestor, (IProgressMonitor)pm, (RefactoringStatus)status);
    }

    private static String createDeclarationString(ParameterInfo info) {
        return String.valueOf(info.getNewName()) + ("".equals(info.getNewTypeName()) ? "" : ":" + info.getNewTypeName());
    }

    private void tryRename(Node node) {
        if (node instanceof Identifier) {
            ((Identifier)node).setName(this.fMethodName);
        }
        if (node instanceof VariableReference) {
            ((VariableReference)node).getVariable().setName(this.fMethodName);
        }
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    public String getIdentifier() {
        return "org.eclipse.dltk.javascript.ui.changeMethodSignatureRefactoring";
    }

    public boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IModelElement)this.fMethod);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NewElementsProvider<T> {
        private NewElementsProvider() {
        }

        abstract T createElement(ParameterInfo var1);
    }
}

