/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.index2.AddSourceModuleRequest;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.dltk.internal.core.util.Util;

public class ReconcileSourceModuleRequest
extends AddSourceModuleRequest {
    public ReconcileSourceModuleRequest(ProjectIndexer2 indexer, ISourceModule sourceModule, ProgressJob progressJob) {
        super(indexer, sourceModule, progressJob);
    }

    protected void run() throws CoreException, IOException {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null) {
            return;
        }
        IPath containerPath = this.sourceModule instanceof SourceModule ? this.sourceModule.getScriptProject().getPath() : this.sourceModule.getAncestor(3).getPath();
        String relativePath = Util.relativePath(this.sourceModule.getPath(), containerPath.segmentCount());
        indexer.removeDocument(containerPath, relativePath);
        super.run();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReconcileSourceModuleRequest) {
            return super.equals(obj);
        }
        return false;
    }
}

