/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching2;

import java.util.regex.Pattern;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatchingPredicate<E>
implements IMatchingPredicate<E> {
    private final boolean isCaseSensitive;
    private final boolean isCamelCase;
    private final int matchMode;
    protected final char[] namePattern;
    private Pattern compiledPattern;

    public AbstractMatchingPredicate(SearchPattern pattern, char[] namePattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isCamelCase = (matchRule & 0x80) != 0;
        this.matchMode = matchRule & 7;
        this.namePattern = namePattern;
    }

    protected MatchLevel matchName(String name) {
        return this.matchNameValue(this.namePattern, name.toCharArray());
    }

    protected MatchLevel matchNameValue(char[] pattern, char[] name) {
        boolean canBePrefix;
        if (pattern == null) {
            return MatchLevel.ACCURATE_MATCH;
        }
        if (name == null) {
            return null;
        }
        if (name.length == 0) {
            if (pattern.length == 0) {
                return MatchLevel.ACCURATE_MATCH;
            }
            return null;
        }
        if (pattern.length == 0) {
            return null;
        }
        boolean matchFirstChar = !this.isCaseSensitive || pattern[0] == name[0];
        boolean sameLength = pattern.length == name.length;
        boolean bl = canBePrefix = name.length >= pattern.length;
        if (this.isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
            return MatchLevel.POSSIBLE_MATCH;
        }
        switch (this.matchMode) {
            case 0: {
                if (!this.isCamelCase) {
                    if (!sameLength || !matchFirstChar || !CharOperation.equals(pattern, name, this.isCaseSensitive)) break;
                    return MatchLevel.POSSIBLE_MATCH;
                }
            }
            case 1: {
                if (!canBePrefix || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, this.isCaseSensitive)) break;
                return MatchLevel.POSSIBLE_MATCH;
            }
            case 2: {
                if (!this.isCaseSensitive) {
                    pattern = CharOperation.toLowerCase(pattern);
                }
                if (!CharOperation.match(pattern, name, this.isCaseSensitive)) break;
                return MatchLevel.POSSIBLE_MATCH;
            }
            case 4: {
                if (this.compiledPattern == null) {
                    this.compiledPattern = Pattern.compile(new String(pattern), this.isCaseSensitive ? 0 : 2);
                }
                if (!this.compiledPattern.matcher(new String(name)).matches()) break;
                return MatchLevel.POSSIBLE_MATCH;
            }
        }
        return null;
    }
}

