/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.statements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Expression {
    private List<ASTNode> statements;

    public Block() {
        this.statements = new ArrayList<ASTNode>();
    }

    public Block(int start, int end) {
        this(start, end, null);
    }

    public Block(int start, int end, List<ASTNode> statems) {
        super(start, end);
        this.statements = statems != null ? new ArrayList<ASTNode>(statems) : new ArrayList();
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            for (ASTNode node : this.statements) {
                node.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    @Override
    public int getKind() {
        return 2008;
    }

    public void acceptStatements(List<ASTNode> statems) {
        if (statems == null) {
            throw new IllegalArgumentException();
        }
        this.statements.addAll(statems);
    }

    public List<ASTNode> getStatements() {
        return this.statements;
    }

    public void addStatement(ASTNode statem) {
        if (statem == null) {
            throw new IllegalArgumentException();
        }
        this.statements.add(statem);
    }

    @Override
    public void printNode(CorePrinter output) {
        output.indent();
        Iterator<ASTNode> it = this.statements.iterator();
        while (it.hasNext()) {
            it.next().printNode(output);
            output.formatPrint("");
        }
        output.formatPrint("");
        output.dedent();
    }

    public void removeStatement(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.statements.remove(node);
    }
}

