/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationMultiStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.parser.JSDocValidatorFactory;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.IReferenceAttributes;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.validation.FlowValidation;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.RMethodFunctionWrapper;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.ISuppressWarningsState;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.PhantomValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinference.ValueReferenceUtil;
import org.eclipse.dltk.javascript.typeinfo.AttributeKey;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRAnyType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeExtension;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.GenericMethod;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;
import org.eclipse.dltk.javascript.validation.IValidatorExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class TypeInfoValidator
implements IBuildParticipant {
    public static final AttributeKey<Type> MEMBER_OWNER = new AttributeKey();
    static final boolean DEBUG = false;

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        TypeInferencer2 inferencer = this.createTypeInferencer();
        inferencer.setModelElement((IModelElement)context.getSourceModule());
        Reporter reporter = JavaScriptValidations.createReporter(context);
        Set inconsistentReturns = (Set)context.get(JavaScriptValidations.ATTR_INCONSISTENT_RETURNS);
        ValidationVisitor visitor = new ValidationVisitor(inferencer, (JSProblemReporter)reporter, inconsistentReturns);
        inferencer.setVisitor(visitor);
        JSDocValidatorFactory.TypeChecker typeChecker = new JSDocValidatorFactory.TypeChecker(inferencer, (JSProblemReporter)reporter);
        visitor.setTypeChecker(typeChecker);
        inferencer.doInferencing(script);
        typeChecker.validate();
    }

    protected TypeInferencer2 createTypeInferencer() {
        return new TypeInferencer2();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallExpressionValidator
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final CallExpression node;
        private final IValueReference reference;
        private final IValueReference[] arguments;
        private final List<Method> methods;

        public CallExpressionValidator(FunctionScope scope, CallExpression node, IValueReference reference, IValueReference[] arguments, List<Method> methods) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.arguments = arguments;
            this.methods = methods;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            visitor.validateCallExpression(this.scope, this.node, this.reference, this.arguments, this.methods);
        }
    }

    private static abstract class ExpressionValidator {
        private ISuppressWarningsState suppressed;

        abstract void call(ValidationVisitor var1);

        public ISuppressWarningsState getSuppressed() {
            return this.suppressed;
        }

        public void setSuppressed(ISuppressWarningsState suppressed) {
            this.suppressed = suppressed;
        }
    }

    static class FunctionScope {
        final Set<Object> reported = new HashSet<Object>();
        final List<ReturnNode> returnNodes = new ArrayList<ReturnNode>();
        boolean throwsException;

        FunctionScope() {
        }

        void add(Path path) {
            if (path != null) {
                this.reported.add(path.start);
                this.reported.add(path.references[0]);
            }
        }

        boolean contains(Path path) {
            if (path != null) {
                if (this.reported.contains(path.start)) {
                    return true;
                }
                IValueReference[] iValueReferenceArray = path.references;
                int n = path.references.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueReference reference = iValueReferenceArray[n2];
                    if (this.reported.contains(reference)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private static class NewExpressionValidator
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final NewExpression node;
        private final IValueReference reference;
        private final IValueReference typeReference;
        private final IValueReference[] arguments;
        private final IValueCollection collection;

        public NewExpressionValidator(FunctionScope scope, NewExpression node, IValueReference reference, IValueReference typeReference, IValueReference[] arguments, IValueCollection collection) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.typeReference = typeReference;
            this.arguments = arguments;
            this.collection = collection;
        }

        public void call(ValidationVisitor visitor) {
            visitor.validateNewExpression(this.scope, this.collection, this.node.getObjectClass(), this.reference, this.typeReference, this.arguments);
        }
    }

    private static class NotExistingIdentiferValidator
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final Expression identifer;
        private final IValueReference reference;

        public NotExistingIdentiferValidator(FunctionScope scope, Expression identifer, IValueReference reference) {
            this.scope = scope;
            this.identifer = identifer;
            this.reference = reference;
        }

        public void call(ValidationVisitor visitor) {
            visitor.validate(this.scope, this.identifer, this.reference);
        }
    }

    static class Path {
        final Expression start;
        final IValueReference[] references;

        public Path(Expression start, IValueReference[] references) {
            this.start = start;
            this.references = references;
        }
    }

    private static class PropertyExpressionHolder
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final PropertyExpression node;
        private final IValueReference reference;
        private final boolean exists;

        public PropertyExpressionHolder(FunctionScope scope, PropertyExpression node, IValueReference reference, boolean exists) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.exists = exists;
        }

        public void call(ValidationVisitor visitor) {
            visitor.validateProperty(this.scope, this.node, this.reference, this.exists);
        }
    }

    private static class ReturnNode {
        final ReturnStatement node;
        final IValueReference returnValueReference;

        public ReturnNode(ReturnStatement node, IValueReference returnValueReference) {
            this.node = node;
            this.returnValueReference = returnValueReference;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.node).trim()) + " -> " + this.returnValueReference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestReturnStatement
    extends ExpressionValidator {
        private final List<ReturnNode> lst;
        private final IRMethod jsMethod;

        public TestReturnStatement(IRMethod jsMethod, List<ReturnNode> lst) {
            this.jsMethod = jsMethod;
            this.lst = lst;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            IRType firstType = null;
            for (ReturnNode element : this.lst) {
                TypeCompatibility compatibility;
                if (element.returnValueReference == null) continue;
                IRType methodType = this.jsMethod.getType();
                if (methodType != null && methodType instanceof IRRecordType) {
                    String failedPropertyTypeString = visitor.testObjectPropertyType(element.returnValueReference, (IRRecordType)methodType);
                    if (failedPropertyTypeString != null) {
                        visitor.getProblemReporter().reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchWithActualReturnType, (Object[])new String[]{this.jsMethod.getName(), TypeUtil.getName(methodType), failedPropertyTypeString}), element.node.sourceStart(), element.node.sourceEnd());
                    }
                    return;
                }
                IRType type = JavaScriptValidations.typeOf(element.returnValueReference);
                if (type != null && methodType != null && (compatibility = methodType.isAssignableFrom(type)) != TypeCompatibility.TRUE) {
                    ReturnStatement node = element.node;
                    visitor.getProblemReporter().reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE : JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE_PARAMETERIZATION), NLS.bind((String)ValidationMessages.DeclarationMismatchWithActualReturnType, (Object[])new String[]{this.jsMethod.getName(), TypeUtil.getName(methodType), TypeUtil.getName(type)}), node.sourceStart(), node.sourceEnd());
                }
                if (firstType != null || type == null) continue;
                firstType = type;
            }
            if (firstType != null) {
                int i = 1;
                while (i < this.lst.size()) {
                    ReturnNode next = this.lst.get(i);
                    IRType nextType = JavaScriptValidations.typeOf(next.returnValueReference);
                    if (nextType != null && !nextType.isAssignableFrom(firstType).ok() && !firstType.isAssignableFrom(nextType).ok()) {
                        visitor.getProblemReporter().reportProblem((IProblemIdentifier)JavaScriptProblems.RETURN_INCONSISTENT, NLS.bind((String)ValidationMessages.ReturnTypeInconsistentWithPreviousReturn, (Object[])new String[]{TypeUtil.getName(nextType), TypeUtil.getName(firstType)}), next.node.sourceStart(), next.node.sourceEnd());
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationVisitor
    extends TypeInferencerVisitor {
        private final List<ExpressionValidator> expressionValidators = new ArrayList<ExpressionValidator>();
        private final Set<FunctionStatement> inconsistentReturns;
        private final Map<ASTNode, VisitorMode> modes = new IdentityHashMap<ASTNode, VisitorMode>();
        private final Stack<ASTNode> visitStack = new Stack();
        private IValidatorExtension[] extensions;
        private final Stack<FunctionScope> functionScopes = new Stack();
        private final IRType functionTypeRef = JSTypeSet.ref(TypeInfoModelLoader.getInstance().getType("Function"));
        private final List<IValueReference> variables = new ArrayList<IValueReference>();

        public ValidationVisitor(ITypeInferenceContext context, JSProblemReporter reporter, Set<FunctionStatement> inconsistentReturns) {
            super(context);
            this.reporter = reporter;
            this.inconsistentReturns = inconsistentReturns;
        }

        @Override
        public IValueReference visit(ASTNode node) {
            this.visitStack.push(node);
            try {
                IValueReference iValueReference = super.visit(node);
                return iValueReference;
            }
            finally {
                this.visitStack.pop();
            }
        }

        @Override
        public void initialize() {
            super.initialize();
            this.modes.clear();
            this.visitStack.clear();
            this.expressionValidators.clear();
            this.variables.clear();
            this.functionScopes.clear();
            this.functionScopes.add(new FunctionScope());
            List<IValidatorExtension> extensions = this.createExtensions(IValidatorExtension.class);
            this.extensions = !extensions.isEmpty() ? extensions.toArray(new IValidatorExtension[extensions.size()]) : null;
        }

        @Override
        public void done() {
            super.done();
            if (this.inconsistentReturns != null && !this.inconsistentReturns.isEmpty() && this.reporter instanceof Reporter) {
                Reporter r = (Reporter)this.reporter;
                for (FunctionStatement statement : this.inconsistentReturns) {
                    FlowValidation.reportInconsistentReturn(r, statement);
                }
            }
            ISuppressWarningsState suppressWarnings = this.reporter.getSuppressWarnings();
            try {
                ExpressionValidator[] expressionValidatorArray = this.expressionValidators.toArray(new ExpressionValidator[this.expressionValidators.size()]);
                int n = expressionValidatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpressionValidator call = expressionValidatorArray[n2];
                    this.reporter.restoreSuppressWarnings(call.getSuppressed());
                    call.call(this);
                    ++n2;
                }
            }
            finally {
                this.reporter.restoreSuppressWarnings(suppressWarnings);
            }
            for (IValueReference variable : this.variables) {
                IRVariable jsVariable;
                if (variable.getAttribute(IReferenceAttributes.ACCESS) != null || (jsVariable = (IRVariable)variable.getAttribute("R_VARIABLE")) != null && jsVariable.isSuppressed(JavaScriptProblems.UNUSED_VARIABLE)) continue;
                ReferenceLocation location = variable.getLocation();
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNUSED_VARIABLE, NLS.bind((String)"Variable {0} is never used", (Object)variable.getName()), location.getNameStart(), location.getNameEnd());
            }
        }

        private VisitorMode currentMode() {
            VisitorMode mode = this.modes.get(this.visitStack.peek());
            return mode != null ? mode : VisitorMode.NORMAL;
        }

        @Override
        public IValueReference visitNewExpression(NewExpression node) {
            TypeInferencerVisitor.VisitNewResult result = this.visitNew(node);
            if (result.getTypeValue() != null) {
                this.pushExpressionValidator(new NewExpressionValidator(this.peekFunctionScope(), node, result.getValue(), result.getTypeValue(), result.getArguments(), this.peekContext()));
            }
            return result.getValue();
        }

        private static Path path(Expression expression, IValueReference reference) {
            ArrayList<IValueReference> refs;
            block3: {
                refs = new ArrayList<IValueReference>(8);
                do {
                    if (expression instanceof PropertyExpression) {
                        expression = ((PropertyExpression)expression).getObject();
                    } else {
                        if (!(expression instanceof CallExpression)) break block3;
                        expression = ((CallExpression)expression).getExpression();
                    }
                    refs.add(reference);
                } while ((reference = reference.getParent()) != null);
                return null;
            }
            refs.add(reference);
            return new Path(expression, refs.toArray(new IValueReference[refs.size()]));
        }

        protected final FunctionScope peekFunctionScope() {
            return this.functionScopes.peek();
        }

        public void enterFunctionScope() {
            this.functionScopes.push(new FunctionScope());
        }

        public void leaveFunctionScope(IRMethod method, FunctionStatement function) {
            FunctionScope scope = this.functionScopes.pop();
            if (method != null) {
                if (this.inconsistentReturns != null && method.getType() != null && TypeUtil.isUndefined(method.getType())) {
                    this.inconsistentReturns.remove(function);
                }
                if (!scope.returnNodes.isEmpty()) {
                    this.pushExpressionValidator(new TestReturnStatement(method, scope.returnNodes));
                } else if (!scope.throwsException && method.getType() != null && !TypeUtil.isUndefined(method.getType())) {
                    ReferenceLocation location = method.getLocation();
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchNoReturnType, (Object[])new String[]{method.getName(), TypeUtil.getName(method.getType())}), location.getNameStart(), location.getNameEnd());
                }
            }
        }

        @Override
        public IValueReference visitFunctionStatement(FunctionStatement node) {
            this.validateHidesByFunction(node);
            this.enterFunctionScope();
            IValueReference reference = super.visitFunctionStatement(node);
            IRMethod method = (IRMethod)reference.getAttribute("R_METHOD");
            this.leaveFunctionScope(method, node);
            return reference;
        }

        private void validateHidesByFunction(FunctionStatement node) {
            List args = node.getArguments();
            IValueCollection peekContext = this.peekContext();
            for (Argument argument : args) {
                IValueReference child = peekContext.getChild(argument.getArgumentName());
                if (!child.exists()) continue;
                if (child.getKind() == ReferenceKind.PROPERTY) {
                    Property property = (Property)child.getAttribute("ELEMENT");
                    if (property.isHideAllowed()) continue;
                    if (property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesPropertyOfType, (Object[])new String[]{argument.getArgumentName(), property.getDeclaringType().getName()}), argument.sourceStart(), argument.sourceEnd());
                        continue;
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesProperty, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                if (Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) continue;
                if (child.getKind() == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.ParameterHidesFunction, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesVariable, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
            }
            if (node.isDeclaration()) {
                IValueReference child;
                IValueCollection parentScope = ValidationVisitor.getParentScope(peekContext);
                if (parentScope == null) {
                    child = peekContext.getChild(node.getName().getName());
                    if (this.getSource().equals(child.getLocation().getSource())) {
                        return;
                    }
                } else {
                    child = parentScope.getChild(node.getName().getName());
                }
                if (child.exists()) {
                    if (child.getKind() == ReferenceKind.PROPERTY) {
                        Property property = (Property)child.getAttribute("ELEMENT");
                        if (!property.isHideAllowed()) {
                            if (property.getDeclaringType() != null) {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesPropertyOfType, (Object[])new String[]{node.getName().getName(), property.getDeclaringType().getName()}), node.getName().sourceStart(), node.getName().sourceEnd());
                            } else {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesProperty, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                            }
                        }
                    } else if (!Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) {
                        if (child.getKind() == ReferenceKind.FUNCTION) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.FunctionHidesFunction, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesVariable, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        }
                    }
                }
            }
        }

        @Override
        public IValueReference visitReturnStatement(ReturnStatement node) {
            IValueReference returnValueReference = super.visitReturnStatement(node);
            if (node.getValue() != null) {
                this.peekFunctionScope().returnNodes.add(new ReturnNode(node, returnValueReference));
            }
            return returnValueReference;
        }

        @Override
        public IValueReference visitThrowStatement(ThrowStatement node) {
            this.peekFunctionScope().throwsException = true;
            return super.visitThrowStatement(node);
        }

        @Override
        public IValueReference visitCallExpression(CallExpression node) {
            Expression expression = node.getExpression();
            this.modes.put((ASTNode)expression, VisitorMode.CALL);
            IValueReference reference = this.visit((ASTNode)expression);
            this.modes.remove(expression);
            if (reference == null) {
                this.visitList(node.getArguments());
                return null;
            }
            if (reference.getAttribute("PHANTOM", true) != null) {
                this.visitList(node.getArguments());
                return PhantomValueReference.REFERENCE;
            }
            if (ValidationVisitor.isUntyped(reference)) {
                this.visitList(node.getArguments());
                return null;
            }
            if (reference.getKind() == ReferenceKind.ARGUMENT && reference.getDeclaredTypes().contains(this.functionTypeRef)) {
                for (ASTNode argument : node.getArguments()) {
                    this.visit(argument);
                }
                return null;
            }
            List args = node.getArguments();
            IValueReference[] arguments = new IValueReference[args.size()];
            int i = 0;
            int size = args.size();
            while (i < size) {
                arguments[i] = this.visit((ASTNode)args.get(i));
                ++i;
            }
            List<Method> methods = JavaScriptValidations.extractElements(reference, Method.class);
            if (methods != null && methods.size() == 1 && methods.get(0) instanceof GenericMethod) {
                GenericMethod method = (GenericMethod)methods.get(0);
                if (!JavaScriptValidations.checkParameterCount(method, args.size())) {
                    Expression methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
                    this.reportMethodParameterError((ASTNode)methodNode, arguments, method);
                    return null;
                }
                JSTypeSet result = this.evaluateGenericCall(method, arguments);
                return result != null ? new ConstantValue(result) : null;
            }
            this.pushExpressionValidator(new CallExpressionValidator(this.peekFunctionScope(), node, reference, arguments, methods));
            return reference.getChild("()");
        }

        private void pushExpressionValidator(ExpressionValidator expressionValidator) {
            expressionValidator.setSuppressed(this.reporter.getSuppressWarnings());
            this.expressionValidators.add(expressionValidator);
        }

        protected void validateCallExpression(FunctionScope scope, CallExpression node, IValueReference reference, IValueReference[] arguments, List<Method> methods) {
            Expression expression = node.getExpression();
            Path path = ValidationVisitor.path(expression, reference);
            if (scope.contains(path)) {
                return;
            }
            Expression methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
            if (methods == null || methods.size() == 0) {
                methods = JavaScriptValidations.extractElements(reference, Method.class);
            }
            if (methods != null) {
                Method method = JavaScriptValidations.selectMethod(this.getContext(), methods, arguments, true);
                if (method == null) {
                    IRType type = JavaScriptValidations.typeOf(reference.getParent());
                    if (type != null && TypeUtil.kind(type) == TypeKind.JAVA) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_JAVA_PARAMETERS, NLS.bind((String)ValidationMessages.MethodNotSelected, (Object[])new String[]{reference.getName(), type.getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else {
                    this.validateCallExpressionMethod(node, reference, arguments, methodNode, method);
                }
                return;
            }
            Object attrRMethod = reference.getAttribute("R_METHOD", true);
            if (attrRMethod instanceof IRMethod) {
                this.validateCallExpressionRMethod(node, reference, arguments, methodNode, (IRMethod)attrRMethod);
                return;
            }
            IRType expressionType = JavaScriptValidations.typeOf(reference);
            if (expressionType != null) {
                Constructor constructor;
                Type target;
                if (expressionType instanceof IRFunctionType) {
                    this.validateCallExpressionRMethod(node, reference, arguments, methodNode, new RMethodFunctionWrapper((IRFunctionType)expressionType));
                    return;
                }
                if (expressionType instanceof IRClassType && (target = ((IRClassType)expressionType).getTarget()) != null && (constructor = target.getStaticConstructor()) != null) {
                    this.validateCallExpressionMethod(node, reference, arguments, methodNode, constructor);
                    return;
                }
            }
            if (!this.isArrayLookup((ASTNode)expression) && !this.isUntypedParameter(reference)) {
                scope.add(path);
                IRType type = JavaScriptValidations.typeOf(reference.getParent());
                if (type != null) {
                    if (TypeUtil.kind(type) == TypeKind.JAVA) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    } else if (JavaScriptValidations.isStatic(reference.getParent()) && this.hasInstanceMethod(type, reference.getName())) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INSTANCE_METHOD, NLS.bind((String)ValidationMessages.StaticReferenceToNoneStaticMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    } else if (!reference.exists()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodOnObject, (Object)reference.getName(), (Object)reference.getParent().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else {
                    IRType referenceType = JavaScriptValidations.typeOf(reference);
                    if (this.functionTypeRef.isAssignableFrom(referenceType) == TypeCompatibility.TRUE) {
                        return;
                    }
                    if (expression instanceof NewExpression) {
                        if (reference.getKind() == ReferenceKind.TYPE) {
                            return;
                        }
                        IRType newType = JavaScriptValidations.typeOf(reference);
                        if (newType != null) {
                            return;
                        }
                    }
                    IValueReference parent = reference;
                    while (parent != null) {
                        if (parent.getName() == "[]") {
                            return;
                        }
                        parent = parent.getParent();
                    }
                    if (expression instanceof NewExpression) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_TYPE_EXPRESSION, NLS.bind((String)ValidationMessages.UndefinedJavascriptType, (Object)((NewExpression)expression).getObjectClass().toSourceString("")), methodNode.sourceStart(), methodNode.sourceEnd());
                    } else if (reference.getParent() == null) {
                        if (ValidationVisitor.isIdentifier(expression) && !reference.exists()) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_FUNCTION, NLS.bind((String)ValidationMessages.UndefinedMethodInScript, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_FUNCTION, ValidationVisitor.isIdentifier(expression) ? NLS.bind((String)ValidationMessages.WrongFunction, (Object)reference.getName()) : ValidationMessages.WrongFunctionExpression, methodNode.sourceStart(), methodNode.sourceEnd());
                        }
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodOnObject, (Object)reference.getName(), (Object)reference.getParent().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                }
            }
        }

        private void validateCallExpressionRMethod(CallExpression node, IValueReference reference, IValueReference[] arguments, Expression methodNode, IRMethod method) {
            if (method.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            }
            this.validateAccessibility(node.getExpression(), reference, method);
            List<IRParameter> parameters = method.getParameters();
            TypeCompatibility compatibility = this.validateParameters(parameters, arguments, (ISourceNode)methodNode);
            if (compatibility != TypeCompatibility.TRUE) {
                Identifier identifier;
                String name = method.getName();
                if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                    name = identifier.getName();
                }
                JavaScriptProblems problemId = method.isTyped() ? (compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION) : JavaScriptProblems.WRONG_PARAMETERS_UNTYPED;
                this.reporter.reportProblem((IProblemIdentifier)problemId, NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArgTypes(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private void validateCallExpressionMethod(CallExpression node, IValueReference reference, IValueReference[] arguments, Expression methodNode, Method method) {
            IRType type;
            if (method.getVisibility() != Visibility.PUBLIC && !this.validateAccessibility((ASTNode)methodNode, method)) {
                return;
            }
            if (method.isDeprecated()) {
                this.reportDeprecatedMethod((ASTNode)methodNode, reference, method);
            }
            if (!JavaScriptValidations.checkParameterCount(method, node.getArguments().size())) {
                this.reportMethodParameterError((ASTNode)methodNode, arguments, method);
                return;
            }
            if (JavaScriptValidations.isStatic(reference.getParent()) && !method.isStatic()) {
                type = JavaScriptValidations.typeOf(reference.getParent());
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INSTANCE_METHOD, NLS.bind((String)ValidationMessages.StaticReferenceToNoneStaticMethod, (Object)reference.getName(), (Object)TypeUtil.getName(type)), methodNode.sourceStart(), methodNode.sourceEnd());
            } else if (reference.getParent() != null && !JavaScriptValidations.isStatic(reference.getParent()) && method.isStatic()) {
                type = JavaScriptValidations.typeOf(reference.getParent());
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.STATIC_METHOD, NLS.bind((String)ValidationMessages.ReferenceToStaticMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            }
            List<IRParameter> parameters = RModelBuilder.convert(this.getContext(), method.getParameters());
            TypeCompatibility compatibility = this.validateParameters(parameters, arguments, (ISourceNode)methodNode);
            if (compatibility != TypeCompatibility.TRUE) {
                Identifier identifier;
                String name = method.getName();
                if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                    name = identifier.getName();
                }
                this.reporter.reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION), NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArgTypes(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private boolean isUntypedParameter(IValueReference reference) {
            return reference.getKind() == ReferenceKind.ARGUMENT && reference.getDeclaredType() == null;
        }

        public static boolean isUntyped(IValueReference reference) {
            while (reference != null) {
                ReferenceKind kind = reference.getKind();
                if (kind == ReferenceKind.ARGUMENT) {
                    IRType type = reference.getDeclaredType();
                    if (type == null || type instanceof IRAnyType) {
                        return true;
                    }
                } else {
                    if (kind == ReferenceKind.THIS && reference.getDeclaredType() == null && reference.getDirectChildren().isEmpty()) {
                        return true;
                    }
                    if (kind == ReferenceKind.PROPERTY && reference.getDeclaredType() == null && reference.getDirectChildren().isEmpty()) {
                        return true;
                    }
                }
                reference = reference.getParent();
            }
            return false;
        }

        private boolean isThisCall(Expression expression) {
            return expression instanceof PropertyExpression && ((PropertyExpression)expression).getObject() instanceof ThisExpression && ((PropertyExpression)expression).getProperty() instanceof Identifier;
        }

        private boolean hasInstanceMethod(IRType type, String name) {
            return ElementValue.findMember(this.getContext(), type, name, MemberPredicate.NON_STATIC) != null;
        }

        private boolean isArrayLookup(ASTNode expression) {
            if (expression instanceof GetArrayItemExpression) {
                return true;
            }
            if (expression instanceof PropertyExpression) {
                return this.isArrayLookup((ASTNode)((PropertyExpression)expression).getObject());
            }
            return false;
        }

        private void reportDeprecatedMethod(ASTNode methodNode, IValueReference reference, Method method) {
            if (method.getDeclaringType() != null) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedMethod, (Object)reference.getName(), (Object)method.getDeclaringType().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedTopLevelMethod, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private void reportMethodParameterError(ASTNode methodNode, IValueReference[] arguments, Method method) {
            if (method.getDeclaringType() != null) {
                JavaScriptProblems problemId = JavaScriptProblems.WRONG_PARAMETERS;
                if (method.getDeclaringType().getKind() == TypeKind.JAVA) {
                    problemId = JavaScriptProblems.WRONG_JAVA_PARAMETERS;
                }
                this.reporter.reportProblem((IProblemIdentifier)problemId, NLS.bind((String)ValidationMessages.MethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), method.getDeclaringType().getName(), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)ValidationMessages.TopLevelMethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), this.describeArgTypes(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private TypeCompatibility validateParameters(List<IRParameter> parameters, IValueReference[] arguments, ISourceNode problemNode) {
            TypeCompatibility pResult;
            if (arguments.length > parameters.size() && (parameters.size() <= 0 || parameters.get(parameters.size() - 1).getKind() != ParameterKind.VARARGS)) {
                return TypeCompatibility.FALSE;
            }
            int testTypesSize = parameters.size();
            if (parameters.size() > arguments.length) {
                int i = arguments.length;
                while (i < parameters.size()) {
                    IRParameter p = parameters.get(i);
                    if (!p.isOptional() && !p.isVarargs()) {
                        return TypeCompatibility.FALSE;
                    }
                    ++i;
                }
                testTypesSize = arguments.length;
            } else if (parameters.size() < arguments.length) {
                testTypesSize = parameters.size() - 1;
            }
            ArrayList<ValidationStatus> statuses = null;
            TypeCompatibility result = TypeCompatibility.TRUE;
            int i = 0;
            while (i < testTypesSize) {
                IValueReference argument = arguments[i];
                IRParameter parameter = parameters.get(i);
                if (parameter.getType() instanceof IRTypeExtension) {
                    IValidationStatus status = ((IRTypeExtension)parameter.getType()).isAssignableFrom(argument);
                    if (status instanceof TypeCompatibility) {
                        pResult = (TypeCompatibility)status;
                        if (pResult.after(result)) {
                            if (pResult == TypeCompatibility.FALSE && statuses == null) {
                                return pResult;
                            }
                            result = pResult;
                        }
                    } else if (status instanceof ValidationStatus) {
                        if (statuses == null) {
                            statuses = new ArrayList<ValidationStatus>();
                        }
                        statuses.add((ValidationStatus)status);
                    } else if (status instanceof ValidationMultiStatus) {
                        if (statuses == null) {
                            statuses = new ArrayList();
                        }
                        Collections.addAll(statuses, ((ValidationMultiStatus)status).getChildren());
                    }
                } else if (parameter.getType() instanceof IRRecordType && argument != null && !(argument.getDeclaredType() instanceof IRRecordType)) {
                    boolean oneHit = false;
                    Set<String> argumentsChildren = argument.getDirectChildren();
                    for (IRRecordMember member : ((IRRecordType)parameter.getType()).getMembers()) {
                        if (argumentsChildren.contains(member.getName())) {
                            oneHit = true;
                            if (member.getType() == null) continue;
                            IValueReference child = argument.getChild(member.getName());
                            TypeCompatibility pResult2 = this.testArgumentType(member.getType(), child);
                            if (!pResult2.after(result)) continue;
                            if (pResult2 == TypeCompatibility.FALSE) {
                                return pResult2;
                            }
                            result = pResult2;
                            continue;
                        }
                        if (member.isOptional()) continue;
                        return TypeCompatibility.FALSE;
                    }
                    if (!oneHit) {
                        return TypeCompatibility.FALSE;
                    }
                } else {
                    TypeCompatibility pResult3 = this.testArgumentType(parameter.getType(), argument);
                    if (pResult3.after(result)) {
                        if (pResult3 == TypeCompatibility.FALSE && statuses == null) {
                            return pResult3;
                        }
                        result = pResult3;
                    }
                }
                ++i;
            }
            if (parameters.size() < arguments.length) {
                int varargsParameter = parameters.size() - 1;
                IRType paramType = parameters.get(varargsParameter).getType();
                int i2 = varargsParameter;
                while (i2 < arguments.length) {
                    IValueReference argument = arguments[i2];
                    pResult = this.testArgumentType(paramType, argument);
                    if (pResult.after(result)) {
                        if (pResult == TypeCompatibility.FALSE && statuses == null) {
                            return pResult;
                        }
                        result = pResult;
                    }
                    ++i2;
                }
            }
            if (statuses != null) {
                for (ValidationStatus status : statuses) {
                    int end;
                    int start;
                    if (status.hasRange()) {
                        start = status.start();
                        end = status.end();
                    } else {
                        start = problemNode.start();
                        end = problemNode.end();
                    }
                    this.reporter.reportProblem(status.identifier(), status.message(), start, end);
                }
                return TypeCompatibility.TRUE;
            }
            return result;
        }

        private TypeCompatibility testArgumentType(IRType paramType, IValueReference argument) {
            if (argument != null && paramType != null) {
                if (paramType instanceof IRRecordType) {
                    return TypeCompatibility.valueOf(this.testObjectPropertyType(argument, (IRRecordType)paramType) == null);
                }
                IRType argumentType = argument.getDeclaredType();
                if (argumentType == null && !argument.getTypes().isEmpty()) {
                    argumentType = argument.getTypes().getFirst();
                }
                if (argumentType != null) {
                    return paramType.isAssignableFrom(argumentType);
                }
            }
            return TypeCompatibility.TRUE;
        }

        protected String testObjectPropertyType(IValueReference reference, IRRecordType type) {
            for (IRRecordMember member : type.getMembers()) {
                IValueReference child = reference.getChild(member.getName());
                IRType referenceType = JavaScriptValidations.typeOf(child);
                if (child.exists() && (referenceType == null || member.getType() == null || member.getType().isAssignableFrom(referenceType).ok())) continue;
                Set<String> children = reference.getDirectChildren();
                if (children.size() == 0) {
                    return "{}";
                }
                StringBuilder typeString = new StringBuilder();
                typeString.append('{');
                for (String childName : children) {
                    typeString.append(childName);
                    typeString.append(':');
                    IRType childType = JavaScriptValidations.typeOf(reference.getChild(childName));
                    String typeName = TypeUtil.getName(childType);
                    typeString.append(typeName == null ? "Object" : typeName);
                    typeString.append(',');
                }
                typeString.setLength(typeString.length() - 1);
                typeString.append('}');
                return typeString.toString();
            }
            return null;
        }

        private String describeParamTypes(EList<Parameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getKind() == ParameterKind.OPTIONAL) {
                    sb.append('[');
                }
                if (parameter.getType() != null) {
                    sb.append(parameter.getType().getName());
                } else {
                    sb.append('?');
                }
                if (parameter.getKind() == ParameterKind.OPTIONAL) {
                    sb.append(']');
                }
                if (parameter.getKind() != ParameterKind.VARARGS) continue;
                sb.append("...");
            }
            return sb.toString();
        }

        private String describeParamTypes(List<IRParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (IRParameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getType() instanceof IRRecordType) {
                    sb.append('{');
                    for (IRRecordMember member : ((IRRecordType)parameter.getType()).getMembers()) {
                        boolean optional;
                        if (sb.length() > 1) {
                            sb.append(", ");
                        }
                        if (optional = member.isOptional()) {
                            sb.append('[');
                        }
                        sb.append(member.getName());
                        if (member.getType() != null) {
                            sb.append(':');
                            sb.append(member.getType().getName());
                        }
                        if (!optional) continue;
                        sb.append(']');
                    }
                    sb.append('}');
                    continue;
                }
                if (parameter.getType() != null) {
                    if (parameter.getKind() == ParameterKind.OPTIONAL) {
                        sb.append("[");
                    }
                    if (parameter.getKind() == ParameterKind.VARARGS) {
                        sb.append("...");
                    }
                    sb.append(parameter.getType().getName());
                    if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
                    sb.append("]");
                    continue;
                }
                sb.append('?');
            }
            return sb.toString();
        }

        private String describeArgTypes(IValueReference[] arguments) {
            return this.describeArgTypes(arguments, Collections.<IRParameter>emptyList());
        }

        private String describeArgTypes(IValueReference[] arguments, List<IRParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < arguments.length) {
                IRParameter parameter;
                IValueReference argument = arguments[i];
                IRParameter iRParameter = parameter = parameters.size() > i ? parameters.get(i) : null;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (argument == null) {
                    sb.append("null");
                } else if (parameter != null && parameter.getType() instanceof IRRecordType) {
                    this.describeRecordType(sb, argument, (IRRecordType)parameter.getType());
                } else if (argument.getDeclaredType() != null) {
                    sb.append(argument.getDeclaredType().getName());
                } else {
                    JSTypeSet types = argument.getTypes();
                    if (types.size() == 1) {
                        sb.append(types.getFirst().getName());
                    } else {
                        sb.append('?');
                    }
                }
                ++i;
            }
            return sb.toString();
        }

        private void describeRecordType(StringBuilder sb, IValueReference argument, IRRecordType paramType) {
            Set<String> directChildren = argument.getDirectChildren();
            sb.append('{');
            boolean appendComma = false;
            for (String childName : directChildren) {
                if (appendComma) {
                    sb.append(", ");
                }
                appendComma = true;
                sb.append(childName);
                IRType memberType = null;
                if (paramType != null) {
                    for (IRRecordMember member : paramType.getMembers()) {
                        if (!member.getName().equals(childName)) continue;
                        memberType = member.getType();
                        break;
                    }
                }
                if (memberType instanceof IRRecordType) {
                    sb.append(": ");
                    this.describeRecordType(sb, argument.getChild(childName), (IRRecordType)memberType);
                    continue;
                }
                IValueReference child = argument.getChild(childName);
                IRType type = JavaScriptValidations.typeOf(child);
                if (type == null) continue;
                if (paramType != null && type.getName().equals("Object") && !child.getDirectChildren().isEmpty()) {
                    sb.append(": ");
                    this.describeRecordType(sb, child, null);
                    continue;
                }
                sb.append(':');
                sb.append(type.getName());
            }
            sb.append('}');
        }

        private <E extends Member> E extractElement(IValueReference reference, Class<E> elementType, Boolean staticModifierValue) {
            List<Member> elements = JavaScriptValidations.extractElements(reference, elementType);
            if (staticModifierValue != null && elements != null && elements.size() > 1) {
                for (Member e : elements) {
                    if (e.isStatic() != staticModifierValue.booleanValue()) continue;
                    return (E)e;
                }
            }
            return (E)(elements != null ? elements.get(0) : null);
        }

        @Override
        public IValueReference visitPropertyExpression(PropertyExpression node) {
            IValueReference result = super.visitPropertyExpression(node);
            if (result == null || result.getAttribute("PHANTOM", true) != null || ValidationVisitor.isUntyped(result)) {
                return result;
            }
            if (this.currentMode() != VisitorMode.CALL) {
                this.pushExpressionValidator(new PropertyExpressionHolder(this.peekFunctionScope(), node, result, result.exists()));
            }
            return result;
        }

        @Override
        protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
            if (left != null) {
                this.checkAssign(left, (ASTNode)node);
                this.validate(this.peekFunctionScope(), node.getLeftExpression(), left);
            }
            return super.visitAssign(left, right, node);
        }

        protected boolean validate(FunctionScope scope, Expression expr, IValueReference reference) {
            IValueReference parent = reference.getParent();
            if (parent == null) {
                if (expr instanceof Identifier && !reference.exists()) {
                    scope.add(ValidationVisitor.path(expr, reference));
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDECLARED_VARIABLE, NLS.bind((String)ValidationMessages.UndeclaredVariable, (Object)reference.getName()), expr.sourceStart(), expr.sourceEnd());
                    return false;
                }
                this.validateAccessibility(expr, reference, null);
            } else if (expr instanceof PropertyExpression && this.validate(scope, ((PropertyExpression)expr).getObject(), parent)) {
                IRType type = JavaScriptValidations.typeOf(parent);
                if (type != null && TypeUtil.kind(type) == TypeKind.JAVA && !reference.exists()) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)reference.getName(), (Object)type.getName()), expr.sourceStart(), expr.sourceEnd());
                    return false;
                }
            } else if (expr instanceof GetArrayItemExpression && !this.validate(scope, ((GetArrayItemExpression)expr).getArray(), parent)) {
                return false;
            }
            return true;
        }

        private static boolean isVarOrFunction(IValueReference reference) {
            ReferenceKind kind = reference.getKind();
            return kind.isVariable() || kind == ReferenceKind.FUNCTION;
        }

        private static boolean isAccess(Identifier node) {
            return ValidationVisitor.isAccess(node, node.getParent());
        }

        private static boolean isAccess(Identifier node, ASTNode parent) {
            if (parent instanceof BinaryOperation) {
                return !((BinaryOperation)parent).isAssignmentTo((Expression)node);
            }
            if (parent instanceof StatementBlock || parent instanceof Script) {
                return false;
            }
            if (parent instanceof UnaryOperation) {
                UnaryOperation operation = (UnaryOperation)parent;
                int op = operation.getOperation();
                return op != 90 && op != 91 && op != 147 && op != 146 || ValidationVisitor.isAccess(node, operation.getParent());
            }
            return true;
        }

        @Override
        public IValueReference visitIdentifier(Identifier node) {
            Property property;
            IValueReference result = super.visitIdentifier(node);
            if (ValidationVisitor.isAccess(node) && ValidationVisitor.isVarOrFunction(result) && this.getSource().equals(result.getLocation().getSource()) && result.getAttribute(IReferenceAttributes.ACCESS) == null) {
                result.setAttribute(IReferenceAttributes.ACCESS, Boolean.TRUE);
            }
            if ((property = this.extractElement(result, Property.class, null)) != null && property.isDeprecated()) {
                this.reportDeprecatedProperty(property, null, (ASTNode)node);
            } else if (!(result.exists() || node.getParent() instanceof CallExpression && ((CallExpression)node.getParent()).getExpression() == node)) {
                this.pushExpressionValidator(new NotExistingIdentiferValidator(this.peekFunctionScope(), (Expression)node, result));
            } else {
                this.validateAccessibility((Expression)node, result, null);
                if (result.exists() && node.getParent() instanceof BinaryOperation && ((BinaryOperation)node.getParent()).getOperation() == 21 && ((BinaryOperation)node.getParent()).getRightExpression() == node) {
                    this.checkTypeReference((ASTNode)node, JavaScriptValidations.typeOf(result), this.peekContext());
                }
            }
            return result;
        }

        private static IValueCollection getParentScope(IValueCollection collection) {
            IValueCollection c = collection;
            while (c != null && !c.isScope()) {
                c = c.getParent();
            }
            if (c != null && (c = c.getParent()) != null) {
                return c;
            }
            return null;
        }

        @Override
        protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
            this.validateHidesByVariable(context, declaration);
            IValueReference variable = super.createVariable(context, declaration);
            if (context.getParent() != null || this.canValidateUnusedVariable(context, variable)) {
                this.variables.add(variable);
            }
            return variable;
        }

        private boolean canValidateUnusedVariable(IValueCollection collection, IValueReference reference) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidatorExtension.UnusedVariableValidation result = extension.canValidateUnusedVariable(collection, reference);
                    if (result != null) {
                        return result == IValidatorExtension.UnusedVariableValidation.TRUE;
                    }
                    ++n2;
                }
            }
            return ValidationVisitor.isPrivate(reference);
        }

        private static boolean isPrivate(IValueReference reference) {
            return ((IRVariable)reference.getAttribute("R_VARIABLE")).isPrivate();
        }

        private void checkAssign(IValueReference reference, ASTNode node) {
            Object value = reference.getAttribute(IAssignProtection.ATTRIBUTE);
            if (value != null) {
                IAssignProtection assign = value instanceof IAssignProtection ? (IAssignProtection)value : PROTECT_CONST;
                this.reporter.reportProblem(assign.problemId(), assign.problemMessage(), node.sourceStart(), node.sourceEnd());
            }
        }

        @Override
        protected void initializeVariable(IValueReference reference, VariableDeclaration declaration, IModelBuilder.IVariable variable) {
            if (declaration.getInitializer() != null) {
                this.checkAssign(reference, (ASTNode)declaration);
            }
            super.initializeVariable(reference, declaration, variable);
        }

        private void validateHidesByVariable(IValueCollection context, VariableDeclaration declaration) {
            IValueReference child;
            Identifier identifier = declaration.getIdentifier();
            IValueCollection parentScope = ValidationVisitor.getParentScope(context);
            if (parentScope == null) {
                child = context.getChild(identifier.getName());
                if (this.getSource().equals(child.getLocation().getSource())) {
                    return;
                }
            } else {
                child = parentScope.getChild(identifier.getName());
            }
            if (child.exists()) {
                if (child.getKind() == ReferenceKind.ARGUMENT) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PARAMETER, NLS.bind((String)ValidationMessages.VariableHidesParameter, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (child.getKind() == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.VariableHidesFunction, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (child.getKind() == ReferenceKind.PROPERTY) {
                    Property property = (Property)child.getAttribute("ELEMENT");
                    if (property != null && property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesPropertyOfType, (Object)declaration.getVariableName(), (Object)property.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesProperty, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else if (child.getKind() == ReferenceKind.METHOD) {
                    Method method = (Method)child.getAttribute("ELEMENT");
                    if (method != null && method.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethodOfType, (Object)declaration.getVariableName(), (Object)method.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethod, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DUPLICATE_VAR_DECLARATION, NLS.bind((String)ValidationMessages.VariableHidesVariable, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                }
            }
        }

        protected void validateProperty(FunctionScope scope, PropertyExpression propertyExpression, IValueReference result, boolean exists) {
            Path path = ValidationVisitor.path((Expression)propertyExpression, result);
            if (scope.contains(path)) {
                return;
            }
            Expression propName = propertyExpression.getProperty();
            Member member = this.extractElement(result, Member.class, null);
            if (member != null) {
                if (member.isDeprecated()) {
                    Property parentProperty = this.extractElement(result.getParent(), Property.class, null);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof Property) {
                            this.reportDeprecatedProperty((Property)member, parentProperty, (ASTNode)propName);
                        } else if (member instanceof Method) {
                            this.reportDeprecatedMethod((ASTNode)propName, result, (Method)member);
                        }
                    } else if (member instanceof Property) {
                        this.reportDeprecatedProperty((Property)member, member.getDeclaringType(), (ASTNode)propName);
                    } else if (member instanceof Method) {
                        this.reportDeprecatedMethod((ASTNode)propName, result, (Method)member);
                    }
                } else if (!member.isVisible()) {
                    Property parentProperty = this.extractElement(result.getParent(), Property.class, null);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof Property) {
                            this.reportHiddenProperty((Property)member, parentProperty, (ASTNode)propName);
                        }
                    } else if (member instanceof Property) {
                        this.reportHiddenProperty((Property)member, member.getDeclaringType(), (ASTNode)propName);
                    }
                } else if (member.getVisibility() != Visibility.PUBLIC) {
                    this.validateAccessibility((ASTNode)propName, member);
                }
            } else if (!(exists || result.exists() || this.isArrayLookup((ASTNode)propertyExpression))) {
                scope.add(path);
                IRType type = JavaScriptValidations.typeOf(result.getParent());
                TypeKind kind = TypeUtil.kind(type);
                if (type != null && kind == TypeKind.JAVA) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
                } else if (type != null && this.shouldBeDefined(propertyExpression) && (kind == TypeKind.JAVASCRIPT || kind == TypeKind.PREDEFINED)) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScriptType, (Object)result.getName(), (Object)type.getName()), propName.sourceStart(), propName.sourceEnd());
                } else if (this.shouldBeDefined(propertyExpression)) {
                    String parentPath = PropertyExpressionUtils.getPath((Expression)propertyExpression.getObject());
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScript, (Object)result.getName(), (Object)(parentPath != null ? parentPath : "javascript")), propName.sourceStart(), propName.sourceEnd());
                }
            } else {
                IRVariable variable = (IRVariable)result.getAttribute("R_VARIABLE");
                if (variable != null) {
                    if (variable.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_VARIABLE, NLS.bind((String)ValidationMessages.DeprecatedVariable, (Object)variable.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    this.validateAccessibility((Expression)propertyExpression, result, variable);
                    return;
                }
                IRMethod method = (IRMethod)result.getAttribute("R_METHOD");
                if (method != null) {
                    if (method.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)method.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    this.validateAccessibility((Expression)propertyExpression, result, method);
                    return;
                }
            }
        }

        private boolean shouldBeDefined(PropertyExpression propertyExpression) {
            if (propertyExpression.getParent() instanceof BinaryOperation) {
                BinaryOperation bo = (BinaryOperation)propertyExpression.getParent();
                return bo.getOperation() != 100 && bo.getOperation() != 101;
            }
            return true;
        }

        private void reportDeprecatedProperty(Property property, Element owner, ASTNode node) {
            String msg = owner instanceof Type ? NLS.bind((String)ValidationMessages.DeprecatedProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof Property ? NLS.bind((String)ValidationMessages.DeprecatedPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.DeprecatedPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private void reportHiddenProperty(Property property, Element owner, ASTNode node) {
            String msg = owner instanceof Type ? NLS.bind((String)ValidationMessages.HiddenProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof Property ? NLS.bind((String)ValidationMessages.HiddenPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.HiddenPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.HIDDEN_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private static boolean isIdentifier(Expression node) {
            return node instanceof Identifier || node instanceof CallExpression && ValidationVisitor.isIdentifier(((CallExpression)node).getExpression());
        }

        private static Identifier getIdentifier(Expression node) {
            if (node instanceof Identifier) {
                return (Identifier)node;
            }
            if (node instanceof CallExpression) {
                return ValidationVisitor.getIdentifier(((CallExpression)node).getExpression());
            }
            return null;
        }

        private Type extractClassType(IValueReference typeReference) {
            JSTypeSet types;
            IRType type = typeReference.getDeclaredType();
            if (type == null && (types = typeReference.getTypes()).size() > 0) {
                type = types.getFirst();
            }
            if (type != null && type instanceof IRClassType) {
                return ((IRClassType)type).getTarget();
            }
            return null;
        }

        protected void validateNewExpression(FunctionScope scope, IValueCollection collection, Expression node, IValueReference reference, IValueReference typeReference, IValueReference[] arguments) {
            Identifier problemNode;
            Identifier identifier = ValidationVisitor.getIdentifier(node);
            Object object = problemNode = identifier != null ? identifier : node;
            if (typeReference.getParent() == null && ValidationVisitor.isIdentifier(node) && !typeReference.exists()) {
                scope.add(ValidationVisitor.path(node, typeReference));
                this.reportUnknownType(JavaScriptProblems.UNDECLARED_VARIABLE, (ASTNode)problemNode, identifier != null ? identifier.getName() : "?");
                return;
            }
            Type type = this.extractClassType(typeReference);
            if (type != null) {
                if (type.getKind() != TypeKind.UNKNOWN) {
                    if (!this.validateInstantiability((ASTNode)problemNode, type, typeReference)) {
                        return;
                    }
                    this.checkTypeReference((ASTNode)problemNode, type);
                    List<Constructor> constructors = TypeUtil.findConstructors(type);
                    if (!constructors.isEmpty()) {
                        ITypeInferenceContext typeSystem = this.getContext();
                        Constructor constructor = JavaScriptValidations.selectMethod(typeSystem, constructors, arguments, false);
                        if (constructor == null) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)"The constructor {0}({1}) is undefined", (Object[])new String[]{typeReference.getName(), this.describeArgTypes(arguments)}), problemNode.sourceStart(), problemNode.sourceEnd());
                            return;
                        }
                        if (constructor.isDeprecated()) {
                            this.reportDeprecatedMethod((ASTNode)problemNode, typeReference, constructor);
                        }
                        typeSystem.pushAttribute(MEMBER_OWNER, type);
                        List<IRParameter> parameters = RModelBuilder.convert(typeSystem, constructor.getParameters());
                        typeSystem.popAttribute(MEMBER_OWNER);
                        TypeCompatibility compatibility = this.validateParameters(parameters, arguments, (ISourceNode)problemNode);
                        if (compatibility != TypeCompatibility.TRUE) {
                            this.reporter.reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION), NLS.bind((String)"The constructor {0}({1}) is not applicable for the arguments ({2})", (Object[])new String[]{typeReference.getName(), this.describeParamTypes(parameters), this.describeArgTypes(arguments, parameters)}), problemNode.sourceStart(), problemNode.sourceEnd());
                        }
                    }
                }
            } else {
                String lazyName = ValueReferenceUtil.getLazyName(reference);
                if (lazyName != null) {
                    this.reportUnknownType(JavaScriptProblems.WRONG_TYPE_EXPRESSION, ValidationMessages.UndefinedJavascriptType, (ASTNode)node, lazyName);
                }
            }
        }

        protected void checkTypeReference(ASTNode node, IRType type, IValueCollection collection) {
            Type t;
            if (type == null) {
                return;
            }
            if (type instanceof IRClassType && (t = ((IRClassType)type).getTarget()) != null && t.getKind() != TypeKind.UNKNOWN) {
                this.checkTypeReference(node, t);
            }
        }

        private void checkTypeReference(ASTNode node, Type t) {
            if (t.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)t.getName()), node.sourceStart(), node.sourceEnd());
            }
        }

        private boolean validateInstantiability(ASTNode node, Type type, IValueReference typeReference) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.canInstantiate(type, typeReference);
                    if (result != null) {
                        this.reportValidationStatus(result, node, JavaScriptProblems.NON_INSTANTIABLE_TYPE, ValidationMessages.NonInstantiableType, type.getName());
                        return false;
                    }
                    ++n2;
                }
            }
            if (!type.isInstantiable()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.NON_INSTANTIABLE_TYPE, NLS.bind((String)ValidationMessages.NonInstantiableType, (Object)type.getName()), node.sourceStart(), node.sourceEnd());
                return false;
            }
            return true;
        }

        private void reportValidationStatus(IValidationStatus result, ASTNode node, JavaScriptProblems defaultProblemId, String defaultMessage, String name) {
            if (result instanceof ValidationStatus) {
                int end;
                int start;
                ValidationStatus status = (ValidationStatus)result;
                if (status.hasRange()) {
                    start = status.start();
                    end = status.end();
                } else {
                    start = node.sourceStart();
                    end = node.sourceEnd();
                }
                this.reporter.reportProblem(status.identifier(), status.message(), start, end);
            } else if (result instanceof IProblemIdentifier) {
                this.reporter.reportProblem((IProblemIdentifier)result, NLS.bind((String)defaultMessage, (Object)name), node.sourceStart(), node.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)defaultProblemId, String.valueOf(NLS.bind((String)defaultMessage, (Object)name)) + ": " + result, node.sourceStart(), node.sourceEnd());
            }
        }

        private boolean validateAccessibility(ASTNode node, Member member) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.validateAccessibility(node, member);
                    if (result != null) {
                        this.reportValidationStatus(result, node, JavaScriptProblems.INACCESSIBLE_MEMBER, ValidationMessages.InaccessibleMember, member.getName());
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void validateAccessibility(Expression expression, IValueReference reference, IRMember member) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.validateAccessibility(expression, reference, member);
                    if (result != null) {
                        this.reportValidationStatus(result, (ASTNode)expression, JavaScriptProblems.INACCESSIBLE_MEMBER, ValidationMessages.InaccessibleMember, member.getName());
                        return;
                    }
                    ++n2;
                }
            }
        }

        public void reportUnknownType(IProblemIdentifier identifier, String message, ASTNode node, String name) {
            this.reporter.reportProblem(identifier, NLS.bind((String)message, (Object)name), node.sourceStart(), node.sourceEnd());
        }

        public void reportUnknownType(IProblemIdentifier identifier, ASTNode node, String name) {
            this.reportUnknownType(identifier, ValidationMessages.UnknownType, node, name);
        }

        private boolean stronglyTyped(IValueReference reference) {
            IRType parentType = JavaScriptValidations.typeOf(reference.getParent());
            if (parentType != null) {
                if (parentType instanceof IRRecordType) {
                    return true;
                }
                return TypeUtil.kind(parentType) == TypeKind.JAVA;
            }
            return false;
        }

        @Override
        public IValueReference visitIfStatement(IfStatement node) {
            IValueReference condition = this.visit((ASTNode)node.getCondition());
            if (condition != null && !condition.exists() && node.getCondition() instanceof PropertyExpression && !this.stronglyTyped(condition)) {
                condition.setValue(PhantomValueReference.REFERENCE);
            }
            this.visitIfStatements(node);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VisitorMode {
        NORMAL,
        CALL;

    }
}

