/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemCategory;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension3;
import org.eclipse.dltk.core.builder.IBuildParticipantFilter;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.internal.core.builder.BuildParticipantManager;
import org.eclipse.dltk.internal.core.builder.BuildProblemReporter;
import org.eclipse.dltk.internal.core.builder.BuildUtils;
import org.eclipse.dltk.internal.core.builder.ExternalModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.SourceModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.SubTaskProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardScriptBuilder
implements IScriptBuilder {
    private static final boolean DEBUG = false;
    private static final int WORK_BUILD = 100;
    private List<IProblemReporter> reporters = null;
    private boolean beginBuildDone = false;
    private boolean endBuildNeeded = false;
    private IBuildParticipant[] participants = null;
    private IBuildParticipantFilter[] filters = null;
    private IDLTKLanguageToolkit toolkit = null;
    private IProblemFactory problemFactory = null;

    @Override
    public void prepare(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
        if (this.participants != null) {
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (participant instanceof IBuildParticipantExtension2) {
                    ((IBuildParticipantExtension2)((Object)participant)).prepare(change, state);
                }
                ++i;
            }
        }
    }

    @Override
    public void build(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
        List<IFile> resourceChanges;
        this.buildExternalElements(change, monitor);
        if (this.toolkit != null) {
            this.buildNatureModules(change.getScriptProject(), change.getBuildType(), change.getSourceModules(0), monitor);
        }
        if (!(resourceChanges = change.getResources(0)).isEmpty()) {
            this.buildResources(resourceChanges, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private IStatus buildModelElements(IScriptProject project, List<ISourceModule> elements, IProgressMonitor monitor, int buildType) {
        monitor.beginTask("", 100);
        try {
            this.buildModules(project, elements, buildType, BuildUtils.subMonitorFor(monitor, 100));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void buildExternalElements(IBuildChange change, IProgressMonitor monitor) throws CoreException {
        int buildType = change.getBuildType();
        this.beginBuild(buildType, monitor);
        List<IBuildParticipantExtension2> extensions = this.selectExtension(IBuildParticipantExtension2.class);
        if (extensions != null) {
            List<ISourceModule> externalElements = change.getExternalModules(0);
            int remainingWork = externalElements.size();
            for (ISourceModule module : externalElements) {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildExternalModuleSubTask, (Object)String.valueOf(remainingWork), (Object)module.getElementName()));
                ExternalModuleBuildContext context = new ExternalModuleBuildContext(module, buildType);
                try {
                    int i = 0;
                    while (i < extensions.size()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        extensions.get(i).buildExternalModule(context);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorBuildingExternalModule, (Object)module.getElementName()), e);
                }
                --remainingWork;
            }
        }
    }

    private <T> List<T> selectExtension(Class<T> clazz) {
        if (this.participants != null) {
            int count = 0;
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (clazz.isInstance(participant)) {
                    ++count;
                }
                ++i;
            }
            if (count != 0) {
                ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>(count);
                int i2 = 0;
                while (i2 < this.participants.length) {
                    IBuildParticipant participant = this.participants[i2];
                    if (clazz.isInstance(participant)) {
                        IBuildParticipant casted = participant;
                        result.add(casted);
                    }
                    ++i2;
                }
                return result;
            }
        }
        return null;
    }

    private void buildModules(IScriptProject project, List<ISourceModule> elements, int buildType, IProgressMonitor monitor) {
        long startTime = 0L;
        monitor.beginTask(Messages.ValidatorBuilder_buildingModules, elements.size());
        if (this.toolkit != null) {
            this.buildNatureModules(project, buildType, elements, monitor);
        }
        monitor.done();
    }

    private void buildNatureModules(IScriptProject project, int buildType, List<ISourceModule> modules, IProgressMonitor monitor) {
        this.beginBuild(buildType, monitor);
        if (this.participants.length == 0) {
            return;
        }
        int counter = 0;
        if (this.reporters == null) {
            this.reporters = new ArrayList<IProblemReporter>(modules.size());
        }
        Iterator<ISourceModule> j = modules.iterator();
        while (j.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ISourceModule module = j.next();
            monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildModuleSubTask, (Object)String.valueOf(modules.size() - counter), (Object)module.getElementName()));
            SourceModuleBuildContext context = new SourceModuleBuildContext(this.problemFactory, module, buildType);
            if (context.reporter != null) {
                this.buildModule(context);
                this.reporters.add(context.reporter);
            }
            monitor.worked(1);
            ++counter;
        }
    }

    private void beginBuild(int buildType, IProgressMonitor monitor) {
        if (!this.beginBuildDone) {
            monitor.subTask(Messages.ValidatorBuilder_InitializeBuilders);
            this.endBuildNeeded = false;
            int count = 0;
            int j = 0;
            while (j < this.participants.length) {
                boolean useParticipant;
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    useParticipant = ((IBuildParticipantExtension)((Object)participant)).beginBuild(buildType);
                    this.endBuildNeeded = true;
                } else {
                    useParticipant = true;
                }
                if (useParticipant) {
                    if (count < j) {
                        this.participants[count] = this.participants[j];
                    }
                    ++count;
                }
                ++j;
            }
            this.participants = BuildParticipantManager.copyFirst(this.participants, count);
            this.beginBuildDone = true;
        }
    }

    private void buildModule(IBuildContext context) {
        IBuildParticipant[] selected = this.participants;
        IBuildParticipantFilter[] iBuildParticipantFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildParticipantFilter filter = iBuildParticipantFilterArray[n2];
            if ((selected = filter.filter(selected, context)) == null || selected.length == 0) {
                return;
            }
            ++n2;
        }
        try {
            int k = 0;
            while (k < selected.length) {
                selected[k].build(context);
                ++k;
            }
        }
        catch (CoreException e) {
            DLTKCore.error(Messages.StandardScriptBuilder_errorBuildingModule, e);
        }
    }

    protected IStatus buildResources(List<IFile> resources, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", resources.size());
            try {
                for (IFile resource : resources) {
                    monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_clearingResourceMarkers, (Object)resource.getName()));
                    this.problemFactory.deleteMarkers((IResource)resource);
                    monitor.worked(1);
                }
            }
            catch (CoreException e) {
                String msg = Messages.ValidatorBuilder_errorDeleteResourceMarkers;
                DLTKCore.error(msg, e);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void clean(IScriptProject project, IProgressMonitor monitor) {
        List<IBuildParticipantExtension3> extensions = this.selectExtension(IBuildParticipantExtension3.class);
        if (extensions != null) {
            for (IBuildParticipantExtension3 extension : extensions) {
                extension.clean();
            }
        }
        IProject p = project.getProject();
        try {
            this.problemFactory.deleteMarkers((IResource)p);
        }
        catch (CoreException e) {
            DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorCleaning, (Object)p.getName()), e);
        }
    }

    protected IDLTKLanguageToolkit getLanguageToolkit() {
        return this.toolkit;
    }

    @Override
    public boolean initialize(IScriptProject project) {
        this.toolkit = project.getLanguageToolkit();
        if (this.toolkit != null) {
            this.participants = BuildParticipantManager.getBuildParticipants(project, this.toolkit.getNatureId());
        }
        if (this.participants == null || this.participants.length == 0) {
            return false;
        }
        this.filters = BuildParticipantManager.getFilters(project, this.toolkit.getNatureId(), this);
        this.problemFactory = this.createProblemFactory();
        this.beginBuildDone = false;
        this.endBuildNeeded = false;
        return true;
    }

    protected IProblemFactory createProblemFactory() {
        if (this.toolkit != null) {
            return DLTKLanguageManager.getProblemFactory(this.toolkit.getNatureId());
        }
        return new DefaultProblemFactory();
    }

    @Override
    public void endBuild(IScriptProject project, IBuildState state, IProgressMonitor monitor) {
        if (this.endBuildNeeded) {
            monitor.subTask(Messages.ValidatorBuilder_finalizeBuild);
            SubTaskProgressMonitor finalizeMonitor = new SubTaskProgressMonitor(monitor, Messages.ValidatorBuilder_finalizeBuild);
            int j = 0;
            while (j < this.participants.length) {
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)finalizeMonitor);
                }
                ++j;
            }
            this.endBuildNeeded = false;
        }
        if (this.reporters != null) {
            IProblemSeverityTranslator severityTranslator = this.problemFactory.createSeverityTranslator(project);
            for (IProblemReporter reporter : this.reporters) {
                BuildProblemReporter buildReporter = (BuildProblemReporter)reporter;
                if (buildReporter.hasCategory(ProblemCategory.IMPORT)) {
                    state.recordImportProblem(buildReporter.resource.getFullPath());
                }
                buildReporter.flush(severityTranslator);
            }
            this.reporters = null;
        }
        this.participants = null;
        this.filters = null;
        this.toolkit = null;
        this.problemFactory = null;
        this.beginBuildDone = false;
    }
}

