/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.AbstractBuildChange;
import org.eclipse.dltk.internal.core.builder.BuildChange;
import org.eclipse.dltk.internal.core.builder.BuildStateStub;
import org.eclipse.dltk.internal.core.builder.FullBuildChange;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilderUtil {
    private static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    public static void build(List<IFile> files, IProgressMonitor monitor) throws CoreException {
        HashMap<IProject, LinkedHashSet<IFile>> byProject = new HashMap<IProject, LinkedHashSet<IFile>>();
        for (IFile file : files) {
            LinkedHashSet<IFile> projectFiles = (LinkedHashSet<IFile>)byProject.get(file.getProject());
            if (projectFiles == null) {
                projectFiles = new LinkedHashSet<IFile>();
                byProject.put(file.getProject(), projectFiles);
            }
            projectFiles.add(file);
        }
        LocalScriptBuilder builder = new LocalScriptBuilder();
        for (Map.Entry entry : byProject.entrySet()) {
            builder.build((IProject)entry.getKey(), new ArrayList<IFile>((Collection)entry.getValue()), ScriptBuilderUtil.monitorFor(monitor));
        }
    }

    public static void build(IProject project, Class<? extends IScriptBuilder> builderClass, IProgressMonitor monitor) throws CoreException {
        SingleBuilderRunner builder = new SingleBuilderRunner(builderClass);
        builder.build(project, ScriptBuilderUtil.monitorFor(monitor));
    }

    public static void rebuildAfterUpgrade(IProgressMonitor _monitor) throws CoreException {
        final UpgradeCheck check = new UpgradeCheck();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (ScriptBuilder.DEBUG) {
                    System.out.println("Upgrade check BEGIN");
                }
                IScriptProject[] projects = DLTKCore.create(ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.length);
                IScriptProject[] iScriptProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptProject project = iScriptProjectArray[n2];
                    check.checkProject(project, (IProgressMonitor)subMonitor.newChild(1));
                    ++n2;
                }
                if (ScriptBuilder.DEBUG) {
                    System.out.println("Upgrade check END");
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, _monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalScriptBuilder
    extends ScriptBuilder {
        public void build(IProject project, List<IFile> files, IProgressMonitor monitor) throws CoreException {
            this.currentProject = project;
            this.scriptProject = (ScriptProject)DLTKCore.create(project);
            BuildStateStub buildState = new BuildStateStub(project.getName());
            IScriptBuilder[] builders = null;
            try {
                IScriptBuilder builder;
                monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                monitor.beginTask("", 100);
                builders = this.getScriptBuilders();
                if (builders == null || builders.length == 0) {
                    return;
                }
                AbstractBuildChange buildChange = new BuildChange(project, null, files, monitor);
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.prepare((IBuildChange)((Object)buildChange), buildState, monitor);
                    if (buildChange.getBuildType() == 1 && buildChange instanceof BuildChange) {
                        buildChange = new FullBuildChange(this.currentProject, monitor);
                    }
                    ++n2;
                }
                iScriptBuilderArray = builders;
                n = builders.length;
                n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.build((IBuildChange)((Object)buildChange), buildState, monitor);
                    ++n2;
                }
            }
            finally {
                this.resetBuilders(builders, buildState, monitor);
                monitor.done();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleBuilderRunner
    extends ScriptBuilder {
        private final Class<? extends IScriptBuilder> builderClass;

        public SingleBuilderRunner(Class<? extends IScriptBuilder> builderClass) {
            this.builderClass = builderClass;
        }

        @Override
        protected IScriptBuilder[] getScriptBuilders(IDLTKLanguageToolkit toolkit) {
            IScriptBuilder[] builders = super.getScriptBuilders(toolkit);
            if (builders != null) {
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptBuilder builder = iScriptBuilderArray[n2];
                    if (builder.getClass() == this.builderClass) {
                        return new IScriptBuilder[]{builder};
                    }
                    ++n2;
                }
            }
            throw new IllegalArgumentException("IScriptBuilder of class " + this.builderClass + " not found");
        }

        public void build(IProject project, IProgressMonitor monitor) throws CoreException {
            this.currentProject = project;
            this.scriptProject = (ScriptProject)DLTKCore.create(project);
            BuildStateStub buildState = new BuildStateStub(project.getName());
            IScriptBuilder[] builders = null;
            try {
                IScriptBuilder builder;
                monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                monitor.beginTask("", 100);
                builders = this.getScriptBuilders();
                if (builders == null || builders.length == 0) {
                    return;
                }
                FullBuildChange buildChange = new FullBuildChange(project, monitor);
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.prepare(buildChange, buildState, monitor);
                    ++n2;
                }
                iScriptBuilderArray = builders;
                n = builders.length;
                n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.build(buildChange, buildState, monitor);
                    ++n2;
                }
            }
            finally {
                this.resetBuilders(builders, buildState, monitor);
                monitor.done();
            }
        }
    }

    private static class UpgradeCheck
    extends ScriptBuilder {
        private UpgradeCheck() {
        }

        public void checkProject(IScriptProject project, IProgressMonitor monitor) throws CoreException {
            if (!this.hasScriptBuilder(project.getProject()) && ScriptBuilder.DEBUG) {
                System.out.println("Skip " + project.getElementName() + " - no ScriptBuilder");
            }
            this.currentProject = project.getProject();
            this.scriptProject = (ScriptProject)project;
            IScriptBuilder[] builders = this.getScriptBuilders();
            if (builders == null || builders.length == 0) {
                if (ScriptBuilder.DEBUG) {
                    System.out.println("Skip " + project.getElementName() + " - no builders");
                }
                return;
            }
            BuildStateStub buildState = new BuildStateStub(project.getElementName());
            try {
                if (this.isBuilderVersionChange(builders)) {
                    if (ScriptBuilder.DEBUG) {
                        System.out.println("Touching " + project.getElementName());
                    }
                    new BuildpathValidation(this.scriptProject).validate();
                    project.getProject().touch(monitor);
                }
            }
            finally {
                this.resetBuilders(builders, buildState, monitor);
            }
        }

        private boolean hasScriptBuilder(IProject project) throws CoreException {
            IProjectDescription description = project.getDescription();
            ICommand[] iCommandArray = description.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if ("org.eclipse.dltk.core.scriptbuilder".equals(command.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

