/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.internal.core.util.LRUCache;

public class BufferCache
extends OverflowingLRUCache {
    private ThreadLocal<List<IBuffer>> buffersToClose = new ThreadLocal();

    public BufferCache(int size) {
        super(size);
    }

    public BufferCache(int size, int overflow) {
        super(size, overflow);
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        IBuffer buffer = (IBuffer)entry._fValue;
        if (!((Openable)buffer.getOwner()).canBufferBeRemovedFromCache(buffer)) {
            return false;
        }
        List<IBuffer> buffers = this.buffersToClose.get();
        if (buffers == null) {
            buffers = new ArrayList<IBuffer>();
            this.buffersToClose.set(buffers);
        }
        buffers.add(buffer);
        return true;
    }

    void closeBuffers() {
        List<IBuffer> buffers = this.buffersToClose.get();
        if (buffers == null) {
            return;
        }
        this.buffersToClose.set(null);
        int i = 0;
        int length = buffers.size();
        while (i < length) {
            buffers.get(i).close();
            ++i;
        }
    }

    protected LRUCache newInstance(int size, int newOverflow) {
        return new BufferCache(size, newOverflow);
    }
}

