/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoResourceSet;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class TypeCache {
    private final URI baseURI;
    private final TypeCacheResourceSet resourceSet;
    private final Map<String, CacheEntry> map = new HashMap<String, CacheEntry>();
    private final ThreadLocal<ThreadState> threads = new ThreadLocal<ThreadState>(){

        @Override
        protected ThreadState initialValue() {
            return new ThreadState();
        }
    };

    public TypeCache(String scheme, String authority) {
        this(URI.createHierarchicalURI((String)scheme, (String)authority, null, null, null));
    }

    public TypeCache(URI baseURI) {
        Assert.isLegal((boolean)baseURI.isHierarchical(), (String)"TypeCache baseURI must be hierarchical");
        this.baseURI = baseURI;
        this.resourceSet = new TypeCacheResourceSet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry addType(String bucket, Type type) {
        if (bucket == null) {
            bucket = "";
        }
        Assert.isLegal((type.eResource() == null ? 1 : 0) != 0);
        Assert.isLegal((!type.eIsProxy() ? 1 : 0) != 0);
        String name = type.getName();
        Map<String, CacheEntry> map = this.map;
        synchronized (map) {
            CacheEntry entry = this.map.get(name);
            if (entry != null) {
                if (!bucket.equals(entry.bucket)) {
                    throw new IllegalStateException("Type cache bucket changed for " + name);
                }
                return entry;
            }
            entry = new CacheEntry(bucket, type);
            this.map.put(name, entry);
            this.resourceSet.getResource(this.getURI(bucket), true).getContents().add((Object)type);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findType(String typeName) {
        CacheEntry entry;
        Map<String, CacheEntry> map = this.map;
        synchronized (map) {
            entry = this.map.get(typeName);
        }
        if (entry != null) {
            return entry.type;
        }
        ThreadState state = this.threads.get();
        ++state.activeOperations;
        try {
            entry = this.createType(typeName);
        }
        finally {
            --state.activeOperations;
        }
        return entry != null ? entry.type : null;
    }

    protected abstract CacheEntry createType(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Type getType(String typeName) {
        CacheEntry entry;
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return type;
        }
        Map<String, CacheEntry> map = this.map;
        synchronized (map) {
            entry = this.map.get(typeName);
        }
        if (entry != null) {
            return entry.type;
        }
        ThreadState state = this.threads.get();
        if (state.activeOperations != 0) {
            return TypeUtil.createProxy(typeName);
        }
        ++state.activeOperations;
        try {
            entry = this.createType(typeName);
            Type type2 = entry != null ? entry.type : null;
            return type2;
        }
        finally {
            --state.activeOperations;
        }
    }

    protected SimpleType getTypeRef(String typeName) {
        return TypeUtil.ref(this.getType(typeName));
    }

    private URI getURI(String bucket) {
        if (bucket == null || bucket.length() == 0) {
            return this.baseURI;
        }
        return this.baseURI.appendSegment(bucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, CacheEntry> map = this.map;
        synchronized (map) {
            this.map.clear();
            EList resources = this.resourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
            resources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String bucket) {
        if (bucket == null) {
            bucket = "";
        }
        Map<String, CacheEntry> map = this.map;
        synchronized (map) {
            Iterator<Map.Entry<String, CacheEntry>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, CacheEntry> entry = i.next();
                if (!bucket.equals(entry.getValue().bucket)) continue;
                i.remove();
            }
            Resource resource = this.resourceSet.getResource(this.getURI(bucket), false);
            if (resource != null) {
                resource.unload();
            }
        }
    }

    public static class CacheEntry {
        final String bucket;
        final Type type;

        CacheEntry(String bucket, Type type) {
            this.bucket = bucket;
            this.type = type;
        }
    }

    static class ThreadState {
        int activeOperations;

        ThreadState() {
        }
    }

    private static class TypeCacheResource
    extends ResourceImpl {
        public TypeCacheResource(URI uri) {
            super(uri);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + '@' + Integer.toHexString(((Object)((Object)this)).hashCode()) + "@" + this.uri;
        }
    }

    private static class TypeCacheResourceSet
    extends ResourceSetImpl
    implements TypeInfoResourceSet {
        private final TypeCache cache;

        public TypeCacheResourceSet(TypeCache cache) {
            this.cache = cache;
            this.setURIResourceMap(new HashMap());
        }

        public Resource createResource(URI uri, String contentType) {
            TypeCacheResource resource = new TypeCacheResource(uri);
            this.getResources().add((Object)resource);
            return resource;
        }

        protected void demandLoadHelper(Resource resource) {
            resource.getContents().clear();
        }

        public EObject resolve(InternalEObject proxy, EObject objectContext, Resource resourceContext) {
            URI uri = proxy.eProxyURI();
            if (TypeUtil.isTypeProxy(uri)) {
                return this.cache.getType(URI.decode((String)uri.fragment()));
            }
            return EcoreUtil.resolve((EObject)proxy, (ResourceSet)this);
        }
    }
}

