/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlottedHashMap
implements Map {
    private SlottedHashMap parent;
    private Map map;
    private List children = new ArrayList();
    private Object owner;

    public SlottedHashMap(Object owner) {
        this.map = new HashMap();
        this.owner = owner;
    }

    public SlottedHashMap(Object owner, SlottedHashMap smap) {
        this(owner);
        this.parent = smap;
        smap.addChild(this);
        for (Map.Entry entry : this.parent.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public void addChild(SlottedHashMap smap) {
        this.children.add(smap);
    }

    public void setParent(SlottedHashMap smap) {
        this.parent = smap;
    }

    public Object put(Object key, Object value) {
        Slot slot = (Slot)this.map.get(key);
        if (slot == null || slot.getParent() != this) {
            slot = new Slot();
        }
        slot.setValue(value);
        for (Object obj : this.children) {
            SlottedHashMap shm = (SlottedHashMap)obj;
            shm.put(key, value, this);
        }
        return this.map.put(key, slot);
    }

    protected Object put(Object key, Object value, SlottedHashMap parent) {
        Slot slot = this.getSlot(key);
        if (slot != null && slot.getParent() == this) {
            return this.get(key);
        }
        slot = parent.getSlot(key);
        for (SlottedHashMap shm : this.children) {
            shm.put(key, value, parent);
        }
        return this.map.put(key, slot);
    }

    public Object get(Object key) {
        Slot slot = this.getSlot(key);
        if (slot == null) {
            return null;
        }
        return slot.getValue();
    }

    public Slot getSlot(Object key) {
        return (Slot)this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        throw new RuntimeException("clear not implemented");
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return false;
    }

    public Collection values() {
        return null;
    }

    public void putAll(Map t) {
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object remove(Object key) {
        Slot slot = this.getSlot(key);
        if (slot != null && slot.getParent() == this) {
            this.map.remove(key);
            for (SlottedHashMap child : this.children) {
                child.remove(key, this);
            }
            return slot.getValue();
        }
        return null;
    }

    protected void remove(Object key, SlottedHashMap parent) {
        Slot slot = this.getSlot(key);
        if (slot.getParent() == this) {
            return;
        }
        this.map.remove(key);
        for (SlottedHashMap child : this.children) {
            child.remove(key, parent);
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public class Slot {
        private Object value;

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public SlottedHashMap getParent() {
            return SlottedHashMap.this;
        }

        public String toString() {
            return "Slot#" + this.hashCode() + "[parent = " + this.getParent().hashCode() + ", value = " + this.getValue() + "]";
        }
    }
}

