/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryStatement
extends Statement {
    private Keyword tryKeyword;
    private StatementBlock body;
    private List<CatchClause> catchClauses = new ArrayList<CatchClause>();
    private FinallyClause finallyClause;

    public TryStatement(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.tryKeyword != null) {
                this.tryKeyword.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            if (this.catchClauses != null) {
                for (CatchClause ctch : this.catchClauses) {
                    ctch.traverse(visitor);
                }
            }
            if (this.finallyClause != null) {
                this.finallyClause.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    public FinallyClause getFinally() {
        return this.finallyClause;
    }

    public void setFinally(FinallyClause finallyClause) {
        this.finallyClause = finallyClause;
    }

    public List<CatchClause> getCatches() {
        return this.catchClauses;
    }

    public Keyword getTryKeyword() {
        return this.tryKeyword;
    }

    public void setTryKeyword(Keyword keyword) {
        this.tryKeyword = keyword;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("try");
        buffer.append("\n");
        buffer.append(this.body.toSourceString(indentationString));
        int i = 0;
        while (i < this.getCatches().size()) {
            buffer.append(this.getCatches().get(i).toSourceString(indentationString));
            ++i;
        }
        if (this.getFinally() != null) {
            buffer.append(this.getFinally().toSourceString(indentationString));
        }
        return buffer.toString();
    }
}

