/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core.eval;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.dltk.debug.core.eval.EvaluatedScriptExpression;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;

public class InspectEvaluatedScriptExpression
extends EvaluatedScriptExpression
implements IDebugEventSetListener {
    public InspectEvaluatedScriptExpression(IScriptEvaluationResult result) {
        super(result);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    if (!event.getSource().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
                    break;
                }
                case 2: {
                    IDebugElement source;
                    if (event.getDetail() == 128 || !(event.getSource() instanceof IDebugElement) || !(source = (IDebugElement)event.getSource()).getDebugTarget().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
                }
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

