/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.testing;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.internal.testing.TclTestingEngineManager;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;

public class TclTestingPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_TEST = "isTest";
    private static final String PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST = "canLaunchAsTest";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource;
        IModelElement element;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + receiver == null ? "null" : receiver.getClass().getName());
        }
        if (receiver instanceof IModelElement) {
            element = (IModelElement)receiver;
        } else if (receiver instanceof IResource ? (element = DLTKCore.create((IResource)((IResource)receiver))) == null : (element = (IModelElement)((IAdaptable)receiver).getAdapter(IModelElement.class)) == null && (element = DLTKCore.create((IResource)(resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)))) == null) {
            return false;
        }
        if (PROPERTY_IS_TEST.equals(property)) {
            return this.isTest(element);
        }
        if (PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST.equals(property)) {
            return this.canLaunchAsTest(element);
        }
        throw new IllegalArgumentException("Unknown test property '" + property + "'");
    }

    private boolean canLaunchAsTest(IModelElement element) {
        switch (element.getElementType()) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: {
                return this.isTest(element);
            }
        }
        return false;
    }

    private boolean isTest(IModelElement element) {
        if (element instanceof ISourceModule) {
            ISourceModule module = (ISourceModule)element;
            ITclTestingEngine[] iTclTestingEngineArray = TclTestingEngineManager.getEngines();
            int n = iTclTestingEngineArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITclTestingEngine engine = iTclTestingEngineArray[n2];
                if (engine.isValidModule(module)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

