/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerType;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkbenchAdaptable;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageElement;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageContainerElement
extends WorkbenchAdaptable {
    public PackageContainerElement(SelectionDialogInput input) {
        super(input);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.PACKAGES;
    }

    @Override
    public Object[] getChildren() {
        Set<IScriptProject> projects = this.input.collectProjects();
        HashSet<PackageElement> packages = new HashSet<PackageElement>();
        for (TclPackageElement element : PackageContainerElement.collectPackages(projects)) {
            packages.add(new PackageElement(element.getPackageName()));
        }
        return packages.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        return PreferenceMessages.InstrumentationLabelProvider_Packages;
    }

    private static Set<TclPackageElement> collectPackages(Set<IScriptProject> projects) {
        HashSet<TclPackageElement> packages = new HashSet<TclPackageElement>();
        for (IScriptProject project : projects) {
            try {
                IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
                int n = iProjectFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment fragment = iProjectFragmentArray[n2];
                    if (fragment instanceof TclPackageFragment) {
                        IModelElement[] iModelElementArray = fragment.getChildren();
                        int n3 = iModelElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement element = iModelElementArray[n4];
                            if (element instanceof TclPackageElement) {
                                packages.add((TclPackageElement)element);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return packages;
    }
}

