/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyIfStatement
extends ASTNode {
    private ASTNode fCondition;
    private ASTNode fThenStatement;
    private ASTNode fElseStatement;

    public RubyIfStatement(ASTNode condition, ASTNode thenStatement, ASTNode elseStatement) {
        this.fCondition = condition;
        this.fThenStatement = thenStatement;
        this.fElseStatement = elseStatement;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((ASTNode)this)) {
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fThenStatement != null) {
                this.fThenStatement.traverse(pVisitor);
            }
            if (this.fElseStatement != null) {
                this.fElseStatement.traverse(pVisitor);
            }
            pVisitor.endvisit((ASTNode)this);
        }
    }

    public void acceptElse(ASTNode elseStatement) {
        this.fElseStatement = elseStatement;
        if (this.fElseStatement != null) {
            this.setEnd(this.fElseStatement.sourceEnd());
        }
    }

    public ASTNode getElse() {
        return this.fElseStatement;
    }

    public ASTNode getThen() {
        return this.fThenStatement;
    }

    public ASTNode getCondition() {
        return this.fCondition;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("if: ");
        if (this.fCondition != null) {
            this.fCondition.printNode(output);
        }
        if (this.fThenStatement != null) {
            if (!(this.fThenStatement instanceof Block)) {
                output.indent();
            }
            this.fThenStatement.printNode(output);
            if (!(this.fThenStatement instanceof Block)) {
                output.dedent();
            }
        }
        if (this.fElseStatement != null) {
            output.formatPrintLn("else:");
            if (!(this.fElseStatement instanceof Block)) {
                output.indent();
            }
            this.fElseStatement.printNode(output);
            if (!(this.fElseStatement instanceof Block)) {
                output.dedent();
            }
        }
    }
}

