/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.javascript.typeinfo.JSType2;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.dltk.javascript.typeinfo.model.impl.AnyTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.ArrayTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.ClassTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.FunctionTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.MapTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.RecordTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.TypeRefImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.UndefinedTypeImpl;
import org.eclipse.dltk.javascript.typeinfo.model.impl.UnionTypeImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSTypeSet
implements Iterable<JSType> {
    private static final JSEmptyTypeSet EMPTY_SET = new JSEmptyTypeSet();
    private static final JSType2 ANY_TYPE = new AnyTypeKey();
    private static final JSType2 UNDEFINED_TYPE = new UndefinedTypeKey();

    public static JSTypeSet emptySet() {
        return EMPTY_SET;
    }

    public static JSTypeSet singleton(JSType type) {
        if (type instanceof UnionType) {
            JSTypeSet set = JSTypeSet.create();
            set.add(type);
            return set;
        }
        return new JSSingletonTypeSet(type);
    }

    public static JSType2 record(Type target) {
        return new RecordTypeKey(target);
    }

    public static JSType2 normalize(JSType type) {
        if (type instanceof TypeRefImpl) {
            TypeRef ref = (TypeRef)type;
            return JSTypeSet.ref(ref.getTarget());
        }
        if (type instanceof ClassTypeImpl) {
            return JSTypeSet.classType(((ClassType)type).getTarget());
        }
        if (type instanceof ArrayTypeImpl) {
            return JSTypeSet.arrayOf(JSTypeSet.normalize(((ArrayType)type).getItemType()));
        }
        if (type instanceof MapTypeImpl) {
            return JSTypeSet.mapOf(JSTypeSet.normalize(((MapType)type).getKeyType()), JSTypeSet.normalize(((MapType)type).getValueType()));
        }
        if (type instanceof AnyTypeImpl) {
            return ANY_TYPE;
        }
        if (type instanceof UndefinedTypeImpl) {
            return UNDEFINED_TYPE;
        }
        if (type instanceof UnionTypeImpl) {
            UnionTypeKey union = new UnionTypeKey();
            for (JSType t : ((UnionType)type).getTargets()) {
                union.targets.add((Object)JSTypeSet.normalize(t));
            }
            return union;
        }
        if (type instanceof RecordTypeImpl) {
            RecordType recordType = (RecordType)type;
            return new RecordTypeKey(recordType.getTarget());
        }
        if (type instanceof FunctionTypeImpl) {
            EList params;
            FunctionType funcType = (FunctionType)type;
            if (funcType.getParameters().isEmpty()) {
                params = ECollections.emptyEList();
            } else {
                params = new BasicEList();
                for (Parameter parameter : funcType.getParameters()) {
                    params.add((Object)new ParameterKey(parameter.getName(), JSTypeSet.normalize(parameter.getType())));
                }
            }
            return new FunctionTypeKey((EList<Parameter>)params, JSTypeSet.normalize(funcType.getReturnType()));
        }
        Assert.isLegal((!(type instanceof EObject) ? 1 : 0) != 0);
        return (JSType2)type;
    }

    public static JSType2 ref(Type type) {
        return new TypeRefKey(type);
    }

    public static JSType2 classType(Type type) {
        return new ClassTypeKey(type);
    }

    public static ArrayTypeKey arrayOf(JSType2 itemType) {
        return new ArrayTypeKey(itemType);
    }

    public static MapTypeKey mapOf(JSType2 keyType, JSType2 valueType) {
        return new MapTypeKey(keyType, valueType);
    }

    public static JSType2 any() {
        return ANY_TYPE;
    }

    public static JSType2 undefined() {
        return UNDEFINED_TYPE;
    }

    public static JSType2 union(List<JSType2> targets) {
        UnionTypeKey union = new UnionTypeKey();
        union.targets.addAll(targets);
        return union;
    }

    public static JSType2 functionType(EList<Parameter> parameters, JSType2 returnType) {
        return new FunctionTypeKey(parameters, returnType);
    }

    public static Parameter parameter(String name, JSType2 type) {
        return new ParameterKey(name, type);
    }

    public static JSTypeSet create() {
        return new JSTypeSetImpl();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSTypeSet) {
            JSTypeSet other = (JSTypeSet)obj;
            return this.size() == other.size() && this.containsAll(other);
        }
        return false;
    }

    public abstract void add(JSType var1);

    public abstract JSType getFirst();

    public abstract Type[] toArray();

    public abstract int size();

    public abstract void addAll(JSTypeSet var1);

    public abstract boolean isEmpty();

    public abstract void clear();

    public abstract boolean contains(JSType var1);

    public abstract boolean contains(Type var1);

    public abstract boolean containsAll(JSTypeSet var1);

    private static class AnyTypeKey
    implements AnyType,
    JSType2 {
        private AnyTypeKey() {
        }

        public TypeKind getKind() {
            return TypeKind.PREDEFINED;
        }

        public String getName() {
            return "Any";
        }

        public boolean isArray() {
            return false;
        }

        public boolean isAssignableFrom(JSType2 type) {
            return true;
        }
    }

    private static class ArrayTypeKey
    implements ArrayType,
    JSType2 {
        private final JSType2 itemType;

        public ArrayTypeKey(JSType2 itemType) {
            this.itemType = itemType;
        }

        public TypeKind getKind() {
            return TypeKind.PREDEFINED;
        }

        public String getName() {
            return this.itemType != null ? "Array<" + this.itemType.getName() + '>' : "Array";
        }

        public JSType getItemType() {
            return this.itemType;
        }

        public void setItemType(JSType value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.itemType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArrayTypeKey) {
                ArrayTypeKey other = (ArrayTypeKey)obj;
                return this.itemType.equals(other.itemType);
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isArray() {
            return true;
        }

        public boolean isAssignableFrom(JSType2 type) {
            if (type instanceof ArrayTypeKey) {
                return this.itemType.isAssignableFrom(((ArrayTypeKey)type).itemType);
            }
            if (this.itemType instanceof AnyType && type.isArray()) {
                return true;
            }
            return type instanceof UndefinedType;
        }
    }

    private static class ClassTypeKey
    implements ClassType,
    JSType2 {
        private final Type type;

        public ClassTypeKey(Type type) {
            this.type = type;
        }

        public TypeKind getKind() {
            return TypeKind.CLASS;
        }

        public String getRawName() {
            if (this.type != null) {
                if (((EObject)this.type).eIsProxy()) {
                    URI uri = ((InternalEObject)this.type).eProxyURI();
                    if (uri != null) {
                        return URI.decode((String)uri.fragment());
                    }
                } else {
                    return this.type.getName();
                }
            }
            return null;
        }

        public String getName() {
            String rawName = this.getRawName();
            return rawName != null ? "Class<" + rawName + ">" : "Class";
        }

        public Type getTarget() {
            return this.type;
        }

        public void setTarget(Type value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 31;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassTypeKey) {
                ClassTypeKey other = (ClassTypeKey)obj;
                return this.type != null ? this.type.equals(other.type) : other.type == null;
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isArray() {
            return false;
        }

        public boolean isAssignableFrom(JSType2 type) {
            block7: {
                block6: {
                    if (this.equals(type)) {
                        return true;
                    }
                    if (type instanceof UndefinedType) {
                        return true;
                    }
                    if (!(type instanceof ClassType)) break block6;
                    if (this.type == null) {
                        return true;
                    }
                    Type other = ((ClassType)((Object)type)).getTarget();
                    String localName = TypeUtil.getName(this.type);
                    Type t = other;
                    while (t != null) {
                        if (localName.equals(TypeUtil.getName(t))) {
                            return true;
                        }
                        t = t.getSuperType();
                    }
                    break block7;
                }
                if (!(type instanceof UnionTypeKey)) break block7;
                for (JSType2 part : ((UnionTypeKey)type).targets) {
                    if (!this.isAssignableFrom(part)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<JSType> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public JSType next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionTypeKey
    implements FunctionType,
    JSType2 {
        private final EList<Parameter> parameters;
        private final JSType2 returnType;

        public FunctionTypeKey(EList<Parameter> parameters, JSType2 returnType) {
            this.parameters = parameters;
            this.returnType = returnType;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.FUNCTION;
        }

        @Override
        public String getName() {
            return "Function";
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isAssignableFrom(JSType2 type) {
            return false;
        }

        @Override
        public JSType getReturnType() {
            return this.returnType;
        }

        @Override
        public void setReturnType(JSType value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EList<Parameter> getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            return this.parameters.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionTypeKey other = (FunctionTypeKey)obj;
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSEmptyTypeSet
    extends JSTypeSet {
        protected JSEmptyTypeSet() {
        }

        @Override
        public Iterator<JSType> iterator() {
            return new EmptyIterator();
        }

        @Override
        public void add(JSType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSType getFirst() {
            return null;
        }

        @Override
        public Type[] toArray() {
            return new Type[0];
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void addAll(JSTypeSet types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(JSType type) {
            return false;
        }

        @Override
        public boolean contains(Type type) {
            return false;
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSSingletonTypeSet
    extends JSTypeSet {
        private final JSType type;

        public JSSingletonTypeSet(JSType type) {
            this.type = JSSingletonTypeSet.normalize(type);
        }

        @Override
        public Iterator<JSType> iterator() {
            return new SingletonIterator(this.type);
        }

        @Override
        public void add(JSType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSType getFirst() {
            return this.type;
        }

        @Override
        public Type[] toArray() {
            if (this.type instanceof TypeRef) {
                return new Type[]{((TypeRef)this.type).getTarget()};
            }
            if (this.type instanceof ClassType) {
                return new Type[]{((ClassType)this.type).getTarget()};
            }
            if (this.type instanceof AnyType) {
                return new Type[]{TypeInfoModelLoader.getInstance().getType("Object")};
            }
            return new Type[0];
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void addAll(JSTypeSet types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(JSType type) {
            return this.type.equals(JSSingletonTypeSet.normalize(type));
        }

        @Override
        public boolean contains(Type type) {
            return this.type instanceof TypeRef && ((TypeRef)this.type).getTarget().equals(type);
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.size() == 1 && this.contains(types.getFirst());
        }

        public String toString() {
            return "[" + this.type + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSTypeSetImpl
    extends JSTypeSet {
        private final List<JSType> types = new ArrayList<JSType>();

        protected JSTypeSetImpl() {
        }

        @Override
        public Iterator<JSType> iterator() {
            return this.types.iterator();
        }

        @Override
        public void add(JSType type) {
            if (type instanceof UnionType) {
                for (JSType t : ((UnionType)type).getTargets()) {
                    this.add(t);
                }
            } else {
                JSType2 normalize = JSTypeSetImpl.normalize(type);
                if (!this.types.contains(normalize)) {
                    this.types.add(normalize);
                }
            }
        }

        @Override
        public JSType getFirst() {
            return this.types.iterator().next();
        }

        @Override
        public Type[] toArray() {
            LinkedHashSet<Type> result = new LinkedHashSet<Type>();
            for (JSType type : this.types) {
                if (type instanceof TypeRef) {
                    result.add(((TypeRef)type).getTarget());
                    continue;
                }
                if (!(type instanceof AnyType)) continue;
                result.add(TypeInfoModelLoader.getInstance().getType("Object"));
            }
            return result.toArray(new Type[result.size()]);
        }

        @Override
        public int size() {
            return this.types.size();
        }

        @Override
        public void addAll(JSTypeSet types) {
            for (JSType type : types) {
                this.add(type);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.types.isEmpty();
        }

        @Override
        public void clear() {
            this.types.clear();
        }

        @Override
        public boolean contains(JSType type) {
            return this.types.contains(JSTypeSetImpl.normalize(type));
        }

        @Override
        public boolean contains(Type type) {
            return this.types.contains(JSTypeSetImpl.ref(type));
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            for (JSType type : types) {
                if (this.contains(type)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.types.toString();
        }
    }

    private static class MapTypeKey
    implements MapType,
    JSType2 {
        private final JSType2 valueType;
        private final JSType2 keyType;

        public MapTypeKey(JSType2 keyType, JSType2 valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public TypeKind getKind() {
            return TypeKind.PREDEFINED;
        }

        public String getName() {
            if (this.valueType != null && this.keyType != null && !"String".equals(this.keyType.getName())) {
                return "Object<" + this.keyType.getName() + ',' + this.valueType.getName() + '>';
            }
            return this.valueType != null ? "Object<" + this.valueType.getName() + '>' : "Object";
        }

        public int hashCode() {
            return this.valueType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MapTypeKey) {
                MapTypeKey other = (MapTypeKey)obj;
                return this.valueType.equals(other.valueType);
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isArray() {
            return false;
        }

        public boolean isAssignableFrom(JSType2 type) {
            if (type instanceof MapTypeKey) {
                return this.valueType.isAssignableFrom(((MapTypeKey)type).valueType);
            }
            return type instanceof UndefinedType;
        }

        public JSType getKeyType() {
            return this.keyType;
        }

        public void setKeyType(JSType value) {
            throw new UnsupportedOperationException();
        }

        public JSType getValueType() {
            return this.valueType;
        }

        public void setValueType(JSType value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ParameterKey
    implements Parameter {
        private final String name;
        private final JSType2 type;

        public ParameterKey(String name, JSType2 type) {
            Assert.isNotNull((Object)type);
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            throw new UnsupportedOperationException();
        }

        public JSType getType() {
            return this.type;
        }

        public void setType(JSType value) {
            throw new UnsupportedOperationException();
        }

        public Type getDirectType() {
            return this.type instanceof TypeRef ? ((TypeRef)((Object)this.type)).getTarget() : null;
        }

        public void setDirectType(Type value) {
            throw new UnsupportedOperationException();
        }

        public ParameterKind getKind() {
            return ParameterKind.NORMAL;
        }

        public void setKind(ParameterKind value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterKey other = (ParameterKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.type.equals(other.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordTypeKey
    implements RecordType,
    JSType2 {
        private final Type target;

        public RecordTypeKey(Type target) {
            this.target = target;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.RECORD;
        }

        @Override
        public String getName() {
            return this.target.getName();
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isAssignableFrom(JSType2 type) {
            return false;
        }

        @Override
        public Type getTarget() {
            return this.target;
        }

        @Override
        public void setTarget(Type value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EList<Member> getMembers() {
            return this.target.getMembers();
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecordTypeKey) {
                RecordTypeKey other = (RecordTypeKey)obj;
                return this.target == other.target;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<JSType> {
        private final JSType type;
        private boolean hasNext = true;

        public SingletonIterator(JSType type) {
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public JSType next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.type;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TypeRefKey
    implements TypeRef,
    JSType2 {
        private final Type type;

        public TypeRefKey(Type type) {
            this.type = type;
        }

        public TypeKind getKind() {
            return !this.type.isProxy() ? this.type.getKind() : TypeKind.UNRESOLVED;
        }

        public String getName() {
            return this.type.getName();
        }

        public Type getTarget() {
            return this.type;
        }

        public void setTarget(Type value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeRefKey) {
                TypeRefKey other = (TypeRefKey)obj;
                return this.type.equals(other.type);
            }
            return false;
        }

        public String toString() {
            return this.type.toString();
        }

        public boolean isArray() {
            return "Array".equals(this.type.getName());
        }

        public boolean isAssignableFrom(JSType2 type) {
            block8: {
                block7: {
                    if (this.equals(type)) {
                        return true;
                    }
                    if (this.isArray()) {
                        return type.isArray();
                    }
                    if (type instanceof UndefinedType) {
                        return true;
                    }
                    if ("Object".equals(this.getName())) {
                        return true;
                    }
                    if (!(type instanceof TypeRef)) break block7;
                    Type other = ((TypeRef)((Object)type)).getTarget();
                    String localName = TypeUtil.getName(this.type);
                    Type t = other;
                    while (t != null) {
                        if (localName.equals(TypeUtil.getName(t))) {
                            return true;
                        }
                        t = t.getSuperType();
                    }
                    break block8;
                }
                if (!(type instanceof UnionTypeKey)) break block8;
                for (JSType2 part : ((UnionTypeKey)type).targets) {
                    if (!this.isAssignableFrom(part)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class UndefinedTypeKey
    implements UndefinedType,
    JSType2 {
        private UndefinedTypeKey() {
        }

        public TypeKind getKind() {
            return TypeKind.PREDEFINED;
        }

        public String getName() {
            return "undefined";
        }

        public boolean isArray() {
            return false;
        }

        public boolean isAssignableFrom(JSType2 type) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionTypeKey
    implements UnionType,
    JSType2 {
        final EList<JSType2> targets = new BasicEList();

        private UnionTypeKey() {
        }

        @Override
        public TypeKind getKind() {
            return !this.targets.isEmpty() ? ((JSType2)this.targets.get(0)).getKind() : TypeKind.UNKNOWN;
        }

        @Override
        public String getName() {
            StringBuilder sb = new StringBuilder();
            for (JSType type : this.targets) {
                if (sb.length() != 0) {
                    sb.append('|');
                }
                sb.append(type.getName());
            }
            return sb.toString();
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isAssignableFrom(JSType2 type) {
            for (JSType2 target : this.targets) {
                if (!target.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        @Override
        public EList<JSType> getTargets() {
            return this.targets;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnionTypeKey) {
                UnionTypeKey other = (UnionTypeKey)obj;
                return this.targets.size() == other.targets.size() && this.targets.containsAll(other.targets);
            }
            return false;
        }
    }
}

