/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeReferencePredicate
extends AbstractMatchingPredicate<MatchingNode> {
    public TypeReferencePredicate(TypeReferencePattern pattern) {
        super((SearchPattern)pattern, pattern.simpleName);
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            MatchLevel level = this.matchTypeName(mNode.method.getType());
            if (level != null) {
                return level;
            }
            for (IModelBuilder.IParameter parameter : mNode.method.getParameters()) {
                level = this.matchTypeName(parameter.getType());
                if (level == null) continue;
                return level;
            }
        } else {
            if (node instanceof FieldDeclarationNode) {
                FieldDeclarationNode fNode = (FieldDeclarationNode)node;
                return this.matchTypeName(fNode.declaredType);
            }
            if (node instanceof LocalVariableDeclarationNode) {
                LocalVariableDeclarationNode vNode = (LocalVariableDeclarationNode)node;
                return this.matchTypeName(vNode.declaredType);
            }
        }
        return null;
    }

    private MatchLevel matchTypeName(JSType type) {
        if (type == null) {
            return null;
        }
        MatchLevel result = null;
        if (type instanceof ArrayType) {
            result = this.matchName("Array");
        }
        Type[] typeArray = JSTypeSet.singleton(type).toArray();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            MatchLevel m = this.matchName(t.getName());
            if (result == null || m.compareTo((Enum)result) > 0) {
                result = m;
            }
            ++n2;
        }
        return result;
    }
}

