/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestorExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.DuplicateResolver;
import org.eclipse.dltk.internal.core.ImportContainer;
import org.eclipse.dltk.internal.core.ImportContainerInfo;
import org.eclipse.dltk.internal.core.ImportDeclaration;
import org.eclipse.dltk.internal.core.ImportDeclarationElementInfo;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.PackageDeclaration;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceFieldElementInfo;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceMethodElementInfo;
import org.eclipse.dltk.internal.core.SourceMethodUtils;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.SourceNamespace;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.SourceRefElementInfo;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.SourceTypeElementInfo;

public class SourceModuleStructureRequestor
implements ISourceElementRequestor,
ISourceElementRequestorExtension {
    private DuplicateResolver.Resolver counters = DuplicateResolver.create();
    private static final String[] EMPTY = new String[0];
    private ISourceModule module;
    private SourceModuleElementInfo moduleInfo;
    private Stack<INamespace> namespaces = new Stack();
    protected Map<String, ImportContainer> importContainers = null;
    private Map<IModelElement, ModelElementInfo> newElements;
    private Stack<ModelElementInfo> infoStack;
    private Stack<ModelElement> handleStack;
    protected boolean hasSyntaxErrors = false;

    public SourceModuleStructureRequestor(ISourceModule module, SourceModuleElementInfo moduleInfo, Map newElements) {
        this.module = module;
        this.moduleInfo = moduleInfo;
        this.newElements = newElements;
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        this.counters.resolveDuplicates(handle);
        Assert.isTrue((!this.newElements.containsKey(handle) ? 1 : 0) != 0);
    }

    public void enterModule() {
        this.infoStack = new Stack();
        this.handleStack = new Stack();
        this.enterModuleRoot();
    }

    public void enterModuleRoot() {
        this.infoStack.push(this.moduleInfo);
        this.handleStack.push((ModelElement)((Object)this.module));
    }

    public void enterField(IElementRequestor.FieldInfo fieldInfo) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        ModelElement parentHandle = this.handleStack.peek();
        this.createField(fieldInfo, parentInfo, parentHandle);
    }

    private void createField(IElementRequestor.FieldInfo fieldInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        ModelManager manager = ModelManager.getModelManager();
        SourceField handle = new SourceField(parentHandle, manager.intern(fieldInfo.name));
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        info.setType(fieldInfo.type);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void updateField(IElementRequestor.FieldInfo fieldInfo, int flags) {
        SourceField field;
        ModelElement handle = this.handleStack.peek();
        if (handle instanceof SourceField && fieldInfo.name.equals((field = (SourceField)handle).getElementName())) {
            SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.peek();
            if ((flags & 1) != 0) {
                info.setType(fieldInfo.type);
            }
        }
    }

    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo fieldInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        IModelElement[] childrens = parentInfo.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] instanceof SourceField && childrens[i].getElementName().equals(fieldInfo.name)) {
                SourceField handle = (SourceField)childrens[i];
                SourceFieldElementInfo info = (SourceFieldElementInfo)this.newElements.get(handle);
                this.infoStack.push(info);
                this.handleStack.push(handle);
                return true;
            }
            ++i;
        }
        if (parentInfo instanceof SourceMethodElementInfo) {
            SourceMethodElementInfo method = (SourceMethodElementInfo)parentInfo;
            String[] args = method.getArgumentNames();
            int i2 = 0;
            while (i2 < args.length) {
                if (args[i2].equals(fieldInfo.name)) {
                    return false;
                }
                ++i2;
            }
        }
        this.createField(fieldInfo, parentInfo, parentHandle);
        return true;
    }

    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo fieldInfo) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        ModelElement parentHandle = this.handleStack.peek();
        return this.enterFieldCheckDuplicates(fieldInfo, parentInfo, parentHandle);
    }

    public void enterMethodRemoveSame(IElementRequestor.MethodInfo methodInfo) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        IModelElement[] childrens = parentInfo.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i].getElementName().equals(methodInfo.name)) {
                parentInfo.removeChild(childrens[i]);
            }
            ++i;
        }
        this.enterMethod(methodInfo);
    }

    public void enterMethod(IElementRequestor.MethodInfo methodInfo) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        ModelElement parentHandle = this.handleStack.peek();
        this.processMethod(methodInfo, parentInfo, parentHandle);
    }

    private void processMethod(IElementRequestor.MethodInfo methodInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        String[] parameterNames;
        String nameString = methodInfo.name;
        ModelManager manager = ModelManager.getModelManager();
        SourceMethod handle = new SourceMethod(parentHandle, manager.intern(nameString));
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setSourceRangeStart(methodInfo.declarationStart);
        info.setFlags(methodInfo.modifiers);
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setIsConstructor(methodInfo.isConstructor);
        info.setReturnType(methodInfo.returnType);
        String[] stringArray = parameterNames = methodInfo.parameterNames == null ? EMPTY : methodInfo.parameterNames;
        if (parameterNames.length == 0) {
            info.setArguments(SourceMethodUtils.NO_PARAMETERS);
        } else {
            IParameter[] params = new MethodParameterInfo[parameterNames.length];
            int i = 0;
            int length = parameterNames.length;
            while (i < length) {
                String name = manager.intern(parameterNames[i]);
                String type = null;
                String defaultValue = null;
                if (methodInfo.parameterTypes != null && i < methodInfo.parameterTypes.length && (type = methodInfo.parameterTypes[i]) != null) {
                    type = manager.intern(type);
                }
                if (methodInfo.parameterInitializers != null && i < methodInfo.parameterInitializers.length && (defaultValue = methodInfo.parameterInitializers[i]) != null) {
                    defaultValue = manager.intern(defaultValue);
                }
                params[i] = new MethodParameterInfo(name, type, defaultValue);
                ++i;
            }
            info.setArguments(params);
        }
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    private SourceType getCurrentType() {
        SourceType t = null;
        for (ModelElement o : this.handleStack) {
            if (!(o instanceof SourceType)) continue;
            t = (SourceType)o;
        }
        return t;
    }

    private SourceType getExistentType(String parentName, String delimiter) {
        try {
            SourceType element = null;
            if (parentName.startsWith(delimiter)) {
                if (this.module != null) {
                    element = this.findTypeFrom(this.module.getChildren(), "", parentName, delimiter);
                }
                return element;
            }
            parentName = String.valueOf(delimiter) + parentName;
            SourceType enc = this.getCurrentType();
            if (enc == null) {
                if (this.module != null) {
                    element = this.findTypeFrom(this.module.getChildren(), "", parentName, delimiter);
                }
            } else {
                element = this.findTypeFrom(enc.getChildren(), "", parentName, delimiter);
            }
            return element;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SourceType findTypeFrom(IModelElement[] childs, String name, String parentName, String delimiter) {
        try {
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof SourceType) {
                    SourceType type = (SourceType)childs[i];
                    String qname = String.valueOf(name) + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    SourceType val = this.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val != null) {
                        return val;
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        ModelElement parentHandle = this.handleStack.peek();
        this.processType(typeInfo, parentInfo, parentHandle);
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        SourceType element;
        block3: {
            try {
                element = this.getExistentType(fullName, delimiter);
                if (element != null) break block3;
                return false;
            }
            catch (ModelException e) {
                e.printStackTrace();
                return false;
            }
        }
        ModelElementInfo info = (ModelElementInfo)element.getElementInfo();
        this.infoStack.push(info);
        this.handleStack.push(element);
        return true;
    }

    public void enterNamespace(String[] namespace) {
        this.namespaces.push(new SourceNamespace(namespace));
    }

    public void exitNamespace() {
        this.namespaces.pop();
    }

    private void processType(IElementRequestor.TypeInfo typeInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        String nameString = typeInfo.name;
        SourceType handle = new SourceType(parentHandle, nameString);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        if (parentHandle.getElementType() == 5 && !this.namespaces.isEmpty()) {
            info.setNamespace(this.namespaces.peek());
        }
        info.setHandle(handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        ModelManager manager = ModelManager.getModelManager();
        String[] superclasses = typeInfo.superclasses;
        int i = 0;
        int length = superclasses == null ? 0 : superclasses.length;
        while (i < length) {
            superclasses[i] = manager.intern(superclasses[i]);
            ++i;
        }
        info.setSuperclassNames(superclasses);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitModule(int declarationEnd) {
        this.moduleInfo.setSourceLength(declarationEnd + 1);
        this.moduleInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitModuleRoot() {
        this.infoStack.pop();
        this.handleStack.pop();
    }

    public void exitField(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        ModelElementInfo object = this.infoStack.pop();
        SourceRefElementInfo info = (SourceRefElementInfo)object;
        info.setSourceRangeEnd(declarationEnd);
        this.handleStack.pop();
    }

    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
        ModelElementInfo parentInfo = this.infoStack.peek();
        ModelElement parentHandle = this.handleStack.peek();
        PackageDeclaration handle = null;
        handle = new PackageDeclaration(parentHandle, name);
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptFieldReference(String fieldName, int sourcePosition) {
    }

    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    public void acceptTypeReference(String typeName, int sourcePosition) {
    }

    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
        ImportContainerInfo importContainerInfo;
        ImportContainer importContainer;
        String containerName;
        ModelElement parentHandle = this.handleStack.peek();
        ISourceModule parentCU = parentHandle.getSourceModule();
        if (this.importContainers == null) {
            this.importContainers = new HashMap<String, ImportContainer>();
        }
        if ((containerName = importInfo.containerName) == null) {
            containerName = "";
        }
        if ((importContainer = this.importContainers.get(containerName)) == null) {
            importContainer = this.createImportContainer(parentCU, containerName);
            this.importContainers.put(containerName, importContainer);
            importContainerInfo = new ImportContainerInfo();
            ModelElementInfo parentInfo = this.infoStack.peek();
            parentInfo.addChild(importContainer);
            this.newElements.put(importContainer, importContainerInfo);
        } else {
            importContainerInfo = (ImportContainerInfo)this.newElements.get(importContainer);
        }
        String elementName = ModelManager.getModelManager().intern(importInfo.name);
        ImportDeclaration handle = this.createImportDeclaration(importContainer, elementName, importInfo.version);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(importInfo.sourceStart);
        info.setSourceRangeEnd(importInfo.sourceEnd);
        importContainerInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    protected ImportContainer createImportContainer(ISourceModule parent, String container) {
        return new ImportContainer((AbstractSourceModule)parent, container);
    }

    protected ImportDeclaration createImportDeclaration(ImportContainer parent, String name, String version) {
        return new ImportDeclaration(parent, name, version);
    }

    public int getMode() {
        return 1;
    }
}

