/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

public abstract class ReferenceLocation {
    public static final ReferenceLocation UNKNOWN = new ReferenceLocation(){

        public int getNameStart() {
            return 0;
        }

        public int getNameEnd() {
            return 0;
        }

        public int getDeclarationStart() {
            return 0;
        }

        public int getDeclarationEnd() {
            return 0;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };

    public abstract int getDeclarationStart();

    public abstract int getDeclarationEnd();

    public abstract int getNameStart();

    public abstract int getNameEnd();

    public static ReferenceLocation create(int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
        return new SimpleLocation(declarationStart, declarationEnd, nameStart, nameEnd);
    }

    public static ReferenceLocation create(int start, int end) {
        return new RangeLocation(start, end);
    }

    private static class RangeLocation
    extends ReferenceLocation {
        private final int start;
        private final int end;

        public RangeLocation(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getDeclarationEnd() {
            return this.end;
        }

        public int getDeclarationStart() {
            return this.start;
        }

        public int getNameEnd() {
            return this.end;
        }

        public int getNameStart() {
            return this.start;
        }

        public String toString() {
            return "[" + this.start + ".." + this.end + "]";
        }
    }

    private static class SimpleLocation
    extends ReferenceLocation {
        private final int declarationStart;
        private final int declarationEnd;
        private final int nameStart;
        private final int nameEnd;

        public SimpleLocation(int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
            this.declarationStart = declarationStart;
            this.declarationEnd = declarationEnd;
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        public int getDeclarationEnd() {
            return this.declarationEnd;
        }

        public int getDeclarationStart() {
            return this.declarationStart;
        }

        public int getNameEnd() {
            return this.nameEnd;
        }

        public int getNameStart() {
            return this.nameStart;
        }

        public String toString() {
            return "[" + this.declarationStart + ".." + this.declarationEnd + "," + this.nameStart + ".." + this.nameEnd + "]";
        }
    }
}

