/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.StringTokenizer;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;

public class JSDocSupport
implements IModelBuilder {
    private static final String PARAM_TAG = "@param";
    private static final String TYPE_TAG = "@type";

    public void processMethod(ITypeInfoContext context, FunctionStatement statement, IModelBuilder.IMethod method) {
        if (statement.getDocumentation() == null) {
            return;
        }
        String comment = statement.getDocumentation().getText();
        if (method.getType() == null) {
            this.parseType(context, method, comment);
        }
        this.parseParams(context, method, comment);
    }

    private void parseParams(ITypeInfoContext context, IModelBuilder.IMethod method, String comment) {
        int index = comment.indexOf(PARAM_TAG);
        while (index != -1) {
            int endLineIndex = comment.indexOf("\n", index);
            if (endLineIndex == -1) {
                endLineIndex = comment.length();
            }
            StringTokenizer st = new StringTokenizer(comment.substring(index + PARAM_TAG.length(), endLineIndex));
            String type = null;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("{") && token.endsWith("}")) {
                    type = token.substring(1, token.length() - 1);
                    continue;
                }
                if (type == null) continue;
                IModelBuilder.IParameter parameter = method.getParameter(token);
                if (parameter == null || parameter.getType() != null) break;
                parameter.setType(context.getType(type));
                break;
            }
            index = comment.indexOf(PARAM_TAG, endLineIndex);
        }
    }

    private void parseType(ITypeInfoContext context, IModelBuilder.IMethod method, String comment) {
        int index = comment.indexOf(TYPE_TAG);
        if (index != -1) {
            StringTokenizer st;
            int endLineIndex = comment.indexOf("\n", index);
            if (endLineIndex == -1) {
                endLineIndex = comment.length();
            }
            if ((st = new StringTokenizer(comment.substring(index + TYPE_TAG.length(), endLineIndex))).hasMoreTokens()) {
                String typeToken = st.nextToken();
                method.setType(context.getType(typeToken));
            }
        }
    }
}

