/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementValue
implements IValue {
    public static ElementValue findMember(Type type, String name) {
        if (type != null) {
            ArrayList<Member> selection = new ArrayList<Member>(4);
            for (Member member : type.getMembers()) {
                if (!name.equals(member.getName())) continue;
                selection.add(member);
            }
            if (!selection.isEmpty()) {
                return new MemberValue(selection.toArray(new Member[selection.size()]));
            }
        }
        return null;
    }

    public static ElementValue createFor(Element element) {
        if (element instanceof Method) {
            return new MethodValue((Method)element);
        }
        if (element instanceof Property) {
            return new PropertyValue((Property)element);
        }
        return new TypeValue(Collections.singleton((Type)element));
    }

    protected abstract Object getElements();

    @Override
    public final void clear() {
    }

    @Override
    public final void addValue(IValue src) {
    }

    @Override
    public final void addReference(IValue src) {
    }

    @Override
    public final Object getAttribute(String key) {
        if ("ELEMENT".equals(key)) {
            return this.getElements();
        }
        return null;
    }

    @Override
    public final void removeAttribute(String key) {
    }

    @Override
    public final void setAttribute(String key, Object value) {
    }

    @Override
    public final Set<String> getDirectChildren() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return Collections.emptySet();
    }

    @Override
    public void deleteChild(String name) {
    }

    @Override
    public final boolean hasChild(String name) {
        return false;
    }

    @Override
    public final IValue createChild(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putChild(String name, IValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceKind getKind() {
        return ReferenceKind.UNKNOWN;
    }

    @Override
    public final ReferenceLocation getLocation() {
        return ReferenceLocation.UNKNOWN;
    }

    @Override
    public final Set<Type> getTypes() {
        return Collections.emptySet();
    }

    @Override
    public final void setDeclaredType(Type declaredType) {
    }

    @Override
    public final void setKind(ReferenceKind kind) {
    }

    @Override
    public final void setLocation(ReferenceLocation location) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberValue
    extends ElementValue
    implements IValue {
        private final Member[] members;

        public MemberValue(Member[] members) {
            this.members = members;
        }

        protected Member[] getElements() {
            return this.members;
        }

        @Override
        public ReferenceKind getKind() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Method) {
                    return ReferenceKind.METHOD;
                }
                ++n2;
            }
            return ReferenceKind.PROPERTY;
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            int n;
            if ("()".equals(name)) {
                HashSet<Type> types = null;
                Member[] memberArray = this.members;
                int n2 = this.members.length;
                n = 0;
                while (n < n2) {
                    Method method;
                    Member member = memberArray[n];
                    if (member instanceof Method && (method = (Method)member).getType() != null) {
                        if (types == null) {
                            types = new HashSet<Type>();
                        }
                        types.add(method.getType());
                    }
                    ++n;
                }
                if (types != null) {
                    return new TypeValue(types);
                }
            }
            Member[] memberArray = this.members;
            n = this.members.length;
            int n3 = 0;
            while (n3 < n) {
                Property property;
                ElementValue child;
                Member member = memberArray[n3];
                if (member instanceof Property && (child = ElementValue.findMember((property = (Property)member).getType(), name)) != null) {
                    return child;
                }
                ++n3;
            }
            return null;
        }

        @Override
        public Type getDeclaredType() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Property property;
                Member member = memberArray[n2];
                if (member instanceof Property && (property = (Property)member).getType() != null) {
                    return property.getType();
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Set<Type> getDeclaredTypes() {
            HashSet<Type> types = null;
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Property property;
                Member member = memberArray[n2];
                if (member instanceof Property && (property = (Property)member).getType() != null) {
                    if (types == null) {
                        types = new HashSet<Type>();
                    }
                    types.add(property.getType());
                }
                ++n2;
            }
            if (types != null) {
                return types;
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodValue
    extends ElementValue
    implements IValue {
        private final Method method;

        public MethodValue(Method method) {
            this.method = method;
        }

        @Override
        protected Method getElements() {
            return this.method;
        }

        @Override
        public ReferenceKind getKind() {
            return ReferenceKind.METHOD;
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            if ("()".equals(name) && this.method.getType() != null) {
                return new TypeValue(Collections.singleton(this.method.getType()));
            }
            return null;
        }

        @Override
        public Type getDeclaredType() {
            return null;
        }

        @Override
        public Set<Type> getDeclaredTypes() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyValue
    extends ElementValue
    implements IValue {
        private final Property property;

        public PropertyValue(Property property) {
            this.property = property;
        }

        @Override
        protected Property getElements() {
            return this.property;
        }

        @Override
        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            return ElementValue.findMember(this.property.getType(), name);
        }

        @Override
        public Type getDeclaredType() {
            return this.property.getType();
        }

        @Override
        public Set<Type> getDeclaredTypes() {
            if (this.property.getType() != null) {
                return Collections.singleton(this.property.getType());
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeValue
    extends ElementValue
    implements IValue {
        private final Set<Type> types;

        public TypeValue(Set<Type> types) {
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray(new Type[this.types.size()]);
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            for (Type type : this.types) {
                ElementValue child = TypeValue.findMember(type, name);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        @Override
        public Type getDeclaredType() {
            return this.types.iterator().next();
        }

        @Override
        public Set<Type> getDeclaredTypes() {
            return this.types;
        }
    }
}

