/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedValueCollection
extends ValueCollection {
    protected NestedValueCollection(IValueCollection parent) {
        super(parent);
    }

    @Override
    public boolean isScope() {
        return false;
    }

    @Override
    public IValueReference getReturnValue() {
        return this.getParent().getReturnValue();
    }

    @Override
    public IValueReference getThis() {
        return this.getParent().getThis();
    }

    protected static void mergeTo(IValueCollection parent, List<NestedValueCollection> collections) {
        HashSet<String> names = new HashSet<String>();
        for (NestedValueCollection collection : collections) {
            names.addAll(collection.getValue().getDirectChildren());
        }
        ArrayList<IValueReference> childValues = new ArrayList<IValueReference>();
        for (String childName : names) {
            childValues.clear();
            for (NestedValueCollection collection : collections) {
                IValueReference childValue = collection.getChild(childName);
                if (!childValue.exists()) continue;
                childValues.add(childValue);
            }
            IValueReference value = parent.getChild(childName);
            boolean set = collections.size() == 2 && childValues.size() == collections.size();
            for (IValueReference childValue : childValues) {
                if (set) {
                    value.setValue(childValue);
                } else {
                    value.addValue(childValue, false);
                }
                set = false;
            }
        }
    }
}

