/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.ISourceModuleWizard;
import org.eclipse.dltk.ui.wizards.ISourceModuleWizardExtension;
import org.eclipse.dltk.ui.wizards.Messages;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.NewSourceModulePage;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewSourceModuleWizard
extends NewElementWizard
implements ISourceModuleWizard {
    private NewSourceModulePage page;
    private ISourceModule module;
    private final List<ISourceModuleWizardExtension> extensions = new ArrayList<ISourceModuleWizardExtension>();
    private boolean created = false;
    private String mode = null;
    private Set<String> disabledModes = null;
    private Map<String, ListenerList> listeners = null;

    protected abstract NewSourceModulePage createNewSourceModulePage();

    public void addPages() {
        super.addPages();
        this.page = this.createNewSourceModulePage();
        this.createExtensions();
        this.page.init(this.getSelection());
        this.addPage((IWizardPage)this.page);
    }

    private void createExtensions() {
        WizardExtensionManager manager = new WizardExtensionManager(this.page.getRequiredNature());
        LazyExtensionManager.Descriptor[] descriptorArray = manager.getDescriptors();
        int n = descriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            ISourceModuleWizardExtension extension = (ISourceModuleWizardExtension)descriptor.get();
            if (extension != null && extension.start(this)) {
                this.extensions.add(extension);
            }
            ++n2;
        }
    }

    public void createPageControls(Composite pageContainer) {
        for (ISourceModuleWizardExtension extension : this.extensions) {
            extension.initialize();
        }
        super.createPageControls(pageContainer);
        this.created = true;
    }

    protected List<ISourceModuleWizardExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    @Override
    public IModelElement getCreatedElement() {
        return this.module;
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.module = this.page.createFile(monitor);
    }

    @Override
    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result && this.module != null) {
            this.openSourceModule(this.module);
        }
        return result;
    }

    protected void openSourceModule(final ISourceModule module) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    EditorUtility.openInEditor(module);
                }
                catch (PartInitException e) {
                    String msg = NLS.bind((String)Messages.NewSourceModuleWizard_errorInOpenInEditor, (Object)module.getElementName());
                    DLTKUIPlugin.logErrorMessage(msg, e);
                }
                catch (ModelException e) {
                    String msg = NLS.bind((String)Messages.NewSourceModuleWizard_errorInOpenInEditor, (Object)module.getElementName());
                    DLTKUIPlugin.logErrorMessage(msg, e);
                }
            }
        });
    }

    @Override
    public IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment((IProject)this.getProject());
    }

    @Override
    public IProject getProject() {
        return this.getFolder().getScriptProject().getProject();
    }

    @Override
    public IScriptFolder getFolder() {
        return this.page.getScriptFolder();
    }

    @Override
    public String getFileName() {
        return this.page.getFileName();
    }

    @Override
    public void validate() {
        this.page.handleFieldChanged("NewSourceModulePage.extensions");
    }

    @Override
    public String getMode() {
        if (!this.created) {
            return this.mode;
        }
        return this.page.getMode();
    }

    @Override
    public void setMode(String mode) {
        if (!this.created) {
            this.mode = mode;
        } else {
            this.page.setMode(mode);
        }
    }

    @Override
    public void enableMode(String mode, boolean enable) {
        if (!this.created) {
            if (enable) {
                if (this.disabledModes != null) {
                    this.disabledModes.remove(mode);
                }
            } else {
                if (this.disabledModes == null) {
                    this.disabledModes = new HashSet<String>();
                }
                this.disabledModes.add(mode);
            }
        } else {
            this.page.enableMode(mode, enable);
        }
    }

    boolean isModeEnabled(String mode) {
        if (this.disabledModes == null) {
            return true;
        }
        return !this.disabledModes.contains(mode);
    }

    @Override
    public void addFieldChangeListener(String field, ISourceModuleWizard.IFieldChangeListener listener) {
        ListenerList list;
        if (this.listeners == null) {
            this.listeners = new HashMap<String, ListenerList>();
        }
        if ((list = this.listeners.get(field)) == null) {
            list = new ListenerList();
            this.listeners.put(field, list);
        }
        list.add((Object)listener);
    }

    @Override
    public void removeFieldChangeListener(String field, ISourceModuleWizard.IFieldChangeListener listener) {
        ListenerList list;
        if (this.listeners != null && (list = this.listeners.get(field)) != null) {
            list.remove((Object)listener);
            if (list.isEmpty()) {
                this.listeners.remove(field);
            }
        }
    }

    void fireFieldChange(String field) {
        ListenerList list;
        if (this.listeners != null && (list = this.listeners.get(field)) != null) {
            Object[] objectArray = list.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof ISourceModuleWizard.IFieldChangeListener) {
                    ((ISourceModuleWizard.IFieldChangeListener)listener).fieldChanged();
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WizardExtensionManager
    extends LazyExtensionManager<ISourceModuleWizardExtension> {
        private final String nature;
        private static final String ATTR_NATURE = "nature";

        public WizardExtensionManager(String nature) {
            super("org.eclipse.dltk.ui.sourceModuleWizardExtension");
            this.nature = nature;
        }

        protected boolean isValidDescriptor(LazyExtensionManager.Descriptor<ISourceModuleWizardExtension> descriptor) {
            String extensionNatureId = descriptor.getAttribute(ATTR_NATURE);
            return extensionNatureId == null || this.nature.equals(extensionNatureId) || extensionNatureId.equals("#");
        }
    }
}

