/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ui.text.IPartitioningProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitioningFoldingBlockProvider
implements IFoldingBlockProvider {
    private final IPartitioningProvider partitioningProvider;
    private int fBlockLinesMin;
    private boolean fDocsFolding;
    private boolean fCommentsFolding;
    private boolean fFoldNewLines;
    private boolean fInitCollapseComments;
    private boolean fInitCollapseDocs;
    private boolean fInitCollapseHeaderComments;
    protected IFoldingBlockRequestor requestor;

    public PartitioningFoldingBlockProvider(IPartitioningProvider partitioningProvider) {
        this.partitioningProvider = partitioningProvider;
    }

    @Override
    public void initializePreferences(IPreferenceStore preferenceStore) {
        this.fBlockLinesMin = preferenceStore.getInt("editor_folding_lines_limit");
        this.fDocsFolding = preferenceStore.getBoolean("editor_docs_folding_enabled");
        this.fCommentsFolding = preferenceStore.getBoolean("editor_comments_folding_enabled");
        this.fFoldNewLines = preferenceStore.getBoolean("editor_comments_folding_join_newlines");
        this.fInitCollapseComments = preferenceStore.getBoolean("editor_folding_init_comments");
        this.fInitCollapseHeaderComments = preferenceStore.getBoolean("editor_folding_init_header_comments");
        this.fInitCollapseDocs = preferenceStore.getBoolean("editor_folding_init_docs");
    }

    protected boolean isFoldingDocs() {
        return this.fDocsFolding;
    }

    protected void setFoldingDocs(boolean value) {
        this.fDocsFolding = value;
    }

    protected boolean isFoldingComments() {
        return this.fCommentsFolding;
    }

    protected void setFoldingComments(boolean value) {
        this.fCommentsFolding = value;
    }

    protected boolean isJoinCommentsSeparatedByEmptyLines() {
        return this.fFoldNewLines;
    }

    protected void setJoinCommentsSeparatedByEmptyLines(boolean value) {
        this.fFoldNewLines = value;
    }

    protected boolean isCollapseComments() {
        return this.fInitCollapseComments;
    }

    protected boolean isCollapseHeaderComment() {
        return this.fInitCollapseHeaderComments;
    }

    protected boolean isCollapseDocs() {
        return this.fInitCollapseDocs;
    }

    protected void setCollapseComments(boolean value) {
        this.fInitCollapseComments = value;
    }

    protected void setCollapseHeaderComment(boolean value) {
        this.fInitCollapseHeaderComments = value;
    }

    protected void setCollapseDocs(boolean value) {
        this.fInitCollapseDocs = value;
    }

    @Override
    public int getMinimalLineCount() {
        return this.fBlockLinesMin;
    }

    protected void setMinimalLineCount(int value) {
        this.fBlockLinesMin = value;
    }

    @Override
    public void setRequestor(IFoldingBlockRequestor requestor) {
        this.requestor = requestor;
    }

    private List<ITypedRegion> computePartitioning(Document d) {
        ArrayList<ITypedRegion> docRegionList = new ArrayList<ITypedRegion>();
        int offset = 0;
        try {
            while (true) {
                ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.partitioningProvider.getPartitioning(), (int)offset, (boolean)true);
                docRegionList.add(region);
                offset = region.getLength() + region.getOffset() + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            return docRegionList;
        }
    }

    protected void computeBlocksForPartitionType(IFoldingContent content, String partition, IFoldingBlockKind kind, boolean collapse) {
        block12: {
            try {
                String contents = content.getSourceContents();
                if (contents == null || contents.length() == 0) {
                    return;
                }
                Document document = new Document(contents);
                this.installDocumentStuff(document);
                ITypedRegion start = null;
                ITypedRegion lastRegion = null;
                ArrayList<IRegion> regions = new ArrayList<IRegion>();
                for (ITypedRegion region : this.computePartitioning(document)) {
                    if (region.getType().equals(partition) && this.startsAtLineBegin(document, region)) {
                        if (start == null) {
                            start = region;
                        }
                    } else if (!(start != null && (this.isBlankRegion((IDocument)document, region) || this.isEmptyRegion((IDocument)document, region) && this.isJoinCommentsSeparatedByEmptyLines()))) {
                        if (start != null) {
                            assert (lastRegion != null);
                            int offset0 = start.getOffset();
                            int length0 = lastRegion.getOffset() + lastRegion.getLength() - offset0 - 1;
                            length0 = contents.substring(offset0, offset0 + length0).trim().length();
                            regions.add((IRegion)new Region(offset0, length0));
                        }
                        start = null;
                    }
                    lastRegion = region;
                }
                if (start != null) {
                    assert (lastRegion != null);
                    int offset0 = start.getOffset();
                    int length0 = lastRegion.getOffset() - offset0 + lastRegion.getLength() - 1;
                    regions.add((IRegion)new Region(offset0, length0));
                }
                this.reportRegions(document, regions, kind, collapse);
                this.removeDocumentStuff(document);
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block12;
                e.printStackTrace();
            }
        }
    }

    protected void reportRegions(Document document, List<IRegion> regions, IFoldingBlockKind kind, boolean collapse) throws BadLocationException {
        for (IRegion region : regions) {
            Object element = null;
            this.requestor.acceptBlock(region.getOffset(), region.getOffset() + region.getLength(), kind, element, collapse);
        }
    }

    protected boolean isBlankRegion(IDocument document, ITypedRegion region) throws BadLocationException {
        String value = document.get(region.getOffset(), region.getLength());
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean startsAtLineBegin(Document d, ITypedRegion region) throws BadLocationException {
        int lineStart = d.getLineOffset(d.getLineOfOffset(region.getOffset()));
        return lineStart == region.getOffset() || this.isEmptyRegion((IDocument)d, lineStart, region.getOffset() - lineStart);
    }

    protected boolean isEmptyRegion(IDocument d, ITypedRegion r) throws BadLocationException {
        return this.isEmptyRegion(d, r.getOffset(), r.getLength());
    }

    protected boolean isEmptyRegion(IDocument d, int offset, int length) throws BadLocationException {
        return d.get(offset, length).trim().length() == 0;
    }

    private void installDocumentStuff(Document document) {
        FastPartitioner partitioner = new FastPartitioner(this.partitioningProvider.createPartitionScanner(), this.partitioningProvider.getPartitionContentTypes());
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.partitioningProvider.getPartitioning(), (IDocumentPartitioner)partitioner);
    }

    private void removeDocumentStuff(Document document) {
        String partitioning = this.partitioningProvider.getPartitioning();
        IDocumentPartitioner partitioner = document.getDocumentPartitioner(partitioning);
        if (partitioner != null) {
            document.setDocumentPartitioner(partitioning, null);
            partitioner.disconnect();
        }
    }
}

