/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.internal.corext.refactoring.Checks;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.CopyProjectFragmentChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.CopyScriptFolderChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.CopySourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.MoveProjectFragmentChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.MoveScriptFolderChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.MoveSourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.dltk.internal.corext.refactoring.reorg.CreateCopyOfSourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.dltk.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.dltk.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class ReorgPolicyFactory {
    private ReorgPolicyFactory() {
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IModelElement[] modelElements) throws ModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, modelElements);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IModelElement[] modelElements) throws ModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, modelElements);
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IModelElement[] selectedScriptElements) throws ModelException {
        Object[] modelElements;
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedScriptElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        if (ReorgPolicyFactory.isNothingToReorg((IResource[])resources, (IModelElement[])(modelElements = selectionComputer.getActualScriptElementsToReorg())) || ReorgPolicyFactory.containsNull(resources) || ReorgPolicyFactory.containsNull(modelElements) || ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 2) || ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 1) || ReorgUtils.hasElementsOfType((IResource[])resources, 12) || !ReorgPolicyFactory.haveCommonParent((IResource[])resources, (IModelElement[])modelElements)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 4)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IModelElement[])modelElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(modelElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(modelElements));
        }
        if (ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 3)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IModelElement[])modelElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyProjectFragmentsPolicy(ArrayTypeConverter.toProjectFragmentArray(modelElements));
            }
            return new MoveProjectFragmentsPolicy(ArrayTypeConverter.toProjectFragmentArray(modelElements));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 3) || ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IModelElement[])modelElements, 5)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(modelElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(modelElements));
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IModelElement[])modelElements)) {
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IModelElement[])modelElements, 5) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IModelElement[])modelElements) ? 1 : 0) != 0);
            if (copy) {
                return new CopySubCuElementsPolicy((IModelElement[])modelElements);
            }
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: ReorgPolicyFactory: Add MoveSubCuElementsPolicy support");
            }
        }
        return NO;
    }

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IModelElement[] modelElements) {
        int i = 0;
        while (i < modelElements.length) {
            if (ReorgUtils.isInsideSourceModule(modelElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IModelElement[] modelElements) {
        int i = 0;
        while (i < modelElements.length) {
            if (!ReorgUtils.isInsideSourceModule(modelElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean haveCommonParent(IResource[] resources, IModelElement[] modelElements) {
        return new ParentChecker(resources, modelElements).haveCommonParent();
    }

    private static boolean isNothingToReorg(IResource[] resources, IModelElement[] modelElements) {
        return resources.length + modelElements.length == 0;
    }

    private static class ActualSelectionComputer {
        private final IResource[] fResources;
        private final IModelElement[] fScriptElements;

        public ActualSelectionComputer(IModelElement[] modelElements, IResource[] resources) {
            this.fScriptElements = modelElements;
            this.fResources = resources;
        }

        public IModelElement[] getActualScriptElementsToReorg() throws ModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < this.fScriptElements.length) {
                IModelElement element = this.fScriptElements[i];
                if (element != null && !ReorgUtils.isDeletedFromEditor(element)) {
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        ISourceModule cu = type.getSourceModule();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!(element instanceof IScriptFolder && !element.isReadOnly() && element.getResource() != null || result.contains(element))) {
                        result.add(element);
                    }
                }
                ++i;
            }
            return result.toArray(new IModelElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            IModelElement element;
            HashSet modelElementSet = new HashSet(Arrays.asList(this.fScriptElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                if (!(this.fResources[i] == null || (element = DLTKCore.create((IResource)this.fResources[i])) != null && element.exists() && modelElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.fScriptElements.length) {
                IResource resource;
                element = this.fScriptElements[i];
                if (element != null && element.getElementType() == 4 && !element.isReadOnly() && (resource = element.getResource()) != null && !result.contains(resource)) {
                    result.add(resource);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }

    private static class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ISourceModule[] cus) {
            super(files, folders, cus);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ISourceModule[] cus = this.getCus();
            int i = 0;
            while (i < cus.length) {
                this.fModifications.copy(cus[i], jArgs, rArgs);
                ++i;
            }
            IResource[] resources = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int i2 = 0;
            while (i2 < resources.length) {
                this.fModifications.copy(resources[i2], rArgs);
                ++i2;
            }
            return this.fModifications;
        }

        private Object getDestination() {
            IScriptFolder result = this.getDestinationAsScriptFolder();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ISourceModule[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            composite.markAsSynthetic();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(ISourceModule unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IScriptFolder pack = this.getDestinationAsScriptFolder();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        private static Change copyFileToContainer(ISourceModule cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource((IModelElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        private static Change copyCuToPackage(ISourceModule cu, IScriptFolder dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtils.getResource((IModelElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopySourceModuleChange simpleCopy = new CopySourceModuleChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = ResourceUtil.getResource(cu).getParent().getFullPath().append(newName);
                INewNameQuery nameQuery = copyQueries.createNewSourceModuleNameQuery(cu, newName);
                return new CreateCopyOfSourceModuleChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }
    }

    private static class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IScriptFolder[] ScriptFolders) {
            super(ScriptFolders);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IProjectFragment destination = this.getDestinationAsProjectFragment();
            CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)destination.getResource(), this.fReorgExecutionLog);
            IScriptFolder[] packages = this.getPackages();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.copy(packages[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws ModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IScriptFolder[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            composite.markAsSynthetic();
            IProjectFragment root = this.getDestinationAsProjectFragment();
            int i = 0;
            while (i < fragments.length) {
                composite.add(this.createChange(fragments[i], root, nameProposer, newNameQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IScriptFolder pack, IProjectFragment destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack, destination);
            IDLTKLanguageToolkit tk = null;
            tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)pack);
            IPath newPath = destination.getResource().getFullPath();
            if (newName != null) {
                newPath = newPath.append(newName);
            }
            if (newName == null || tk != null && tk.validateSourcePackage(newPath, EnvironmentManager.getEnvironment((IModelElement)destination))) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyScriptFolderChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }
    }

    private static class CopyProjectFragmentsPolicy
    extends ProjectFragmentsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyProjectFragmentsPolicy(IProjectFragment[] roots) {
            super(roots);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments javaArgs = new CopyArguments((Object)this.getDestinationScriptProject(), this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)this.getDestinationScriptProject().getProject(), this.fReorgExecutionLog);
            IProjectFragment[] roots = this.getRoots();
            int i = 0;
            while (i < roots.length) {
                this.fModifications.copy(roots[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IProjectFragment[] roots = this.getProjectFragments();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            composite.markAsSynthetic();
            IScriptProject destination = this.getDestinationScriptProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination, nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IProjectFragment root, IScriptProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewProjectFragmentNameQuery(root, newName);
            return new CopyProjectFragmentChange(root, destinationProject, nameQuery, null);
        }
    }

    private static class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IModelElement[] modelElements) {
            super(modelElements);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments args = new CopyArguments((Object)this.getScriptElementDestination(), this.fReorgExecutionLog);
            IModelElement[] modelElements = this.getScriptElements();
            int i = 0;
            while (i < modelElements.length) {
                this.fModifications.copy(modelElements[i], args, null);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws ModelException {
            if (DLTKCore.DEBUG) {
                System.err.println("ReorgPolicyFactory:createChange return null.");
            }
            return null;
        }

        public boolean canEnable() throws ModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IModelElement)this.getDestinationCu())});
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        private ISourceModule[] fCus;
        private IFolder[] fFolders;
        private IFile[] fFiles;

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ISourceModule[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            IOpenable openable;
            Assert.isNotNull((Object)modelElement);
            if (!modelElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (modelElement instanceof IScriptModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (modelElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!modelElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (modelElement instanceof IOpenable && !(openable = (IOpenable)modelElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (modelElement instanceof IProjectFragment) {
                IProjectFragment root = (IProjectFragment)modelElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideSourceModule(modelElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(modelElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws ModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            Assert.isTrue((resource.getType() != 8 ? 1 : 0) != 0);
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IModelElement modelElement) {
            switch (modelElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return !modelElement.isReadOnly();
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        public boolean canElementBeDestination(IModelElement modelElement) {
            switch (modelElement.getElementType()) {
                case 4: {
                    return !modelElement.isReadOnly();
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IModelElement jelDest = this.getScriptElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(jelDest));
        }

        protected final IModelElement getDestinationContainerAsScriptElement() {
            if (this.getScriptElementDestination() != null) {
                return this.getScriptElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IModelElement je = DLTKCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IScriptFolder getDestinationAsScriptFolder() {
            IScriptFolder javaAsPackage = FilesFoldersAndCusReorgPolicy.getScriptDestinationAsScriptFolder(this.getScriptElementDestination());
            if (javaAsPackage != null) {
                return javaAsPackage;
            }
            return FilesFoldersAndCusReorgPolicy.getResourceDestinationAsScriptFolder(this.getResourceDestination());
        }

        private static IScriptFolder getScriptDestinationAsScriptFolder(IModelElement scriptDest) {
            if (scriptDest == null || !scriptDest.exists()) {
                return null;
            }
            if (scriptDest instanceof IScriptFolder) {
                return (IScriptFolder)scriptDest;
            }
            if (scriptDest instanceof IProjectFragment) {
                return ((IProjectFragment)scriptDest).getScriptFolder("");
            }
            if (scriptDest instanceof IScriptProject) {
                try {
                    IProjectFragment root = ReorgUtils.getCorrespondingProjectFragment((IScriptProject)scriptDest);
                    if (root != null) {
                        return root.getScriptFolder("");
                    }
                }
                catch (ModelException modelException) {}
            }
            return (IScriptFolder)scriptDest.getAncestor(4);
        }

        private static IScriptFolder getResourceDestinationAsScriptFolder(IResource resource) {
            if (resource instanceof IFile) {
                return FilesFoldersAndCusReorgPolicy.getScriptDestinationAsScriptFolder(DLTKCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        public final IModelElement[] getScriptElements() {
            return this.fCus;
        }

        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IModelElement[])this.fCus);
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final ISourceModule[] getCus() {
            return this.fCus;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setFiles(this.fFiles);
            oh.setFolders(this.fFolders);
            oh.setCus(this.fCus);
            IScriptFolder destPack = this.getDestinationAsScriptFolder();
            if (destPack != null) {
                oh.confirmOverwritting(reorgQueries, (IModelElement)destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    oh.confirmOverwritting(reorgQueries, (IResource)destinationAsContainer);
                }
            }
            this.fFiles = oh.getFilesWithoutUnconfirmedOnes();
            this.fFolders = oh.getFoldersWithoutUnconfirmedOnes();
            this.fCus = oh.getCusWithoutUnconfirmedOnes();
        }
    }

    private static class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private boolean fUpdateReferences = true;
        private boolean fUpdateQualifiedNames = false;
        private String fFilePatterns;
        private TextChangeManager fChangeManager;
        private MoveModifications fModifications;

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ISourceModule[] cus) {
            super(files, folders, cus);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            int i;
            boolean updateReferenes;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IScriptFolder pack = this.getDestinationAsScriptFolder();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean bl = updateReferenes = this.canUpdateReferences() && this.getUpdateReferences();
            if (unitDestination != null) {
                ISourceModule[] units = this.getCus();
                i = 0;
                while (i < units.length) {
                    this.fModifications.move(units[i], new MoveArguments(unitDestination, updateReferenes));
                    ++i;
                }
            }
            if (container != null) {
                IFile[] files = this.getFiles();
                i = 0;
                while (i < files.length) {
                    this.fModifications.move((IResource)files[i], new MoveArguments((Object)container, updateReferenes));
                    ++i;
                }
                IFolder[] folders = this.getFolders();
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fModifications.move((IResource)folders[i2], new MoveArguments((Object)container, updateReferenes));
                    ++i2;
                }
            }
            return this.fModifications;
        }

        protected RefactoringStatus verifyDestination(IModelElement destination) throws ModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getScriptElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IScriptFolder destinationAsPackage = this.getDestinationAsScriptFolder();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws ModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IModelElement destinationContainerAsPackage = this.getDestinationContainerAsScriptElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getScriptElements()).getCommonParent();
        }

        public Change createChange(IProgressMonitor pm) throws ModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: ReorgPolicyFactory Add QualifiedNameSearchResult ");
            }
            return null;
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws ModelException {
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                    RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null);
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                composite.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                Change fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (fileMove instanceof CompositeChange) {
                    composite.merge((CompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                DynamicValidationStateChange dynamicValidationStateChange = composite;
                return dynamicValidationStateChange;
            }
            finally {
                pm.done();
            }
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws ModelException {
            pm.beginTask("", 1);
            try {
                if (!this.fUpdateReferences) {
                    TextChangeManager textChangeManager = new TextChangeManager();
                    return textChangeManager;
                }
                TextChangeManager textChangeManager = new TextChangeManager();
                return textChangeManager;
            }
            finally {
                pm.done();
            }
        }

        private Change createSimpleMoveChange(IProgressMonitor pm) {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            result.markAsSynthetic();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ISourceModule[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            int i = 0;
            while (i < files.length) {
                result.add(this.createChange((IResource)files[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                result.add(this.createChange((IResource)folders[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < cus.length) {
                result.add(this.createChange(cus[i]));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        private Change createChange(ISourceModule cu) {
            IScriptFolder pack = this.getDestinationAsScriptFolder();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        private static Change moveCuToPackage(ISourceModule cu, IScriptFolder dest) {
            IResource resource = ResourceUtil.getResource(cu);
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveSourceModuleChange(cu, dest);
        }

        private static Change moveFileToContainer(ISourceModule cu, IContainer dest) {
            return new MoveResourceChange(ResourceUtil.getResource(cu), dest);
        }

        private Change createChange(IResource res) {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws ModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IScriptFolder destination = this.getDestinationAsScriptFolder();
            if (destination != null) {
                ISourceModule[] cus = this.getCus();
                pm.beginTask("", cus.length);
                pm.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
                int i = 0;
                while (i < cus.length) {
                    ISourceModule cu = cus[i];
                    IType[] types = cu.getTypes();
                    SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                    typesMonitor.beginTask("", types.length);
                    int j = 0;
                    while (j < types.length) {
                        this.handleType(types[j], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                        if (typesMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++j;
                    }
                    typesMonitor.done();
                    ++i;
                }
            }
            pm.done();
        }

        private void handleType(IType type, IScriptFolder destination, IProgressMonitor pm) {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add QualifiedNameFinder support...");
            }
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                pm.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                RefactoringStatus result = new RefactoringStatus();
                this.confirmMovingReadOnly(reorgQueries);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                if (this.fUpdateQualifiedNames) {
                    this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 4));
                }
                result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
            finally {
                pm.done();
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getScriptElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public IFile[] getAllModifiedFiles() {
            HashSet result = new HashSet();
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllSourceModules())));
            if (this.getDestinationAsScriptFolder() != null && this.getUpdateReferences()) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        public boolean canUpdateReferences() {
            if (this.getCus().length == 0) {
                return false;
            }
            IScriptFolder pack = this.getDestinationAsScriptFolder();
            if (pack != null && pack.isRootFolder()) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return !ModelElementUtil.isDefaultPackage(commonParent);
        }

        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !ModelElementUtil.isDefaultPackage(this.getCommonParent());
        }

        public boolean canUpdateQualifiedNames() {
            IScriptFolder pack = this.getDestinationAsScriptFolder();
            return this.canEnableQualifiedNameUpdating() && pack != null && !pack.isRootFolder();
        }

        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private MoveModifications fModifications;

        MovePackagesPolicy(IScriptFolder[] ScriptFolders) {
            super(ScriptFolders);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            IScriptFolder[] packages = this.getPackages();
            IProjectFragment scriptDestination = this.getDestinationAsProjectFragment();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.move(packages[i], new MoveArguments((Object)scriptDestination, updateReferences));
                ++i;
            }
            return this.fModifications;
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            RefactoringStatus superStatus = super.verifyDestination(modelElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IProjectFragment root = this.getDestinationAsProjectFragment();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IProjectFragment root, IScriptFolder[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                IScriptFolder fragment = fragments[i];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Change createChange(IProgressMonitor pm) throws ModelException {
            IScriptFolder[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            result.markAsSynthetic();
            IProjectFragment root = this.getDestinationAsProjectFragment();
            int i = 0;
            while (i < fragments.length) {
                result.add(this.createChange(fragments[i], root));
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            pm.done();
            return result;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        private Change createChange(IScriptFolder pack, IProjectFragment destination) {
            return new MoveScriptFolderChange(pack, destination);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getScriptElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MoveProjectFragmentsPolicy
    extends ProjectFragmentsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private MoveModifications fModifications;

        MoveProjectFragmentsPolicy(IProjectFragment[] roots) {
            super(roots);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            boolean updateReferences;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IScriptProject destination = this.getDestinationScriptProject();
            boolean bl = updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            if (destination != null) {
                IProjectFragment[] roots = this.getProjectFragments();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.move(roots[i], new MoveArguments((Object)destination, updateReferences));
                    ++i;
                }
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm) throws ModelException {
            IProjectFragment[] roots = this.getProjectFragments();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            composite.markAsSynthetic();
            IScriptProject destination = this.getDestinationScriptProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        private Change createChange(IProjectFragment root, IScriptProject destination) {
            return new MoveProjectFragmentChange(root, destination.getProject(), null);
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            RefactoringStatus superStatus = super.verifyDestination(modelElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IScriptProject scriptProject = this.getDestinationScriptProject();
            if (MoveProjectFragmentsPolicy.isParentOfAny(scriptProject, this.getProjectFragments())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IScriptProject scriptProject, IProjectFragment[] roots) {
            int i = 0;
            while (i < roots.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(roots[i], scriptProject)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean canEnable() throws ModelException {
            if (!super.canEnable()) {
                return false;
            }
            IProjectFragment[] roots = this.getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].isReadOnly() && !roots[i].isArchive()) {
                    IResource res = roots[i].getResource();
                    if (res != null) {
                        ResourceAttributes attributes = roots[i].getResource().getResourceAttributes();
                        if (attributes == null || attributes.isReadOnly()) {
                            return false;
                        }
                    } else {
                        if (DLTKCore.DEBUG) {
                            System.err.println("TODO: Add correct code of copy external folders in...");
                        }
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getScriptElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        private NewNameProposer() {
        }

        public String createNewName(ISourceModule cu, IScriptFolder destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOf1, cu.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOfMore, new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return NewNameProposer.removeTrailingScript(newName);
                }
                ++i;
            }
        }

        private static String removeTrailingScript(String name) {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: ReorgPolicyFactory add removeScriptLikeExtension code...");
            }
            return name;
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOf1, res.getName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOfMore, new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IScriptFolder pack, IProjectFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, pack.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        private static boolean isNewNameOk(IScriptFolder dest, String newName) {
            return !dest.getSourceModule(newName).exists();
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IProjectFragment root, String newName) {
            return !root.getScriptFolder(newName).exists();
        }
    }

    private static class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        public boolean canEnable() throws ModelException {
            return false;
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws ModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IModelElement[] getScriptElements() {
            return new IModelElement[0];
        }
    }

    private static class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws ModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public boolean canEnable() throws ModelException {
            return false;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IModelElement[] getScriptElements() {
            return new IModelElement[0];
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return true;
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IScriptFolder[] fScriptFolders;

        public IModelElement[] getScriptElements() {
            return this.fScriptFolders;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        protected IScriptFolder[] getPackages() {
            return this.fScriptFolders;
        }

        public PackagesReorgPolicy(IScriptFolder[] ScriptFolders) {
            Assert.isNotNull((Object)ScriptFolders);
            this.fScriptFolders = ScriptFolders;
        }

        public boolean canEnable() throws ModelException {
            int i = 0;
            while (i < this.fScriptFolders.length) {
                if (ModelElementUtil.isDefaultPackage(this.fScriptFolders[i]) || this.fScriptFolders[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IModelElement[])this.fScriptFolders);
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
        }

        protected IProjectFragment getDestinationAsProjectFragment() throws ModelException {
            return this.getDestinationAsProjectFragment(this.getScriptElementDestination());
        }

        public boolean canChildrenBeDestinations(IModelElement modelElement) {
            switch (modelElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IModelElement modelElement) {
            switch (modelElement.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        private IProjectFragment getDestinationAsProjectFragment(IModelElement modelElement) throws ModelException {
            IScriptFolder pack;
            if (modelElement == null) {
                return null;
            }
            if (modelElement instanceof IProjectFragment) {
                return (IProjectFragment)modelElement;
            }
            if (modelElement instanceof IScriptFolder && (pack = (IScriptFolder)modelElement).getParent() instanceof IProjectFragment) {
                return (IProjectFragment)pack.getParent();
            }
            if (modelElement instanceof IScriptProject) {
                return ReorgUtils.getCorrespondingProjectFragment((IScriptProject)modelElement);
            }
            return null;
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            Assert.isNotNull((Object)modelElement);
            if (!modelElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (modelElement instanceof IScriptModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IProjectFragment destRoot = this.getDestinationAsProjectFragment(modelElement);
            if (!ReorgUtils.isSourceFolder((IModelElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws ModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackages(this.fScriptFolders);
            IProjectFragment destRoot = this.getDestinationAsProjectFragment();
            oh.confirmOverwritting(reorgQueries, (IModelElement)destRoot);
            this.fScriptFolders = oh.getPackagesWithoutUnconfirmedOnes();
        }
    }

    private static abstract class ProjectFragmentsReorgPolicy
    extends ReorgPolicy {
        private IProjectFragment[] fProjectFragments;

        public IModelElement[] getScriptElements() {
            return this.fProjectFragments;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IProjectFragment[] getRoots() {
            return this.fProjectFragments;
        }

        public ProjectFragmentsReorgPolicy(IProjectFragment[] roots) {
            Assert.isNotNull((Object)roots);
            this.fProjectFragments = roots;
        }

        public boolean canEnable() throws ModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fProjectFragments.length) {
                if (!(ReorgUtils.isSourceFolder((IModelElement)this.fProjectFragments[i]) || this.fProjectFragments[i].isArchive() && !this.fProjectFragments[i].isExternal())) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IModelElement[])this.fProjectFragments);
        }

        public boolean canChildrenBeDestinations(IModelElement modelElement) {
            switch (modelElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IModelElement modelElement) {
            return modelElement.getElementType() == 2;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
        }

        protected RefactoringStatus verifyDestination(IModelElement modelElement) throws ModelException {
            Assert.isNotNull((Object)modelElement);
            if (!modelElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (modelElement instanceof IScriptModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(modelElement instanceof IScriptProject) && !(modelElement instanceof IProjectFragment)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (modelElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtils.isProjectFragment(modelElement.getScriptProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        protected IScriptProject getDestinationScriptProject() {
            return this.getDestinationAsScriptProject(this.getScriptElementDestination());
        }

        private IScriptProject getDestinationAsScriptProject(IModelElement modelElementDestination) {
            if (modelElementDestination == null) {
                return null;
            }
            return modelElementDestination.getScriptProject();
        }

        protected IProjectFragment[] getProjectFragments() {
            return this.fProjectFragments;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setProjectFragments(this.fProjectFragments);
            IScriptProject scriptProject = this.getDestinationScriptProject();
            oh.confirmOverwritting(reorgQueries, (IModelElement)scriptProject);
            this.fProjectFragments = oh.getProjectFragmentsWithoutUnconfirmedOnes();
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private IResource fResourceDestination;
        private IModelElement fScriptElementDestination;

        private ReorgPolicy() {
        }

        public final RefactoringStatus setDestination(IResource destination) throws ModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fResourceDestination = destination;
            return this.verifyDestination(destination);
        }

        public final RefactoringStatus setDestination(IModelElement destination) throws ModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fScriptElementDestination = destination;
            return this.verifyDestination(destination);
        }

        protected abstract RefactoringStatus verifyDestination(IModelElement var1) throws ModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws ModelException;

        public boolean canChildrenBeDestinations(IModelElement modelElement) {
            return true;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        public boolean canElementBeDestination(IModelElement modelElement) {
            return true;
        }

        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        private void resetDestinations() {
            this.fScriptElementDestination = null;
            this.fResourceDestination = null;
        }

        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        public final IModelElement getScriptElementDestination() {
            return this.fScriptElementDestination;
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IFile[] allModifiedFiles = this.getAllModifiedFiles();
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < allModifiedFiles.length) {
                deltaFactory.change(allModifiedFiles[i]);
                ++i;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
            }
            return new RefactoringStatus();
        }

        public boolean hasAllInputSet() {
            return this.fScriptElementDestination != null || this.fResourceDestination != null;
        }

        public boolean canUpdateReferences() {
            return false;
        }

        public boolean getUpdateReferences() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public void setUpdateReferences(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        public boolean canUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public String getFilePatterns() {
            Assert.isTrue((boolean)false);
            return null;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public void setFilePatterns(String patterns) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateQualifiedNames(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public boolean canEnable() throws ModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IModelElement[] modelElements = this.getScriptElements();
            int i2 = 0;
            while (i2 < modelElements.length) {
                IModelElement element = modelElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        private final IModelElement[] fScriptElements;

        SubCuElementReorgPolicy(IModelElement[] modelElements) {
            Assert.isNotNull((Object)modelElements);
            this.fScriptElements = modelElements;
        }

        protected final RefactoringStatus verifyDestination(IResource destination) throws ModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }

        protected final ISourceModule getSourceCu() {
            return (ISourceModule)this.fScriptElements[0].getAncestor(5);
        }

        public final IModelElement[] getScriptElements() {
            return this.fScriptElements;
        }

        public final IResource[] getResources() {
            return new IResource[0];
        }

        protected final ISourceModule getDestinationCu() {
            return SubCuElementReorgPolicy.getDestinationCu(this.getScriptElementDestination());
        }

        protected static final ISourceModule getDestinationCu(IModelElement destination) {
            if (destination instanceof ISourceModule) {
                return (ISourceModule)destination;
            }
            return (ISourceModule)destination.getAncestor(5);
        }

        public boolean canEnable() throws ModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fScriptElements.length) {
                IMember member;
                if (this.fScriptElements[i] instanceof IMember && (member = (IMember)this.fScriptElements[i]).getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected RefactoringStatus verifyDestination(IModelElement destination) throws ModelException {
            return this.recursiveVerifyDestination(destination);
        }

        private RefactoringStatus recursiveVerifyDestination(IModelElement destination) throws ModelException {
            Assert.isNotNull((Object)destination);
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IScriptModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof ISourceModule) && !ReorgUtils.isInsideSourceModule(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ISourceModule destinationCu = SubCuElementReorgPolicy.getDestinationCu(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 5: {
                    int[] types0 = new int[]{8, 9};
                    if (!ReorgUtils.hasElementsOfType(this.getScriptElements(), types0)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: {
                    return this.recursiveVerifyDestination(destination.getParent());
                }
                case 7: {
                    if (!DLTKCore.DEBUG) break;
                    System.err.println("Add import support here...");
                }
            }
            return new RefactoringStatus();
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }
    }
}

