/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.structure;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.caching.StructureModelProcessor;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.model.binary.IBinaryModule;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.IndexDocument;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ModelManager;

public class StructureIndexer
extends AbstractIndexer {
    static long maxWorkTime = 0L;

    public StructureIndexer(IndexDocument document) {
        super(document);
    }

    public void indexDocument() {
        long ended;
        boolean performed;
        SourceIndexerRequestor requestor;
        ISourceModule sourceModule;
        long started;
        block25: {
            IContentCache coreCache;
            InputStream stream;
            started = System.currentTimeMillis();
            IDLTKLanguageToolkit toolkit = this.document.getToolkit();
            if (toolkit == null) {
                return;
            }
            sourceModule = this.document.getSourceModule();
            requestor = ModelManager.getModelManager().indexManager.getSourceRequestor(sourceModule.getScriptProject());
            requestor.setIndexer(this);
            if (!this.document.isExternal()) {
                IScriptFolder folder = (IScriptFolder)sourceModule.getParent();
                requestor.setPackageName(folder.getElementName());
            } else {
                String ppath = this.document.getPath().toString();
                String pkgName = new Path(ppath.substring(ppath.indexOf("|") + 1)).removeLastSegments(1).toString();
                requestor.setPackageName(pkgName);
            }
            performed = false;
            IFileHandle handle = EnvironmentPathUtils.getFile(sourceModule);
            if (handle != null && (stream = (coreCache = ModelManager.getModelManager().getCoreCache()).getCacheEntryAttribute(handle, "_sind")) != null) {
                try {
                    try {
                        StructureModelProcessor processor = new StructureModelProcessor(stream, requestor);
                        processor.perform();
                        performed = true;
                    }
                    catch (IOException e) {
                        performed = false;
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            if (DLTKCore.DEBUG) {
                                e2.printStackTrace();
                            }
                            break block25;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block26: {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block26;
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block25;
                    e.printStackTrace();
                }
            }
        }
        if (!performed) {
            Object parser;
            if (!sourceModule.isBinary()) {
                parser = DLTKLanguageManager.getSourceElementParser(sourceModule);
                if (parser == null) {
                    return;
                }
                parser.setRequestor(requestor);
                if (sourceModule instanceof IModuleSource) {
                    parser.parseSourceModule((IModuleSource)((Object)sourceModule));
                } else {
                    parser.parseSourceModule(new ParserInput(sourceModule));
                }
            } else {
                parser = DLTKLanguageManager.getBinaryElementParser(sourceModule);
                if (parser == null) {
                    return;
                }
                parser.setRequestor(requestor);
                parser.parseBinaryModule((IBinaryModule)sourceModule);
            }
        }
        if ((ended = System.currentTimeMillis()) - started > maxWorkTime) {
            maxWorkTime = ended - started;
        }
    }

    private static class ParserInput
    implements IModuleSource {
        private ISourceModule module;

        public ParserInput(ISourceModule module) {
            this.module = module;
        }

        public char[] getContentsAsCharArray() {
            try {
                return this.module.getSourceAsCharArray();
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return CharOperation.NO_CHAR;
            }
        }

        public IModelElement getModelElement() {
            return this.module;
        }

        public String getSourceContents() {
            block3: {
                if (this.module != null) {
                    try {
                        return this.module.getSource();
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block3;
                        e.printStackTrace();
                    }
                }
            }
            return "";
        }

        public String getFileName() {
            return this.module.getElementName();
        }
    }
}

