/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.util;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void log(Throwable t, String message) {
        DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10001, message, t));
    }

    public static void handle(CoreException e, String title, String message) {
        ExceptionHandler.handle(e, DLTKUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, String title, String message) {
        ExceptionHandler.handle(e, DLTKUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        if (!DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("resourceShowError_InvalidResourceName") && this.isInvalidResouceName(e)) {
            return;
        }
        DLTKUIPlugin.log(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    private boolean isInvalidResouceName(CoreException e) {
        IStatus status = e.getStatus();
        if (status == null) {
            return false;
        }
        if (!"org.eclipse.core.resources".equals(status.getPlugin())) {
            return false;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (!"org.eclipse.core.resources".equals(status.getPlugin()) || child.getCode() != 278) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return status.getCode() == 278;
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            DLTKUIPlugin.log(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(DLTKUIMessages.ExceptionDialog_seeErrorLogMessage);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

