/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestSupport {
    private static final boolean DEBUG = false;
    private static final Class[] NO_PARAMS = new Class[0];
    private static final ThreadLocal notYetImplementedFlag = new ThreadLocal();

    public static boolean notYetImplemented(TestCase caller) {
        if (notYetImplementedFlag.get() != null) {
            return false;
        }
        notYetImplementedFlag.set(Boolean.TRUE);
        Method testMethod = TestSupport.findRunningJUnitTestMethod(caller.getClass());
        try {
            try {
                TestSupport.log("Running " + testMethod.getName() + " as not yet implemented");
                testMethod.invoke((Object)caller, null);
                Assert.fail((String)(String.valueOf(testMethod.getName()) + " is marked as not yet implemented but passes unexpectedly"));
            }
            catch (Exception exception) {
                TestSupport.log(String.valueOf(testMethod.getName()) + " fails which is expected as it is not yet implemented");
                notYetImplementedFlag.set(null);
            }
        }
        finally {
            notYetImplementedFlag.set(null);
        }
        return true;
    }

    private static void log(String message) {
    }

    private static Method findRunningJUnitTestMethod(Class caller) {
        Exception t = new Exception();
        int i = t.getStackTrace().length - 1;
        while (i >= 0) {
            StackTraceElement element = t.getStackTrace()[i];
            if (element.getClassName().equals(caller.getName())) {
                try {
                    Method m = caller.getMethod(element.getMethodName(), NO_PARAMS);
                    if (TestSupport.isPublicTestMethod(m)) {
                        return m;
                    }
                }
                catch (Exception exception) {}
            }
            --i;
        }
        throw new RuntimeException("No JUnit test case method found in call stack");
    }

    private static boolean isPublicTestMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getName().startsWith("test") && method.getReturnType().equals(Void.TYPE) && Modifier.isPublic(method.getModifiers());
    }
}

