/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.VaribleDeclarationReference;
import org.eclipse.dltk.javascript.internal.core.codeassist.AssitUtils;

public class JavaScriptSelectionEngine
extends ScriptSelectionEngine {
    IModuleSource cu;

    public IModelElement[] select(IModuleSource cu, int offset, int i) {
        String content = cu.getSourceContents();
        String fileName = cu.getFileName();
        this.cu = cu;
        int index = content.indexOf(10, offset);
        if (index == -1) {
            index = content.length();
        }
        ReferenceResolverContext rc = AssitUtils.buildContext((ISourceModule)cu, index, content, fileName);
        AssitUtils.PositionCalculator calc = new AssitUtils.PositionCalculator(content, offset, true);
        ArrayList result = new ArrayList();
        String selection = calc.getCompletion();
        if (calc.isMember()) {
            this.processMember(rc, calc, result, selection);
        } else {
            this.processGlobals(rc, result, selection);
        }
        String completionPart = calc.getCompletionPart();
        int j = result.size();
        while (--j >= 0) {
            IModelElement element = (IModelElement)result.get(j);
            if (element.getElementName().equals(completionPart)) {
                if (!(element instanceof IField) || !(element instanceof FakeField)) continue;
                ((FakeField)element).setSnippet(selection);
                continue;
            }
            result.remove(j);
        }
        IModelElement[] resultA = new IModelElement[result.size()];
        result.toArray(resultA);
        return resultA;
    }

    private void processGlobals(ReferenceResolverContext rc, List result, String selection) {
        if (selection.length() != 0) {
            Set resolveGlobals = rc.resolveGlobals(selection);
            for (Object next : resolveGlobals) {
                if (next instanceof IReference) {
                    IReference r = (IReference)next;
                    if (!r.getName().equals(selection)) continue;
                    r.addModelElements(result);
                    continue;
                }
                if (!(next instanceof IModelElement) || !((IModelElement)next).getElementName().equals(selection)) continue;
                result.add(next);
            }
            if (result.size() == 0) {
                HostCollection hostCollection = rc.getHostCollection();
                IReference rm = hostCollection.getReference(selection);
                if (rm != null) {
                    rm.addModelElements(result);
                }
                if (result.size() == 0) {
                    this.doCompletionOnFunction(selection, result);
                    this.doCompletionOnGlobalVariable(selection, result);
                }
            }
        }
    }

    private void processMember(ReferenceResolverContext buildContext, AssitUtils.PositionCalculator calc, final List result, String selection) {
        Set resolveGlobals = buildContext.resolveGlobals(selection);
        for (IReference r : resolveGlobals) {
            r.addModelElements(result);
        }
        if (result.size() == 0) {
            IReference rm = buildContext.getHostCollection().queryElement(selection, true);
            if (rm != null) {
                rm.addModelElements(result);
            }
            if (result.size() == 0) {
                SearchRequestor requestor = new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        VaribleDeclarationReference vm;
                        IReference reference;
                        FieldReferenceMatch mr = (FieldReferenceMatch)match;
                        ASTNode nm = mr.getNode();
                        if (nm instanceof VaribleDeclarationReference && (reference = (vm = (VaribleDeclarationReference)nm).getReference()) != null) {
                            reference.addModelElements(result);
                        }
                    }
                };
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
                IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
                try {
                    this.search(selection, 2, 0, scope, requestor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void doCompletionOnFunction(final String startPart, final List modelElements) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMethod mn;
                Object element = match.getElement();
                if (element instanceof IMethod && (mn = (IMethod)element).getElementName().equals(startPart)) {
                    if (!modelElements.isEmpty()) {
                        return;
                    }
                    modelElements.add(element);
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        try {
            this.search(startPart, 1, 0, scope, requestor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void doCompletionOnGlobalVariable(String startPart, final List methods) {
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IField) {
                    methods.add(element);
                }
                if (match instanceof FieldReferenceMatch) {
                    FieldReferenceMatch cfr_ignored_0 = (FieldReferenceMatch)match;
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        try {
            this.search(String.valueOf(startPart) + "*", 2, 0, scope, requestor);
            this.search(String.valueOf(startPart) + "*", 2, 1, scope, requestor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, 8, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        SearchPattern pattern;
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        if ((pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit())) == null) {
            pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        }
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }
}

