/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.documentation;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.documentation.DocumentationUtils;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDocumentationAccess {
    private static final String DOCUMENTATION_PROVIDERS_EXTENSION_POINT = "org.eclipse.dltk.ui.scriptDocumentationProviders";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NATURE = "nature";
    private static IScriptDocumentationProvider[] documentationProviders = null;
    private static Map<IScriptDocumentationProvider, String> providerNatures = new HashMap<IScriptDocumentationProvider, String>();
    private static final int BUFF_SIZE = 2048;

    private ScriptDocumentationAccess() {
    }

    private static IScriptDocumentationProvider[] createProviders(IConfigurationElement[] elements) {
        ArrayList<IScriptDocumentationProvider> result = new ArrayList<IScriptDocumentationProvider>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                IScriptDocumentationProvider pr = (IScriptDocumentationProvider)element.createExecutableExtension(ATTR_CLASS);
                result.add(pr);
                providerNatures.put(pr, element.getAttribute(ATTR_NATURE));
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
            ++i;
        }
        return result.toArray(new IScriptDocumentationProvider[result.size()]);
    }

    private static IScriptDocumentationProvider[] getContributedProviders() {
        if (documentationProviders == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(DOCUMENTATION_PROVIDERS_EXTENSION_POINT);
            providerNatures.clear();
            documentationProviders = ScriptDocumentationAccess.createProviders(elements);
        }
        return documentationProviders;
    }

    private static List<IScriptDocumentationProvider> getProviders(String nature) {
        IScriptDocumentationProvider[] providers;
        ArrayList<IScriptDocumentationProvider> result = new ArrayList<IScriptDocumentationProvider>();
        IScriptDocumentationProvider[] iScriptDocumentationProviderArray = providers = ScriptDocumentationAccess.getContributedProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptDocumentationProvider p = iScriptDocumentationProviderArray[n2];
            String pNature = providerNatures.get(p);
            if (pNature != null && pNature.equals(nature)) {
                result.add(p);
            }
            ++n2;
        }
        return result;
    }

    private static Reader merge(String nature, Operation operation) {
        StringBuilder buffer = new StringBuilder();
        char[] buff = null;
        for (IScriptDocumentationProvider p : ScriptDocumentationAccess.getProviders(nature)) {
            Reader reader = operation.getInfo(p);
            if (reader == null) continue;
            if (buffer.length() != 0) {
                buffer.append("<hr/>");
            }
            if (buff == null) {
                buff = new char[2048];
            }
            try {
                int len;
                while ((len = reader.read(buff, 0, 2048)) != -1) {
                    buffer.append(buff, 0, len);
                }
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (buffer.length() > 0) {
            char[] cnt = new char[buffer.length()];
            buffer.getChars(0, buffer.length(), cnt, 0);
            return new CharArrayReader(cnt);
        }
        return null;
    }

    public static Reader getHTMLContentReader(String nature, final IMember member, final boolean allowInherited, final boolean allowExternal) throws ModelException {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                return provider.getInfo(member, allowInherited, allowExternal);
            }
        });
    }

    @Deprecated
    public static Reader getHTMLContentReader(String nature, final String content) throws ModelException {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                return provider.getInfo(content);
            }
        });
    }

    public static Reader getKeywordDocumentation(String nature, final IModelElement context, final String keyword) throws ModelException {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                if (provider instanceof IScriptDocumentationProviderExtension) {
                    IScriptDocumentationProviderExtension ext = (IScriptDocumentationProviderExtension)((Object)provider);
                    IDocumentationResponse response = ext.describeKeyword(keyword, context);
                    return DocumentationUtils.getReader(response);
                }
                return provider.getInfo(keyword);
            }
        });
    }

    private static interface Operation {
        public Reader getInfo(IScriptDocumentationProvider var1);
    }
}

