/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ProjectRefreshOperation;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.tcl.internal.structure.TclSourceElementParser2;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclCheckContentExcludeInputDialog;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclPreferencesMessages;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TclCorePreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    private static int IDX_ADD = 0;
    private static int IDX_EDIT = 1;
    private static int IDX_REMOVE = 2;

    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new TclCorePreferenceBlock(newStatusChangedListener, project, container);
    }

    protected String getHelpId() {
        return null;
    }

    protected String getProjectHelpId() {
        return null;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected void setDescription() {
    }

    protected void setPreferenceStore() {
    }

    protected String getPreferencePageId() {
        return null;
    }

    protected String getPropertyPageId() {
        return null;
    }

    protected static class TclCorePreferenceBlock
    extends AbstractOptionsBlock {
        private static final PreferenceKey[] KEYS = new PreferenceKey[]{new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.empty_extension.local"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.empty_extension.remote"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.any_extension.local"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.any_extension.remote"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.excludes"), new PreferenceKey("org.eclipse.dltk.tcl.core", "org.eclipse.dltk.core.filename.associations"), new PreferenceKey("org.eclipse.dltk.tcl.core", TclSourceElementParser2.class.getName())};
        private final TclCheckContentAdapter excludeAdapter = new TclCheckContentAdapter(KEYS[4], ';');
        private ListDialogField excludeDialog;
        private final TclCheckContentAdapter includeAdapter = new TclCheckContentAdapter(KEYS[5], ';');
        private ListDialogField includeDialog;

        protected void initialize() {
            super.initialize();
            this.includeAdapter.loadPatterns(this.includeDialog);
            this.excludeAdapter.loadPatterns(this.excludeDialog);
        }

        public void performDefaults() {
            super.performDefaults();
            this.includeAdapter.loadPatterns(this.includeDialog);
            this.excludeAdapter.loadPatterns(this.excludeDialog);
        }

        protected boolean saveValues() {
            boolean value = super.saveValues();
            new Job(TclPreferencesMessages.TclCorePreferencePage_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects("org.eclipse.dltk.tcl.core.nature");
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new ProjectRefreshOperation(projects), monitor);
                    }
                    catch (CoreException e) {
                        DLTKCore.error((String)TclPreferencesMessages.TclCorePreferencePage_1, (Throwable)e);
                    }
                    TclSourceElementParser2.refreshOptions();
                    return Status.OK_STATUS;
                }
            }.schedule(500L);
            return value;
        }

        public TclCorePreferenceBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
            super(context, project, KEYS, container);
        }

        protected void validateValuePresenceFor(PreferenceKey key) {
            if (key.belongsTo("org.eclipse.dltk.tcl.core") && ("org.eclipse.dltk.core.filename.associations".equals(key.getName()) || TclSourceElementParser2.class.getName().equals(key.getName()))) {
                return;
            }
            super.validateValuePresenceFor(key);
        }

        private Button createCheckbox(Composite block, String label, PreferenceKey key) {
            Button checkButton = SWTFactory.createCheckButton((Composite)block, (String)label);
            GridData data = new GridData();
            data.horizontalIndent = 16;
            checkButton.setLayoutData((Object)data);
            this.bindControl(checkButton, key, null);
            return checkButton;
        }

        protected Control createOptionsBlock(Composite parent) {
            Composite block = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
            SWTFactory.createLabel((Composite)block, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentWithoutExtension, (int)1);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_local, KEYS[0]);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_remote, KEYS[1]);
            SWTFactory.createLabel((Composite)block, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentAnyExtension, (int)1);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_local, KEYS[2]);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_remote, KEYS[3]);
            Composite patternComposite = SWTFactory.createComposite((Composite)block, (Font)block.getFont(), (int)1, (int)1, (int)1808);
            GridLayout patternLayout = new GridLayout();
            patternLayout.numColumns = 2;
            patternLayout.marginHeight = 0;
            patternLayout.marginWidth = 0;
            patternComposite.setLayout((Layout)patternLayout);
            String[] buttons = new String[]{TclPreferencesMessages.TclCorePreferencePage_checkContentAddExclude, TclPreferencesMessages.TclCorePreferencePage_checkContentEditExclude, TclPreferencesMessages.TclCorePreferencePage_checkContentRemoveExclude};
            SWTFactory.createLabel((Composite)patternComposite, (String)TclPreferencesMessages.TclCorePreferencePage_Associations, (int)2);
            Set associations = DLTKLanguageManager.loadFilenameAssociations((String)"org.eclipse.dltk.tcl.core.nature");
            this.includeAdapter.setContributedElements(associations);
            this.includeDialog = new ListDialogField(this.includeAdapter, buttons, (ILabelProvider)new AssociationLabelProvider(associations)){

                protected boolean canRemove(ISelection selection) {
                    if (selection instanceof IStructuredSelection) {
                        if (TclCorePreferenceBlock.this.includeAdapter.contributedElements != null) {
                            for (Object element : (IStructuredSelection)selection) {
                                if (!TclCorePreferenceBlock.this.includeAdapter.contributedElements.contains(element)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.includeDialog.setDialogFieldListener((IDialogFieldListener)this.includeAdapter);
            this.includeDialog.setRemoveButtonIndex(IDX_REMOVE);
            this.includeDialog.setViewerSorter((ViewerSorter)new AssociationViwerSorter(associations));
            Control listControl = this.includeDialog.getListControl(patternComposite);
            GridData listControlLayoutData = new GridData(1808);
            listControlLayoutData.heightHint = new PixelConverter(listControl).convertHeightInCharsToPixels(6);
            listControl.setLayoutData((Object)listControlLayoutData);
            this.includeDialog.getButtonBox(patternComposite).setLayoutData((Object)new GridData(258));
            SWTFactory.createLabel((Composite)patternComposite, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentExcludes, (int)2);
            this.excludeDialog = new ListDialogField((IListAdapter)this.excludeAdapter, buttons, (ILabelProvider)new LabelProvider());
            this.excludeDialog.setDialogFieldListener((IDialogFieldListener)this.excludeAdapter);
            this.excludeDialog.setRemoveButtonIndex(IDX_REMOVE);
            this.excludeDialog.setViewerSorter(new ViewerSorter());
            Control listControl2 = this.excludeDialog.getListControl(patternComposite);
            GridData listControlLayoutData2 = new GridData(1808);
            listControlLayoutData2.heightHint = new PixelConverter(listControl2).convertHeightInCharsToPixels(6);
            listControl2.setLayoutData((Object)listControlLayoutData2);
            this.excludeDialog.getButtonBox(patternComposite).setLayoutData((Object)new GridData(258));
            return block;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AssociationLabelProvider
        extends LabelProvider
        implements IFontProvider {
            private final Set<String> highlighted;

            public AssociationLabelProvider(Set<String> highlighted) {
                this.highlighted = highlighted;
            }

            public Font getFont(Object element) {
                if (this.highlighted.contains(element)) {
                    return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AssociationViwerSorter
        extends ViewerSorter {
            private final Set<String> highlighted;

            public AssociationViwerSorter(Set<String> highlighted) {
                this.highlighted = highlighted;
            }

            public int category(Object element) {
                return this.highlighted.contains(element) ? 0 : 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TclCheckContentAdapter
        implements IListAdapter,
        IDialogFieldListener {
            private Set<String> contributedElements = null;
            private final PreferenceKey listKey;
            private final char itemSeparator;

            public TclCheckContentAdapter(PreferenceKey listKey, char listSeparator) {
                this.listKey = listKey;
                this.itemSeparator = listSeparator;
            }

            public void customButtonPressed(ListDialogField field, int index) {
                TclCheckContentExcludeInputDialog dialog;
                String edited = null;
                if (index != IDX_ADD) {
                    edited = (String)field.getSelectedElements().get(0);
                }
                if ((index == IDX_ADD || index == IDX_EDIT) && (dialog = new TclCheckContentExcludeInputDialog(TclCorePreferenceBlock.this.getShell(), edited, field.getElements())).open() == 0) {
                    if (edited != null) {
                        field.replaceElement((Object)edited, (Object)dialog.getResult());
                    } else {
                        field.addElement((Object)dialog.getResult());
                    }
                }
            }

            private boolean canEdit(List<?> selectedElements) {
                return selectedElements.size() == 1 && (this.contributedElements == null || !this.contributedElements.containsAll(selectedElements));
            }

            public void doubleClicked(ListDialogField field) {
                if (this.canEdit(field.getSelectedElements())) {
                    this.customButtonPressed(field, IDX_EDIT);
                }
            }

            public void selectionChanged(ListDialogField field) {
                List selectedElements = field.getSelectedElements();
                field.enableButton(IDX_EDIT, this.canEdit(selectedElements));
            }

            public void dialogFieldChanged(DialogField field) {
                this.savePatterns((ListDialogField)field);
            }

            public void loadPatterns(ListDialogField field) {
                String[] patterns;
                ArrayList<String> elements = new ArrayList<String>();
                if (this.contributedElements != null) {
                    elements.addAll(this.contributedElements);
                }
                if ((patterns = TextUtils.split((String)TclCorePreferenceBlock.this.getString(this.listKey), (char)this.itemSeparator)) != null) {
                    elements.addAll((Collection)Arrays.asList(patterns));
                }
                field.setElements(elements);
                this.selectionChanged(field);
            }

            private void savePatterns(ListDialogField field) {
                List elements = field.getElements();
                if (this.contributedElements != null) {
                    elements.removeAll(this.contributedElements);
                }
                TclCorePreferenceBlock.this.setString(this.listKey, TextUtils.join((Collection)elements, (char)this.itemSeparator));
            }

            public void setContributedElements(Set<String> value) {
                this.contributedElements = value;
            }
        }
    }
}

