/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.io.StringReader;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.SourceParserManager;
import org.eclipse.dltk.ast.utils.ASTUtil;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.internal.ui.text.Token;
import org.eclipse.dltk.javascript.internal.ui.text.XMLTokenizer;
import org.eclipse.dltk.ui.editor.highlighting.AbstractSemanticHighlighter;

final class JavaScriptPositionUpdater
extends AbstractSemanticHighlighter {
    private static final int HL_XML_TAG = 0;
    private static final int HL_XML_ATTRIBUTE = 1;
    private static final int HL_XML_COMMENT = 2;
    private static final int HL_KEYWORD = 3;

    JavaScriptPositionUpdater() {
    }

    protected boolean doHighlighting(IModuleSource code) throws Exception {
        ISourceParser parser = SourceParserManager.getInstance().getSourceParserById("org.eclipse.dltk.javascript.NewParser");
        if (parser == null) {
            return false;
        }
        Script declaration = (Script)parser.parse(code, null);
        if (declaration == null) {
            return false;
        }
        for (XmlLiteral literal : ASTUtil.select((ASTNode)declaration, XmlLiteral.class)) {
            for (XmlFragment fragment : literal.getFragments()) {
                if (!(fragment instanceof XmlTextFragment)) continue;
                XMLTokenizer tokenizer = new XMLTokenizer(new StringReader(((XmlTextFragment)fragment).getXml()));
                int offset = fragment.sourceStart();
                List tokens = tokenizer.getRegions();
                for (Token token : tokens) {
                    if (token.context == "5") {
                        this.addRange(offset, token, 0);
                        continue;
                    }
                    if (token.context == "28") {
                        this.addRange(offset, token, 1);
                        continue;
                    }
                    if (token.context == "16" || token.context == "8" || token.context == "17") {
                        this.addRange(offset, token, 2);
                        continue;
                    }
                    String cfr_ignored_0 = token.context;
                }
            }
        }
        for (Method method : ASTUtil.select((ASTNode)declaration, Method.class)) {
            Keyword keyword;
            if (method instanceof GetMethod) {
                keyword = ((GetMethod)method).getGetKeyword();
            } else {
                if (!(method instanceof SetMethod)) continue;
                keyword = ((SetMethod)method).getSetKeyword();
            }
            this.addPosition(keyword.sourceStart(), keyword.sourceEnd(), 3);
        }
        return true;
    }

    private void addRange(int start, Token token, int highlightingIndex) {
        this.addPosition(start + token.start, start + token.start + token.textLength, highlightingIndex);
    }
}

