/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.BaseFunction;
import com.xored.org.mozilla.javascript.BeanProperty;
import com.xored.org.mozilla.javascript.ClassCache;
import com.xored.org.mozilla.javascript.Context;
import com.xored.org.mozilla.javascript.FieldAndMethods;
import com.xored.org.mozilla.javascript.Kit;
import com.xored.org.mozilla.javascript.MemberBox;
import com.xored.org.mozilla.javascript.NativeJavaConstructor;
import com.xored.org.mozilla.javascript.NativeJavaMethod;
import com.xored.org.mozilla.javascript.ObjArray;
import com.xored.org.mozilla.javascript.ScriptRuntime;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.ScriptableObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class JavaMembers {
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    MemberBox[] ctors;

    public JavaMembers(Scriptable scope, Class cl) {
        this(scope, cl, false);
    }

    public JavaMembers(Scriptable scope, Class cl, boolean includeProtected) {
        this.cl = cl;
        this.reflect(scope, includeProtected);
    }

    boolean has(String name, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        return this.findExplicitFunction(name, isStatic) != null;
    }

    Object get(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Class<?> type;
        Object rval;
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (member instanceof Scriptable) {
            return member;
        }
        Context cx = Context.getContext();
        try {
            if (member instanceof BeanProperty) {
                BeanProperty bp = (BeanProperty)member;
                if (bp.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                rval = bp.getter.invoke(javaObject, Context.emptyArgs);
                type = bp.getter.method().getReturnType();
            } else {
                Field field = (Field)member;
                rval = field.get(isStatic ? null : javaObject);
                type = field.getType();
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrap(cx, scope, rval, type);
    }

    void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.field;
        }
        if (member instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)member;
            if (bp.setter == null) {
                throw this.reportMemberNotFound(name);
            }
            if (bp.setters == null || value == null) {
                Class setType = bp.setter.argTypes[0];
                Object[] args = new Object[]{Context.jsToJava(value, setType)};
                try {
                    bp.setter.invoke(javaObject, args);
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
            } else {
                Object[] args = new Object[]{value};
                bp.setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scope), scope, args);
            }
        } else {
            if (!(member instanceof Field)) {
                String str = member == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1(str, name);
            }
            Field field = (Field)member;
            Object javaValue = Context.jsToJava(value, field.getType());
            try {
                field.set(javaObject, javaValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName());
            }
        }
    }

    public Object[] getIds(boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        int len = ht.size();
        Object[] result = new Object[len];
        Enumeration keys = ht.keys();
        int i = 0;
        while (i < len) {
            result[i] = keys.nextElement();
            ++i;
        }
        return result;
    }

    static String javaSignature(Class type) {
        if (!type.isArray()) {
            return type.getName();
        }
        int arrayDimension = 0;
        do {
            ++arrayDimension;
        } while ((type = type.getComponentType()).isArray());
        String name = type.getName();
        String suffix = "[]";
        if (arrayDimension == 1) {
            return name.concat(suffix);
        }
        int length = name.length() + arrayDimension * suffix.length();
        StringBuffer sb = new StringBuffer(length);
        sb.append(name);
        while (arrayDimension != 0) {
            --arrayDimension;
            sb.append(suffix);
        }
        return sb.toString();
    }

    static String liveConnectSignature(Class[] argTypes) {
        int N = argTypes.length;
        if (N == 0) {
            return "()";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int i = 0;
        while (i != N) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(JavaMembers.javaSignature(argTypes[i]));
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private MemberBox findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        int sigStart = name.indexOf(40);
        if (sigStart < 0) {
            return null;
        }
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        MemberBox[] methodsOrCtors = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors;
        } else {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj instanceof NativeJavaMethod) {
                NativeJavaMethod njm = (NativeJavaMethod)obj;
                methodsOrCtors = njm.methods;
            }
        }
        if (methodsOrCtors != null) {
            int i = 0;
            while (i < methodsOrCtors.length) {
                Class[] type = methodsOrCtors[i].argTypes;
                String sig = JavaMembers.liveConnectSignature(type);
                if (sigStart + sig.length() == name.length() && name.regionMatches(sigStart, sig, 0, sig.length())) {
                    return methodsOrCtors[i];
                }
                ++i;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        BaseFunction member = null;
        MemberBox methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope);
            if (methodOrCtor.isCtor()) {
                NativeJavaConstructor fun = new NativeJavaConstructor(methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = (BaseFunction)ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).methods.length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod(methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    private static Method[] discoverAccessibleMethods(Class clazz, boolean includeProtected) {
        HashMap map = new HashMap();
        JavaMembers.discoverAccessibleMethods(clazz, map, includeProtected);
        return map.values().toArray(new Method[map.size()]);
    }

    private static void discoverAccessibleMethods(Class clazz, Map map, boolean includeProtected) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                if (includeProtected) {
                    while (clazz != null) {
                        Method[] methods = clazz.getDeclaredMethods();
                        int i = 0;
                        while (i < methods.length) {
                            Method method = methods[i];
                            int mods = method.getModifiers();
                            if (Modifier.isPublic(mods) || Modifier.isProtected(mods)) {
                                MethodSignature sig = new MethodSignature(method);
                                map.put(sig, method);
                            }
                            ++i;
                        }
                        clazz = clazz.getSuperclass();
                    }
                } else {
                    Method[] methods = clazz.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        Method method = methods[i];
                        MethodSignature sig = new MethodSignature(method);
                        map.put(sig, method);
                        ++i;
                    }
                }
                return;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, " + "attemping superclasses/interfaces.");
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            JavaMembers.discoverAccessibleMethods(interfaces[i], map, includeProtected);
            ++i;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            JavaMembers.discoverAccessibleMethods(superclass, map, includeProtected);
        }
    }

    private void reflect(Scriptable scope, boolean includeProtected) {
        String name;
        ObjArray overloadedMethods;
        Object value;
        Method[] methods = JavaMembers.discoverAccessibleMethods(this.cl, includeProtected);
        int i = 0;
        while (i < methods.length) {
            String name2;
            Method method = methods[i];
            int mods = method.getModifiers();
            boolean isStatic = Modifier.isStatic(mods);
            Hashtable ht = isStatic ? this.staticMembers : this.members;
            value = ht.get(name2 = method.getName());
            if (value == null) {
                ht.put(name2, method);
            } else {
                if (value instanceof ObjArray) {
                    overloadedMethods = (ObjArray)value;
                } else {
                    if (!(value instanceof Method)) {
                        Kit.codeBug();
                    }
                    overloadedMethods = new ObjArray();
                    overloadedMethods.add(value);
                    ht.put(name2, overloadedMethods);
                }
                overloadedMethods.add(method);
            }
            ++i;
        }
        int tableCursor = 0;
        while (tableCursor != 2) {
            boolean isStatic = tableCursor == 0;
            Hashtable ht = isStatic ? this.staticMembers : this.members;
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                MemberBox[] methodBoxes;
                String name3 = (String)e.nextElement();
                value = ht.get(name3);
                if (value instanceof Method) {
                    methodBoxes = new MemberBox[]{new MemberBox((Method)value)};
                } else {
                    overloadedMethods = (ObjArray)value;
                    int N = overloadedMethods.size();
                    if (N < 2) {
                        Kit.codeBug();
                    }
                    methodBoxes = new MemberBox[N];
                    int i2 = 0;
                    while (i2 != N) {
                        Method method = (Method)overloadedMethods.get(i2);
                        methodBoxes[i2] = new MemberBox(method);
                        ++i2;
                    }
                }
                NativeJavaMethod fun = new NativeJavaMethod(methodBoxes);
                if (scope != null) {
                    ScriptRuntime.setFunctionProtoAndParent(fun, scope);
                }
                ht.put(name3, fun);
            }
            ++tableCursor;
        }
        Field[] fields = this.cl.getFields();
        int i3 = 0;
        while (i3 < fields.length) {
            Field field = fields[i3];
            int mods = field.getModifiers();
            if (Modifier.isPublic(mods)) {
                boolean isStatic = Modifier.isStatic(mods);
                Hashtable ht = isStatic ? this.staticMembers : this.members;
                Object member = ht.get(name = field.getName());
                if (member == null) {
                    ht.put(name, field);
                } else if (member instanceof NativeJavaMethod) {
                    Hashtable<String, FieldAndMethods> fmht;
                    NativeJavaMethod method = (NativeJavaMethod)member;
                    FieldAndMethods fam = new FieldAndMethods(scope, method.methods, field);
                    Hashtable<String, FieldAndMethods> hashtable = fmht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (fmht == null) {
                        fmht = new Hashtable<String, FieldAndMethods>(4);
                        if (isStatic) {
                            this.staticFieldAndMethods = fmht;
                        } else {
                            this.fieldAndMethods = fmht;
                        }
                    }
                    fmht.put(name, fam);
                    ht.put(name, fam);
                } else if (member instanceof Field) {
                    Field oldField = (Field)member;
                    if (oldField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                        ht.put(name, field);
                    }
                } else {
                    Kit.codeBug();
                }
            }
            ++i3;
        }
        int tableCursor2 = 0;
        while (tableCursor2 != 2) {
            boolean isStatic = tableCursor2 == 0;
            Hashtable ht = isStatic ? this.staticMembers : this.members;
            Hashtable<String, BeanProperty> toAdd = new Hashtable<String, BeanProperty>();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                Object member;
                String nameComponent;
                name = (String)e.nextElement();
                boolean memberIsGetMethod = name.startsWith("get");
                boolean memberIsSetMethod = name.startsWith("set");
                boolean memberIsIsMethod = name.startsWith("is");
                if (!memberIsGetMethod && !memberIsIsMethod && !memberIsSetMethod || (nameComponent = name.substring(memberIsIsMethod ? 2 : 3)).length() == 0) continue;
                String beanPropertyName = nameComponent;
                char ch0 = nameComponent.charAt(0);
                if (Character.isUpperCase(ch0)) {
                    if (nameComponent.length() == 1) {
                        beanPropertyName = nameComponent.toLowerCase();
                    } else {
                        char ch1 = nameComponent.charAt(1);
                        if (!Character.isUpperCase(ch1)) {
                            beanPropertyName = String.valueOf(Character.toLowerCase(ch0)) + nameComponent.substring(1);
                        }
                    }
                }
                if (ht.containsKey(beanPropertyName) || toAdd.containsKey(beanPropertyName)) continue;
                MemberBox getter = null;
                getter = this.findGetter(isStatic, ht, "get", nameComponent);
                if (getter == null) {
                    getter = this.findGetter(isStatic, ht, "is", nameComponent);
                }
                MemberBox setter = null;
                NativeJavaMethod setters = null;
                String setterName = "set".concat(nameComponent);
                if (ht.containsKey(setterName) && (member = ht.get(setterName)) instanceof NativeJavaMethod) {
                    NativeJavaMethod njmSet = (NativeJavaMethod)member;
                    if (getter != null) {
                        Class<?> type = getter.method().getReturnType();
                        setter = JavaMembers.extractSetMethod(type, njmSet.methods, isStatic);
                    } else {
                        setter = JavaMembers.extractSetMethod(njmSet.methods, isStatic);
                    }
                    if (njmSet.methods.length > 1) {
                        setters = njmSet;
                    }
                }
                BeanProperty bp = new BeanProperty(getter, setter, setters);
                toAdd.put(beanPropertyName, bp);
            }
            e = toAdd.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value2 = toAdd.get(key);
                ht.put(key, value2);
            }
            ++tableCursor2;
        }
        Constructor<?>[] constructors = this.cl.getConstructors();
        this.ctors = new MemberBox[constructors.length];
        int i4 = 0;
        while (i4 != constructors.length) {
            this.ctors[i4] = new MemberBox(constructors[i4]);
            ++i4;
        }
    }

    private MemberBox findGetter(boolean isStatic, Hashtable ht, String prefix, String propertyName) {
        Object member;
        String getterName = prefix.concat(propertyName);
        if (ht.containsKey(getterName) && (member = ht.get(getterName)) instanceof NativeJavaMethod) {
            NativeJavaMethod njmGet = (NativeJavaMethod)member;
            return JavaMembers.extractGetMethod(njmGet.methods, isStatic);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] methods, boolean isStatic) {
        int methodIdx = 0;
        while (methodIdx < methods.length) {
            MemberBox method = methods[methodIdx];
            if (method.argTypes.length == 0 && (!isStatic || method.isStatic())) {
                Class<?> type = method.method().getReturnType();
                if (type == Void.TYPE) break;
                return method;
            }
            ++methodIdx;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class type, MemberBox[] methods, boolean isStatic) {
        int pass = 1;
        while (pass <= 2) {
            int i = 0;
            while (i < methods.length) {
                Class[] params;
                MemberBox method = methods[i];
                if ((!isStatic || method.isStatic()) && method.method().getReturnType() == Void.TYPE && (params = method.argTypes).length == 1) {
                    if (pass == 1) {
                        if (params[0] == type) {
                            return method;
                        }
                    } else {
                        if (pass != 2) {
                            Kit.codeBug();
                        }
                        if (params[0].isAssignableFrom(type)) {
                            return method;
                        }
                    }
                }
                ++i;
            }
            ++pass;
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] methods, boolean isStatic) {
        int i = 0;
        while (i < methods.length) {
            MemberBox method = methods[i];
            if ((!isStatic || method.isStatic()) && method.method().getReturnType() == Void.TYPE && method.argTypes.length == 1) {
                return method;
            }
            ++i;
        }
        return null;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic) {
        Hashtable ht;
        Hashtable hashtable = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        Hashtable<String, FieldAndMethods> result = new Hashtable<String, FieldAndMethods>(len);
        Enumeration e = ht.elements();
        while (len-- > 0) {
            FieldAndMethods fam = (FieldAndMethods)e.nextElement();
            FieldAndMethods famNew = new FieldAndMethods(scope, fam.methods, fam.field);
            famNew.javaObject = javaObject;
            result.put(fam.field.getName(), famNew);
        }
        return result;
    }

    public Hashtable getFieldAndMethods(boolean isStatic) {
        return isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
    }

    public Hashtable getMembers(boolean isStatic) {
        return isStatic ? this.staticMembers : this.members;
    }

    static JavaMembers lookupClass(Scriptable scope, Class dynamicType, Class staticType, boolean includeProtected) {
        JavaMembers members;
        ClassCache cache = ClassCache.get(scope);
        Hashtable ct = cache.classTable;
        Class cl = dynamicType;
        while (true) {
            if ((members = (JavaMembers)ct.get(cl)) != null) {
                return members;
            }
            try {
                members = new JavaMembers(cache.scope, cl, includeProtected);
            }
            catch (SecurityException e) {
                if (staticType != null && staticType.isInterface()) {
                    cl = staticType;
                    staticType = null;
                    continue;
                }
                Class parent = cl.getSuperclass();
                if (parent == null) {
                    if (cl.isInterface()) {
                        parent = ScriptRuntime.ObjectClass;
                    } else {
                        throw e;
                    }
                }
                cl = parent;
                continue;
            }
            break;
        }
        if (cache.isCachingEnabled()) {
            ct.put(cl, members);
        }
        return members;
    }

    RuntimeException reportMemberNotFound(String memberName) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), memberName);
    }

    private static final class MethodSignature {
        private final String name;
        private final Class[] args;

        private MethodSignature(String name, Class[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

