/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.InvalidInputException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptPartitionScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.dltk.javascript.scriptdoc.IScanner;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.javascript.scriptdoc.JavaIndenter;
import org.eclipse.dltk.javascript.scriptdoc.PublicScanner;
import org.eclipse.dltk.javascript.ui.text.IJavaScriptPartitions;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavascriptAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;
    final IScriptProject fProject;
    private static IScanner fgScanner = new PublicScanner(false, false, false, 3L, null, null, false);
    JsPreferenceInterpreter prefs;

    public JavascriptAutoEditStrategy(String partitioning, IScriptProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
        this.prefs = new JsPreferenceInterpreter(JavaScriptUI.getDefault().getPreferenceStore());
    }

    private int getBracketCount(IDocument d, int startOffset, int endOffset, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketCount = 0;
        block7: while (startOffset < endOffset) {
            char curr = d.getChar(startOffset);
            ++startOffset;
            switch (curr) {
                case '/': {
                    if (startOffset >= endOffset) break;
                    char next = d.getChar(startOffset);
                    if (next == '*') {
                        startOffset = this.getCommentEnd(d, startOffset + 1, endOffset);
                        break;
                    }
                    if (next != '/') break;
                    startOffset = endOffset;
                    break;
                }
                case '*': {
                    char next;
                    if (startOffset >= endOffset || (next = d.getChar(startOffset)) != '/') continue block7;
                    bracketCount = 0;
                    ++startOffset;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketCount;
                    break;
                }
                case '\"': 
                case '\'': {
                    startOffset = this.getStringEnd(d, startOffset, endOffset, curr);
                }
            }
        }
        return bracketCount;
    }

    private int getCommentEnd(IDocument d, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            if (curr != '*' || ++offset >= endOffset || d.getChar(offset) != '/') continue;
            return offset + 1;
        }
        return endOffset;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
            JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, true, false, false))) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line = d.getLineOfOffset(p);
            int lineOffset = d.getLineOffset(line);
            if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine <= line) {
                JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)start, (boolean)true);
            if ("__javascript_doc".equals(region.getType()) || "__javascript_comment".equals(region.getType())) {
                IRegion prevLine = d.getLineInformation(line);
                String str = d.get(prevLine.getOffset(), prevLine.getLength());
                if (!str.trim().endsWith("*/")) {
                    String result = this.handleJsCodeCompleteStars(buf, str, prevLine, line, region, d, c);
                    buf.setLength(0);
                    buf.append(result);
                }
            } else if (this.getBracketCount(d, start, c.offset, true) > 0 && this.closeBrace() && !this.isClosed(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                if ((c.offset == 0 || JavascriptAutoEditStrategy.computeAnonymousPosition(d, c.offset - 1, this.fPartitioning, lineEnd) == -1) && lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}') {
                int firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start);
                if (firstCharPos != -1 && d.getChar(firstCharPos) == '{') {
                    c.caretOffset = c.offset + buf.length();
                    c.shiftsCaret = false;
                    StringBuffer reference = null;
                    int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                    reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                    buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                    if (reference != null) {
                        buf.append(reference);
                    }
                }
            } else {
                IRegion prevLine = d.getLineInformation(line);
                String str = d.get(prevLine.getOffset(), prevLine.getLength());
                if (!str.trim().endsWith("*/")) {
                    String result = this.handleJsCodeCompleteStars(buf, str, prevLine, line, region, d, c);
                    buf.setLength(0);
                    buf.append(result);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private String handleJsCodeCompleteStars(StringBuffer buf, String str, IRegion prevLine, int line, ITypedRegion region, IDocument d, DocumentCommand c) {
        int index = str.indexOf("/*");
        if (index != -1 && prevLine.getOffset() + index < c.offset) {
            buf.setLength(0);
            StringBuffer indentStr = new StringBuffer(index);
            int counter = 0;
            while (counter < index) {
                char ch;
                if (Character.isWhitespace(ch = str.charAt(counter++))) {
                    indentStr.append(ch);
                    continue;
                }
                indentStr.append(' ');
            }
            boolean enclosedComment = false;
            try {
                index = line + 1;
                IRegion nextLine = null;
                while ((nextLine = d.getLineInformation(index++)) != null) {
                    String strNextLine = d.get(nextLine.getOffset(), nextLine.getLength());
                    int stComment = strNextLine.indexOf("/*");
                    int endComment = strNextLine.indexOf("*/");
                    if (stComment != -1 && endComment != -1) {
                        if (stComment >= endComment) continue;
                    } else if (endComment != -1) {
                        enclosedComment = true;
                    } else if (stComment == -1) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
            buf.append("\n" + indentStr + " * ");
            c.caretOffset = c.offset + buf.length();
            c.shiftsCaret = false;
            if (!enclosedComment) {
                buf.append("\n" + indentStr + " */");
            }
        } else if (("__javascript_comment".equals(region.getType()) || "__javascript_doc".equals(region.getType())) && c.offset < region.getOffset() + region.getLength()) {
            buf = new StringBuffer();
            buf.append("\n");
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                if (!Character.isWhitespace(ch)) break;
                buf.append(ch);
                ++i;
            }
            buf.append("* ");
        }
        return buf.toString();
    }

    private boolean isClosed(IDocument d, int offset, int length) {
        int lastClosed;
        int lastOpen;
        String sm = d.get();
        int start = sm.lastIndexOf("function ", offset);
        if (start == -1) {
            start = 0;
        }
        if ((lastOpen = sm.lastIndexOf("{", start)) == -1) {
            lastOpen = 0;
        }
        if ((lastClosed = sm.lastIndexOf("}", start)) == -1) {
            lastClosed = 0;
        }
        while (lastOpen > lastClosed) {
            start = sm.lastIndexOf("function ", lastOpen);
            if ((lastOpen = sm.lastIndexOf("{", start)) == -1) {
                lastOpen = 0;
            }
            if ((lastClosed = sm.lastIndexOf("}", start)) != -1) continue;
            lastClosed = 0;
        }
        int end = sm.indexOf("function ", offset);
        if (end == -1) {
            end = sm.length();
        } else {
            lastOpen = sm.lastIndexOf("{", end);
            if (lastOpen == -1) {
                lastOpen = 0;
            }
            if ((lastClosed = sm.lastIndexOf("}", end)) == -1) {
                lastClosed = 0;
            }
            while (lastOpen > lastClosed) {
                int end2 = sm.indexOf("function ", lastOpen);
                if (end == end2) break;
                end = end2;
                lastOpen = sm.lastIndexOf("{", end);
                if (lastOpen == -1) {
                    lastOpen = 0;
                }
                if ((lastClosed = sm.lastIndexOf("}", end)) != -1) continue;
                lastClosed = 0;
            }
        }
        int level = 0;
        boolean qm = false;
        int charp = 0;
        int a = start;
        while (a < end) {
            char charAt = sm.charAt(a);
            if (!qm) {
                if (charAt == '{') {
                    ++level;
                }
                if (charAt == '}') {
                    --level;
                }
            }
            if ((charAt == '\"' || charAt == '\'') && charp != 92) {
                qm = !qm;
            }
            charp = charAt;
            ++a;
        }
        return level <= 0;
    }

    private static int computeAnonymousPosition(IDocument document, int offset, String partitioning, int max) {
        int openingParen;
        int startScan;
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int pos = offset;
        int length = max;
        int scanTo = scanner.scanForward(pos, length, '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = JavascriptAutoEditStrategy.findClosingParenToLeft(scanner, pos) - 1;
        while ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) != -1 && (openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')')) >= 1) {
            if (openingParen > pos || !JavascriptAutoEditStrategy.looksLikeAnonymousClassDef(document, partitioning, scanner, openingParen - 1)) continue;
            return closingParen + 1;
        }
        return -1;
    }

    private static int findClosingParenToLeft(JavaHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private static boolean isNewMatch(IDocument document, int offset, int length, String partitioning) {
        int pos;
        String text;
        block6: {
            block5: {
                Assert.isTrue((length >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset + length < document.getLength() + 1 ? 1 : 0) != 0);
                try {
                    text = document.get(offset, length);
                    pos = text.indexOf("new");
                    while (pos != -1 && !JavascriptAutoEditStrategy.isDefaultPartition(document, pos + offset, partitioning)) {
                        pos = text.indexOf("new", pos + 2);
                    }
                    if (pos >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (pos == 0 || !Character.isJavaIdentifierPart(text.charAt(pos - 1))) break block6;
            return false;
        }
        return pos + 3 >= length || !Character.isJavaIdentifierPart(text.charAt(pos + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument document, String partitioning, JavaHeuristicScanner scanner, int position) {
        int previousCommaParenEqual = scanner.scanBackward(position - 1, -2, new char[]{',', '(', '='});
        if (previousCommaParenEqual == -1 || position < previousCommaParenEqual + 5) {
            return false;
        }
        return JavascriptAutoEditStrategy.isNewMatch(document, previousCommaParenEqual + 1, position - previousCommaParenEqual - 2, partitioning);
    }

    private static boolean isDefaultPartition(IDocument document, int position, String partitioning) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)position, (boolean)false);
            return region.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static void installJavaStuff(Document document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JavascriptPartitionScanner(), IJavaScriptPartitions.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__javascript_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeJavaStuff(Document document) {
        document.setDocumentPartitioner("__javascript_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            JavaIndenter indenter = new JavaIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            peerOffset = indenter.findReferencePosition(peerOffset);
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            IRegion refLine = document.getLineInformationOfOffset(refOffset);
            String prefix = document.get(refLine.getOffset(), newOffset - refLine.getOffset());
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new JavaHeuristicScanner((IDocument)temp);
            indenter = new JavaIndenter((IDocument)temp, scanner, this.fProject);
            JavascriptAutoEditStrategy.installJavaStuff(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            int tabLength = this.getVisualTabLengthPreference();
            boolean changed = false;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = JavascriptAutoEditStrategy.getCurrentIndent(temp, l);
                        StringBuffer correct = indenter.computeIndentation(lineOffset);
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition, tabLength);
                        if (l != first && temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            JavascriptAutoEditStrategy.removeJavaStuff(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        this.addIndent(temp, l, addition, tabLength);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, tabLength);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private static String getCurrentIndent(Document document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(LINE_COMMENT)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && ((type = TextUtilities.getContentType((IDocument)document, (String)"__javascript_partitioning", (int)to, (boolean)true)).equals("__javascript_doc") || type.equals("__javascript_comment"))) {
            --to;
        }
        return document.get(from, to - from);
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference, int tabLength) {
        int c2;
        int c1 = this.computeVisualLength(correct, tabLength);
        int diff = c1 - (c2 = this.computeVisualLength(current, tabLength));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c, tabLength);
        }
        return diff;
    }

    private void addIndent(Document document, int line, CharSequence indent, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int newInsert = insert;
        while (newInsert < endOffset - 2 && document.get(newInsert, 2).equals(LINE_COMMENT)) {
            newInsert += 2;
        }
        if (newInsert > insert) {
            int whitespaceCount = 0;
            int i = newInsert;
            while (i < endOffset - 1) {
                char ch = document.get(i, 1).charAt(0);
                if (!Character.isWhitespace(ch)) break;
                whitespaceCount += this.computeVisualLength(ch, tabLength);
                ++i;
            }
            if (whitespaceCount != 0 && whitespaceCount >= 4) {
                insert = newInsert;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch, tabLength)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, "");
    }

    private int computeVisualLength(CharSequence seq, int tabLength) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tabLength != 0) {
                    size += tabLength - size % tabLength;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch, int tabLength) {
        if (ch == '\t') {
            return tabLength;
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return 4;
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        JavascriptAutoEditStrategy.installJavaStuff(pasted);
        int firstPeer = command.offset;
        JavaHeuristicScanner pScanner = new JavaHeuristicScanner((IDocument)pasted);
        JavaHeuristicScanner dScanner = new JavaHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block15: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = JavascriptAutoEditStrategy.skipScope(pScanner, pPos, token)) != -1) continue block15;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    JavaIndenter indenter = new JavaIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(JavaHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.startsWith((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void autoClose(IDocument d, DocumentCommand c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument d, DocumentCommand c) {
        if (c.offset < 4 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 3, 3);
            if (content.equals("els")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(d, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1024 ? this.getIndentOfLine(d, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && JavascriptAutoEditStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return DLTKUIPlugin.getDefault().getPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void clearCachedValues() {
        JavascriptAutoEditStrategy.getPreferenceStore();
        this.fCloseBrace = true;
        this.fIsSmartMode = this.computeSmartMode();
    }

    protected boolean computeSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private static CompilationUnitInfo getCompilationUnitForMethod(IDocument document, int offset, String partitioning) {
        IRegion sourceRange;
        block3: {
            try {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                sourceRange = scanner.findSurroundingBlock(offset);
                if (sourceRange != null) break block3;
                return null;
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log((Throwable)e);
                return null;
            }
        }
        String source = document.get(sourceRange.getOffset(), sourceRange.getLength());
        StringBuffer contents = new StringBuffer();
        contents.append("class ____C{void ____m()");
        int methodOffset = contents.length();
        contents.append(source);
        contents.append('}');
        char[] buffer = contents.toString().toCharArray();
        return new CompilationUnitInfo(buffer, sourceRange.getOffset() - methodOffset);
    }

    private static int getBlockBalance(IDocument document, int offset, String partitioning) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset - 1;
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        do {
            begin = scanner.findOpeningPeer(begin - 1, '{', '}');
            end = scanner.findClosingPeer(end + 1, '{', '}');
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    private static IRegion getToken(IDocument document, IRegion scanRegion, int tokenId) {
        block5: {
            String source = document.get(scanRegion.getOffset(), scanRegion.getLength());
            fgScanner.setSource(source.toCharArray());
            int id = fgScanner.getNextToken();
            while (id != 158 && id != tokenId) {
                id = fgScanner.getNextToken();
            }
            if (id != 158) break block5;
            return null;
        }
        try {
            int tokenOffset = fgScanner.getCurrentTokenStartPosition();
            int tokenLength = fgScanner.getCurrentTokenEndPosition() + 1 - tokenOffset;
            return new Region(tokenOffset + scanRegion.getOffset(), tokenLength);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class CompilationUnitInfo {
        char[] buffer;
        int delta;

        CompilationUnitInfo(char[] buffer, int delta) {
            this.buffer = buffer;
            this.delta = delta;
        }
    }
}

