/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.dltk.core.DLTKCore;

public class Util {
    public static String displayString(String inputString) {
        return Util.displayString(inputString, 0);
    }

    public static String displayString(String inputString, int indent) {
        return Util.displayString(inputString, indent, false);
    }

    public static String displayString(String inputString, int indent, boolean shift) {
        if (inputString == null) {
            return "null";
        }
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        if (shift) {
            ++indent;
        }
        buffer.append("\"");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    if (!tokenizer.hasMoreTokens()) continue;
                    buffer.append("\" + \n");
                    int i2 = 0;
                    while (i2 < indent) {
                        buffer.append("\t");
                        ++i2;
                    }
                    buffer.append("\"");
                    continue;
                }
                buffer.append("\" + \n");
                int i3 = 0;
                while (i3 < indent) {
                    buffer.append("\t");
                    ++i3;
                }
                buffer.append("\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("\" + \n");
                int i4 = 0;
                while (i4 < indent) {
                    buffer.append("\t");
                    ++i4;
                }
                buffer.append("\"");
                continue;
            }
            StringBuffer tokenBuffer = new StringBuffer();
            int i5 = 0;
            while (i5 < token.length()) {
                char c = token.charAt(i5);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i5;
            }
            buffer.append(tokenBuffer.toString());
        }
        buffer.append("\"");
        return buffer.toString();
    }

    public static String convertToIndependantLineDelimiter(String source) {
        if (source.indexOf(10) == -1 && source.indexOf(13) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = source.length();
        while (i < length) {
            char car = source.charAt(i);
            if (car == '\r') {
                buffer.append('\n');
                if (i < length - 1 && source.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else {
                buffer.append(car);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void unzip(String zipPath, String destDirPath) throws IOException {
        block20: {
            FileInputStream zipIn = new FileInputStream(zipPath);
            byte[] buf = new byte[8192];
            File destDir = new File(destDirPath);
            ZipInputStream zis = new ZipInputStream(zipIn);
            FileOutputStream fos = null;
            try {
                try {
                    ZipEntry zEntry;
                    while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        File outFile = new File(destDir, zEntry.getName());
                        outFile.getParentFile().mkdirs();
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while ((n = zis.read(buf)) >= 0) {
                            fos.write(buf, 0, n);
                        }
                        fos.close();
                    }
                }
                catch (IOException iOException) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    try {
                        ((InputStream)zipIn).close();
                        if (zis != null) {
                            zis.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException3) {}
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)zipIn).close();
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)zipIn).close();
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void copyFiles(String from, String to) {
        File file = new File(from);
        File toFolder = new File(to);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            File child;
            block9: {
                child = new File(toFolder, files[i].getName());
                if (files[i].isDirectory()) {
                    child.mkdir();
                    Util.copyFiles(files[i].getAbsolutePath(), child.getAbsolutePath());
                } else if (files[i].isFile()) {
                    try {
                        BufferedInputStream input = new BufferedInputStream(new FileInputStream(files[i]), 4096);
                        org.eclipse.dltk.compiler.util.Util.copy((File)child, (InputStream)input);
                        input.close();
                    }
                    catch (FileNotFoundException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
            }
            child.setLastModified(files[i].lastModified());
            ++i;
        }
    }
}

