/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IInterpreterContainerExtension;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterContainer
implements IBuildpathContainer {
    private IInterpreterInstall fInterpreterInstall = null;
    private IPath fPath = null;
    private static Map fgBuildpathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IBuildpathEntry[] getBuildpathEntries(IInterpreterInstall interpreter) {
        IBuildpathEntry[] entries;
        if (fgBuildpathEntries == null) {
            fgBuildpathEntries = new HashMap(10);
            IInterpreterInstallChangedListener listener = new IInterpreterInstallChangedListener(){

                public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
                }

                public void interpreterChanged(PropertyChangeEvent event) {
                    if (event.getSource() != null) {
                        fgBuildpathEntries.remove(event.getSource());
                    }
                }

                public void interpreterAdded(IInterpreterInstall newInterpreter) {
                }

                public void interpreterRemoved(IInterpreterInstall removedInterpreter) {
                    fgBuildpathEntries.remove(removedInterpreter);
                }
            };
            ScriptRuntime.addInterpreterInstallChangedListener(listener);
        }
        if ((entries = (IBuildpathEntry[])fgBuildpathEntries.get(interpreter)) == null) {
            entries = InterpreterContainer.computeBuildpathEntries(interpreter);
            fgBuildpathEntries.put(interpreter, entries);
        }
        return entries;
    }

    private static IBuildpathEntry[] computeBuildpathEntries(IInterpreterInstall interpreter) {
        LibraryLocation[] libs = interpreter.getLibraryLocations();
        if (libs == null) {
            libs = ScriptRuntime.getLibraryLocations(interpreter);
        }
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(libs.length);
        HashSet<IPath> rawEntries = new HashSet<IPath>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath entryPath = libs[i].getLibraryPath();
            if (!entryPath.isEmpty() && !rawEntries.contains(entryPath)) {
                IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                ArrayList<IPath> excluded = new ArrayList<IPath>();
                int j = 0;
                while (j < libs.length) {
                    IPath pattern;
                    IPath otherPath = libs[j].getLibraryPath();
                    if (!otherPath.isEmpty() && entryPath.isPrefixOf(otherPath) && !otherPath.equals((Object)entryPath) && !excluded.contains(pattern = otherPath.setDevice(null).removeFirstSegments(entryPath.segmentCount()).append("*"))) {
                        excluded.add(pattern);
                    }
                    ++j;
                }
                entries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
                rawEntries.add(entryPath);
            }
            ++i;
        }
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        entries.add(DLTKCore.newBuiltinEntry((IPath)IBuildpathEntry.BUILTIN_EXTERNAL_ENTRY.append(interpreter.getInstallLocation().toOSString()), (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])new IPath[0], (boolean)false, (boolean)true));
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public InterpreterContainer(IInterpreterInstall interpreter, IPath path) {
        this.fInterpreterInstall = interpreter;
        this.fPath = path;
    }

    public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
        IBuildpathEntry[] buildpathEntries = InterpreterContainer.getBuildpathEntries(this.fInterpreterInstall);
        ArrayList entries = new ArrayList();
        entries.addAll(Arrays.asList(buildpathEntries));
        IInterpreterContainerExtension extension = DLTKLanguageManager.getInterpreterContainerExtensions((IScriptProject)project);
        if (extension != null) {
            extension.processEntres(project, entries);
        }
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public String getDescription(IScriptProject project) {
        String tag = this.fInterpreterInstall.getName();
        return MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainer_InterpreterEnvironment_System_Library_1, (Object[])new String[]{tag});
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        return this.fInterpreterInstall;
    }
}

