/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.dltk.core.internal.rse.Messages;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.perfomance.RSEPerfomanceStatistics;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEEnvironmentProvider
implements IEnvironmentProvider {
    public static final String RSE_SCHEME = "rse";
    public static final String RSE_ENVIRONMENT_PREFIX = "org.eclipse.dltk.rse.rseEnvironment.";
    private final Object lock = new Object();
    private boolean waitTimeoutReached = false;
    private static final int MAX_WAIT_COUNT = 20;
    private static final int WAIT_INTERVAL = 500;
    private boolean initialized = false;
    private InitThread initThread = null;
    private static final boolean DEBUG = false;

    public String getProviderName() {
        return Messages.RSEEnvironmentProvider_providerName;
    }

    public IEnvironment getEnvironment(String envId) {
        IRemoteFileSubSystem fs;
        String name;
        IHost connection;
        if (envId.startsWith(RSE_ENVIRONMENT_PREFIX) && (connection = this.getRSEConnection(name = envId.substring(RSE_ENVIRONMENT_PREFIX.length()))) != null && (fs = RemoteFileUtility.getFileSubSystem((IHost)connection)) != null) {
            return new RSEEnvironment(fs);
        }
        return null;
    }

    private IHost getRSEConnection(String name) {
        if (this.isReady()) {
            IHost[] connections = SystemStartHere.getConnections();
            int i = 0;
            while (i < connections.length) {
                IHost connection = connections[i];
                if (name.equals(connection.getAliasName())) {
                    return connection;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isInitialized() {
        return this.isReady(false);
    }

    private boolean isReady() {
        return this.isReady(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady(boolean allowWait) {
        Object object = this.lock;
        synchronized (object) {
            block9: {
                block10: {
                    block8: {
                        if (!this.initialized) break block8;
                        return true;
                    }
                    boolean newThread = false;
                    if (this.initThread == null) {
                        newThread = true;
                        this.initThread = new InitThread();
                        this.initThread.start();
                    }
                    if (!allowWait) break block9;
                    try {
                        this.lock.wait(newThread ? 250 : 100);
                    }
                    catch (InterruptedException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                if (!this.initialized) break block9;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedConnection(IHost connection) {
        IRSESystemType systemType = connection.getSystemType();
        return systemType != null && !systemType.isWindows() && !systemType.isLocal();
    }

    public IEnvironment[] getEnvironments() {
        IHost[] connections;
        if (this.isReady() && (connections = SystemStartHere.getConnections()) != null && connections.length != 0) {
            ArrayList<RSEEnvironment> environments = new ArrayList<RSEEnvironment>(connections.length);
            int i = 0;
            while (i < connections.length) {
                IRemoteFileSubSystem fs;
                IHost connection = connections[i];
                if (this.isSupportedConnection(connection) && (fs = RemoteFileUtility.getFileSubSystem((IHost)connection)) != null) {
                    environments.add(new RSEEnvironment(fs));
                }
                ++i;
            }
            return environments.toArray(new IEnvironment[environments.size()]);
        }
        return new IEnvironment[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitInitialized() {
        block8: {
            try {
                int waitCount = 0;
                while (!this.isReady(false)) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.waitTimeoutReached) {
                            break;
                        }
                        if (++waitCount > 20) {
                            this.waitTimeoutReached = true;
                            break;
                        }
                        this.lock.wait(500L);
                    }
                }
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEnvironment getProjectEnvironment(IProject project) {
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(7);
        }
        long start = System.currentTimeMillis();
        try {
            if (!project.isAccessible()) return null;
            try {
                URI uri = project.getDescription().getLocationURI();
                if (uri == null) return null;
                if (!RSE_SCHEME.equalsIgnoreCase(uri.getScheme())) return null;
                if (!this.isReady()) return null;
                IHost[] connections = SystemStartHere.getConnections();
                if (connections == null) return null;
                String projectHost = uri.getHost();
                int i = 0;
                while (i < connections.length) {
                    IRemoteFileSubSystem fs;
                    IHost connection = connections[i];
                    if (this.isSupportedConnection(connection) && projectHost.equalsIgnoreCase(connection.getHostName()) && (fs = RemoteFileUtility.getFileSubSystem((IHost)connection)) != null) {
                        RSEEnvironment rSEEnvironment = new RSEEnvironment(fs);
                        return rSEEnvironment;
                    }
                    ++i;
                }
                return null;
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) return null;
                e.printStackTrace();
                return null;
            }
        }
        finally {
            if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
                long end = System.currentTimeMillis();
                RSEPerfomanceStatistics.inc(8, end - start);
            }
        }
    }

    public IEnvironment getEnvironment(URI locationURI) {
        IHost[] connections;
        if (RSE_SCHEME.equalsIgnoreCase(locationURI.getScheme()) && this.isReady() && (connections = SystemStartHere.getConnections()) != null) {
            String projectHost = locationURI.getHost();
            int i = 0;
            while (i < connections.length) {
                IRemoteFileSubSystem fs;
                IHost connection = connections[i];
                if (this.isSupportedConnection(connection) && projectHost.equalsIgnoreCase(connection.getHostName()) && (fs = RemoteFileUtility.getFileSubSystem((IHost)connection)) != null) {
                    return new RSEEnvironment(fs);
                }
                ++i;
            }
        }
        return null;
    }

    private class InitThread
    extends Thread {
        private InitThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: {
                try {
                    try {
                        RSECorePlugin.waitForInitCompletion();
                    }
                    catch (InterruptedException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        Object object = RSEEnvironmentProvider.this.lock;
                        synchronized (object) {
                            RSEEnvironmentProvider.this.initialized = true;
                            RSEEnvironmentProvider.this.initThread = null;
                            RSEEnvironmentProvider.this.lock.notifyAll();
                        }
                        EnvironmentManager.refreshBuildpathContainersForMixedProjects();
                        EnvironmentManager.fireEnvirontmentChange();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object object = RSEEnvironmentProvider.this.lock;
                    synchronized (object) {
                        RSEEnvironmentProvider.this.initialized = true;
                        RSEEnvironmentProvider.this.initThread = null;
                        RSEEnvironmentProvider.this.lock.notifyAll();
                    }
                    EnvironmentManager.refreshBuildpathContainersForMixedProjects();
                    EnvironmentManager.fireEnvirontmentChange();
                    throw throwable;
                }
                Object object = RSEEnvironmentProvider.this.lock;
                synchronized (object) {
                    RSEEnvironmentProvider.this.initialized = true;
                    RSEEnvironmentProvider.this.initThread = null;
                    RSEEnvironmentProvider.this.lock.notifyAll();
                }
                EnvironmentManager.refreshBuildpathContainersForMixedProjects();
                EnvironmentManager.fireEnvirontmentChange();
            }
        }
    }
}

