/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IASTCache;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTLoader;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTSaver;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TclASTCache
implements IASTCache {
    public static final String TCL_AST_ATTRIBUTE = "_ast";
    public static final String TCL_PKG_INFO = "_pinf";
    public static final String TCL_STRUCTURE_INDEX = "_sind";
    public static final String TCL_MIXIN_INDEX = "_smix";
    List<StoreEntry> entriesToStore = new ArrayList<StoreEntry>();
    private Thread storeASTThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                List<StoreEntry> list = TclASTCache.this.entriesToStore;
                synchronized (list) {
                    block10: {
                        if (TclASTCache.this.entriesToStore.isEmpty()) {
                            try {
                                TclASTCache.this.entriesToStore.wait(100L);
                            }
                            catch (InterruptedException e) {
                                if (DLTKCore.DEBUG) {
                                    e.printStackTrace();
                                }
                                break block10;
                            }
                        }
                        StoreEntry entry = TclASTCache.this.entriesToStore.remove(0);
                        IContentCache cache = ModelManager.getModelManager().getCoreCache();
                        OutputStream stream = cache.getCacheEntryAttributeOutputStream(entry.handle, TclASTCache.TCL_AST_ATTRIBUTE);
                        TclASTCache.storeTclEntryInCache(entry.problems, entry.module, stream);
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    };

    public TclASTCache() {
        this.storeASTThread.start();
    }

    public IASTCache.ASTCacheEntry restoreModule(ISourceModule module) {
        IFileHandle handle = EnvironmentPathUtils.getFile((IModelElement)module);
        if (handle == null) {
            return null;
        }
        IContentCache cache = ModelManager.getModelManager().getCoreCache();
        ProblemCollector collector = new ProblemCollector();
        TclModule tclModule = null;
        tclModule = TclASTCache.restoreTclModuleFromCache(handle, cache, (IProblemReporter)collector);
        if (tclModule != null) {
            IASTCache.ASTCacheEntry entry = new IASTCache.ASTCacheEntry();
            NewTclSourceParser parser = new NewTclSourceParser();
            entry.problems = collector;
            entry.module = parser.parse(null, tclModule, null);
            if (entry.problems.isEmpty()) {
                entry.problems = null;
            }
            return entry;
        }
        return null;
    }

    public static TclModule restoreTclModuleFromCache(IFileHandle handle, IContentCache cache, IProblemReporter collector) {
        block4: {
            InputStream stream = cache.getCacheEntryAttribute(handle, TCL_AST_ATTRIBUTE);
            if (stream != null) {
                try {
                    TclASTLoader loader = new TclASTLoader(stream);
                    TclModule tclModule = loader.getModule(collector);
                    stream.close();
                    if (tclModule != null) {
                        return tclModule;
                    }
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static EObject copy(EObject eObject) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, false);
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeModule(ISourceModule module, ModuleDeclaration moduleDeclaration, ProblemCollector problems) {
        TclModuleDeclaration decl;
        TclModule tclModule;
        IFileHandle handle = EnvironmentPathUtils.getFile((IModelElement)module);
        if (handle == null) {
            return;
        }
        if (moduleDeclaration instanceof TclModuleDeclaration && (tclModule = (decl = (TclModuleDeclaration)moduleDeclaration).getTclModule()) != null) {
            StoreEntry entry = new StoreEntry();
            entry.handle = handle;
            entry.module = tclModule;
            if (problems != null) {
                entry.problems = new ProblemCollector();
                problems.copyTo((IProblemReporter)entry.problems);
            }
            List<StoreEntry> list = this.entriesToStore;
            synchronized (list) {
                this.entriesToStore.add(entry);
                this.entriesToStore.notifyAll();
            }
        }
    }

    public static void storeTclEntryInCache(ProblemCollector problems, TclModule tclModule, OutputStream stream) {
        try {
            TclASTSaver saver = new TclASTSaver(tclModule, stream);
            saver.store(problems);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class StoreEntry {
        ProblemCollector problems;
        IFileHandle handle;
        TclModule module;

        private StoreEntry() {
        }
    }
}

