/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.editor;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ruby.internal.ui.RubyImages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;

public class RubyOutlineLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    private final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

    public String decorateText(String text, Object element) {
        return text;
    }

    private static ImageDescriptor getTopRight(int flags) {
        if ((flags & 0x100) != 0) {
            return RubyImages.DESC_OVR_STATIC_FIELD;
        }
        if ((flags & 4) != 0) {
            return RubyImages.DESC_OVR_CONST_FIELD;
        }
        return null;
    }

    private static ImageDescriptor getTopLeft(int flags) {
        if ((flags & 0x80000) != 0) {
            return DLTKPluginImages.DESC_OVR_ABSTRACT;
        }
        if ((flags & 0x100000) != 0) {
            return DLTKPluginImages.DESC_OVR_CALLER;
        }
        return null;
    }

    public Image decorateImage(Image image, Object obj) {
        block4: {
            try {
                IMember member;
                if (obj instanceof IMember && (member = (IMember)obj).exists()) {
                    int flags = member.getFlags();
                    ImageDescriptor left = RubyOutlineLabelDecorator.getTopLeft(flags);
                    ImageDescriptor right = RubyOutlineLabelDecorator.getTopRight(flags);
                    if (left != null || right != null) {
                        ImageDescriptor[] decorations = new ImageDescriptor[5];
                        decorations[0] = left;
                        decorations[1] = right;
                        return this.registry.get((ImageDescriptor)new DecorationOverlayIcon(image, decorations));
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return image;
    }

    public void dispose() {
        super.dispose();
        this.registry.dispose();
    }
}

