/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.MixinModelRegistry;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.core.AbstractProjectIndexer;
import org.eclipse.dltk.core.search.indexing.core.RemoveIndexRequest;
import org.eclipse.dltk.internal.core.mixin.MixinIndexer;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;

public class MixinProjectIndexer
extends AbstractProjectIndexer {
    public void doIndexing(DLTKSearchDocument document, ISourceModule module) {
        new MixinIndexer(document, module).indexDocument();
        MixinModelRegistry.clearKeysCache(DLTKLanguageManager.getLanguageToolkit(module));
    }

    public Index getProjectIndex(IPath path) {
        String containerPath = path.getDevice() == null ? path.toString() : path.toOSString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path.toString(), containerPath);
    }

    public Index getProjectFragmentIndex(IProjectFragment fragment) {
        String path = fragment.getPath().toString();
        return this.getIndexManager().getSpecialIndex("#special#mixin#", path, path);
    }

    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path("#special#mixin#" + projectPath.toString())));
    }

    public void removeLibrary(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path("#special#mixin#" + path.toString())));
    }
}

