/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

class ProjectFragmentInfo
extends OpenableElementInfo {
    protected int fRootKind = 1;
    protected Object[] foreignResources;

    ProjectFragmentInfo() {
    }

    public int getRootKind() {
        return this.fRootKind;
    }

    void setForeignResources(Object[] resources) {
        this.foreignResources = resources;
    }

    public Object[] getForeignResources(IScriptProject scriptProject, IResource resource, ProjectFragment fragment) {
        Object[] nonScriptResources = this.foreignResources;
        if (nonScriptResources == null) {
            nonScriptResources = this.computeForeignResources(scriptProject, resource, fragment);
            this.foreignResources = nonScriptResources;
        }
        return nonScriptResources;
    }

    private Object[] computeForeignResources(IScriptProject scriptProject, IResource underlyingResource, ProjectFragment handle) {
        Object[] nonScriptResources = NO_NON_SCRIPT_RESOURCES;
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                nonScriptResources = ProjectFragmentInfo.computeFolderForeignResources((ScriptProject)scriptProject, (IContainer)underlyingResource, handle.fullInclusionPatternChars(), handle.fullExclusionPatternChars());
            }
        }
        catch (ModelException modelException) {}
        return nonScriptResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] computeFolderForeignResources(ScriptProject project, IContainer folder, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        Object[] nonScriptResources = new IResource[5];
        int nonScriptResourcesCounter = 0;
        try {
            IBuildpathEntry[] classpath = project.getResolvedBuildpath();
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (true) {
                block10: {
                    if (i >= max) {
                        if (nonScriptResources.length != nonScriptResourcesCounter) {
                            Object[] objectArray = nonScriptResources;
                            nonScriptResources = new IResource[nonScriptResourcesCounter];
                            System.arraycopy(objectArray, 0, nonScriptResources, 0, nonScriptResourcesCounter);
                        }
                        return nonScriptResources;
                    }
                    IResource member = members[i];
                    switch (member.getType()) {
                        case 1: {
                            String fileName = member.getName();
                            if ((!Util.isValidSourceModule((IModelElement)project, member) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) && (!org.eclipse.dltk.compiler.util.Util.isArchiveFileName(DLTKLanguageManager.getLanguageToolkit(project), fileName) || !ProjectFragmentInfo.isBuildpathEntry(member.getFullPath(), classpath))) break;
                            break block10;
                        }
                        case 2: {
                            if (Util.isValidFolderNameForPackage(member.getName()) && (!Util.isExcluded(member, inclusionPatterns, exclusionPatterns) || ProjectFragmentInfo.isBuildpathEntry(member.getFullPath(), classpath))) break block10;
                        }
                    }
                    if (nonScriptResources.length == nonScriptResourcesCounter) {
                        Object[] objectArray = nonScriptResources;
                        nonScriptResources = new IResource[nonScriptResourcesCounter * 2];
                        System.arraycopy(objectArray, 0, nonScriptResources, 0, nonScriptResourcesCounter);
                    }
                    nonScriptResources[nonScriptResourcesCounter++] = member;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    private static boolean isBuildpathEntry(IPath path, IBuildpathEntry[] resolvedClasspath) {
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IBuildpathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

