/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.environment;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.dltk.core.environment.Messages;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.utils.ExecutableOperation;
import org.eclipse.dltk.utils.ExecutionContexts;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.osgi.util.NLS;

public final class EnvironmentManager {
    private static final QualifiedName PROJECT_ENVIRONMENT = new QualifiedName("org.eclipse.dltk.core", "environment");
    private static final String ENVIRONMENT_EXTENSION = "org.eclipse.dltk.core.environment";
    private static final EnvironmentManagerExtensionManager manager = new EnvironmentManagerExtensionManager();
    private static ListenerList listeners = new ListenerList();

    private EnvironmentManager() {
    }

    public static IEnvironment getEnvironment(IModelElement element) {
        IScriptProject scriptProject;
        URI locationURI;
        if (element == null) {
            return null;
        }
        IResource res = element.getResource();
        if (res != null && res.getType() != 4 && (locationURI = res.getLocationURI()) != null) {
            for (IEnvironmentProvider provider : manager) {
                EnvironmentManager.waitInitialized(provider);
                IEnvironment env = provider.getEnvironment(locationURI);
                if (env == null) continue;
                return env;
            }
        }
        if ((scriptProject = element.getScriptProject()) == null) {
            return null;
        }
        IProject project = scriptProject.getProject();
        if (project == null) {
            return null;
        }
        return EnvironmentManager.getEnvironment(project);
    }

    public static IEnvironment getEnvironment(IResource element) {
        IProject project;
        URI locationURI;
        if (element == null) {
            return null;
        }
        if (element != null && element.getType() != 4 && (locationURI = element.getLocationURI()) != null) {
            for (IEnvironmentProvider provider : manager) {
                EnvironmentManager.waitInitialized(provider);
                IEnvironment env = provider.getEnvironment(locationURI);
                if (env == null) continue;
                return env;
            }
        }
        if ((project = element.getProject()) == null) {
            return null;
        }
        return EnvironmentManager.getEnvironment(project);
    }

    public static IEnvironment getEnvironment(IProject project) {
        block4: {
            if (!" ".equals(project.getName())) {
                try {
                    IEnvironment environment;
                    String environmentId = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                    if (environmentId != null && (environment = EnvironmentManager.getEnvironmentById(environmentId)) != null) {
                        return environment;
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return EnvironmentManager.detectEnvironment(project);
    }

    private static IEnvironment detectEnvironment(IProject project) {
        for (IEnvironmentProvider provider : manager) {
            EnvironmentManager.waitInitialized(provider);
            IEnvironment environment = provider.getProjectEnvironment(project);
            if (environment == null) continue;
            return environment;
        }
        return null;
    }

    public static String getEnvironmentId(IProject project) {
        return EnvironmentManager.getEnvironmentId(project, true);
    }

    public static String getEnvironmentId(IProject project, boolean detectAutomatically) {
        block4: {
            try {
                String environmentId = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                if (environmentId != null) {
                    return environmentId;
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (detectAutomatically) {
            IEnvironment environment = EnvironmentManager.detectEnvironment(project);
            return environment != null ? environment.getId() : null;
        }
        return null;
    }

    public static void setEnvironmentId(IProject project, String environmentId) throws CoreException {
        EnvironmentManager.setEnvironmentId(project, environmentId, true);
    }

    public static void setEnvironmentId(IProject project, String environmentId, boolean refresh) throws CoreException {
        IScriptProject scriptProject;
        project.setPersistentProperty(PROJECT_ENVIRONMENT, environmentId);
        if (refresh && (scriptProject = DLTKCore.create(project)) != null) {
            DLTKCore.refreshBuildpathContainers(scriptProject);
            new BuildpathValidation((ScriptProject)scriptProject).validate();
        }
    }

    public static void refreshBuildpathContainersForMixedProjects() {
        block6: {
            try {
                IScriptProject[] projects = ModelManager.getModelManager().getModel().getScriptProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i].getProject();
                    String property = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                    if (property != null) {
                        DLTKCore.refreshBuildpathContainers(projects[i]);
                        new BuildpathValidation((ScriptProject)projects[i]).validate();
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
    }

    public static void setEnvironment(IProject project, IEnvironment environment) throws CoreException {
        EnvironmentManager.setEnvironmentId(project, environment != null ? environment.getId() : null);
    }

    public static IEnvironment[] getEnvironments() {
        return EnvironmentManager.getEnvironments(true);
    }

    public static IEnvironment[] getEnvironments(boolean allowWait) {
        ArrayList envList = new ArrayList();
        for (IEnvironmentProvider provider : manager) {
            if (allowWait) {
                EnvironmentManager.waitInitialized(provider);
            }
            envList.addAll(Arrays.asList(provider.getEnvironments()));
        }
        IEnvironment[] environments = new IEnvironment[envList.size()];
        envList.toArray(environments);
        return environments;
    }

    public static boolean isLocal(IEnvironment env) {
        return "org.eclipse.dltk.core.environment.localEnvironment".equals(env.getId());
    }

    public static IEnvironment getEnvironmentById(String envId) {
        for (IEnvironmentProvider provider : manager) {
            EnvironmentManager.waitInitialized(provider);
            IEnvironment env = provider.getEnvironment(envId);
            if (env == null) continue;
            return env;
        }
        return null;
    }

    public static void addEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.remove((Object)listener);
    }

    public static void environmentAdded(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentAdded(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void environmentRemoved(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentRemoved(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void environmentChanged(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentChanged(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void fireEnvirontmentChange() {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentsModified();
            ++i;
        }
    }

    public static IEnvironment getLocalEnvironment() {
        return EnvironmentManager.getEnvironmentById("org.eclipse.dltk.core.environment.localEnvironment");
    }

    public static boolean isInitialized() {
        for (IEnvironmentProvider provider : manager) {
            if (provider.isInitialized()) continue;
            return false;
        }
        return true;
    }

    private static void waitInitialized(final IEnvironmentProvider provider) {
        if (provider.isInitialized()) {
            return;
        }
        ExecutionContexts.getManager().executeInBackground(new ExecutableOperation(Messages.EnvironmentManager_initializingOperationName){

            public void execute(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                monitor.setTaskName(NLS.bind((String)Messages.EnvironmentManager_initializingTaskName, (Object)provider.getProviderName()));
                provider.waitInitialized();
                monitor.worked(1);
                monitor.done();
            }
        });
    }

    public static void waitInitialized() {
        EnvironmentManager.waitInitialized(null);
    }

    public static void waitInitialized(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", manager.getDescriptors().length);
        }
        for (IEnvironmentProvider provider : manager) {
            if (monitor != null) {
                monitor.setTaskName(NLS.bind((String)Messages.EnvironmentManager_initializingTaskName, (Object)provider.getProviderName()));
            }
            provider.waitInitialized();
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentManagerExtensionManager
    extends LazyExtensionManager<IEnvironmentProvider> {
        public EnvironmentManagerExtensionManager() {
            super(EnvironmentManager.ENVIRONMENT_EXTENSION);
        }

        @Override
        protected LazyExtensionManager.Descriptor<IEnvironmentProvider> createDescriptor(IConfigurationElement confElement) {
            return new EnvironmentProviderDesc(this, confElement);
        }

        @Override
        protected void initializeDescriptors(List<LazyExtensionManager.Descriptor<IEnvironmentProvider>> descriptors) {
            Collections.sort(descriptors, new Comparator<LazyExtensionManager.Descriptor<IEnvironmentProvider>>(){

                @Override
                public int compare(LazyExtensionManager.Descriptor<IEnvironmentProvider> arg0, LazyExtensionManager.Descriptor<IEnvironmentProvider> arg1) {
                    EnvironmentProviderDesc d1 = (EnvironmentProviderDesc)arg0;
                    EnvironmentProviderDesc d2 = (EnvironmentProviderDesc)arg1;
                    return d1.priority - d2.priority;
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EnvironmentProviderDesc
        extends LazyExtensionManager.Descriptor<IEnvironmentProvider> {
            private int priority;

            public EnvironmentProviderDesc(EnvironmentManagerExtensionManager manager, IConfigurationElement configurationElement) {
                super(manager, configurationElement);
                this.priority = this.parseInt(configurationElement.getAttribute("priority"));
            }

            private int parseInt(String value) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        }
    }
}

