/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKFeatures;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;

public abstract class AbstractLanguageToolkit
implements IDLTKLanguageToolkit {
    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    public boolean validateSourcePackage(IPath path, IEnvironment environment) {
        return true;
    }

    public IStatus validateSourceModule(IResource resource) {
        return Status.OK_STATUS;
    }

    protected static boolean isEmptyExtension(String name) {
        return name.indexOf(46) == -1;
    }

    public boolean canValidateContent(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment(project);
        if (environment == null || !environment.isLocal()) {
            return false;
        }
        return AbstractLanguageToolkit.isEmptyExtension(resource.getName());
    }

    public boolean canValidateContent(File file) {
        return AbstractLanguageToolkit.isEmptyExtension(file.getName());
    }

    public boolean canValidateContent(IFileHandle file) {
        return false;
    }

    public String getPreferenceQualifier() {
        return null;
    }

    public boolean get(DLTKFeatures.BooleanFeature feature) {
        return feature.getDefaultValue();
    }

    public int get(DLTKFeatures.IntegerFeature feature) {
        return feature.getDefaultValue();
    }

    public String get(DLTKFeatures.StringFeature feature) {
        return feature.getDefaultValue();
    }
}

