/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.formatting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static String createIndentString(int indentationUnits, IScriptProject project) {
        if (project != null) {
            project.getOptions(true);
        } else {
            DLTKCore.getOptions();
        }
        throw new UnsupportedOperationException();
    }

    public static int getTabWidth(IScriptProject project) {
        String key = " ".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.dltk.javascript.ui.formatter.tabulation.char")) ? "org.eclipse.dltk.javascript.ui.formatter.indentation.size" : "org.eclipse.dltk.javascript.ui.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(IScriptProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.dltk.javascript.ui.formatter.tabulation.char")) ? "org.eclipse.dltk.javascript.ui.formatter.indentation.size" : "org.eclipse.dltk.javascript.ui.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static String getCoreOption(IScriptProject project, String key) {
        if (project == null) {
            return DLTKCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private static int getCoreOption(IScriptProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue((!positions[i].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            JavaScriptUI.log((Exception)((Object)e));
            Assert.isTrue((boolean)false, (String)("Formatter created edits with wrong positions: " + e.getMessage()));
            return null;
        }
    }

    public static TextEdit format2(int kind, String string, int offset, int length, StringBuffer computeIndentation, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        IScriptFormatterFactory factory = ScriptFormatterManager.getSelected((String)"org.eclipse.dltk.javascript.core.nature", null);
        HashMap<String, Comparable<StringBuffer>> optionsCopy = new HashMap<String, Comparable<StringBuffer>>(options);
        optionsCopy.put("old.computeIndentation", computeIndentation);
        optionsCopy.put("old.kind", new Integer(kind));
        try {
            return factory.createFormatter(lineSeparator, optionsCopy).format(string, offset, length, 0);
        }
        catch (FormatterException e) {
            JavaScriptUI.log((Exception)((Object)e));
            return new MultiTextEdit();
        }
    }

    public static TextEdit format2(int kind, String string, StringBuffer indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.format2(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }
}

