/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;

public class TestSourceElementParser
implements ISourceElementParser {
    private static final String PARSEME_HEADER = "# parseme!\n";
    private ISourceElementRequestor requestor;

    public void parseSourceModule(ISourceModule module, ISourceModuleInfoCache.ISourceModuleInfo astCashe) {
        String file = module.getSourceContents();
        if (file.startsWith(PARSEME_HEADER)) {
            this.parsePseudo(file);
            return;
        }
        this.requestor.enterModule();
        ISourceElementRequestor.TypeInfo ti = new ISourceElementRequestor.TypeInfo();
        ti.name = "Class1";
        this.requestor.enterType(ti);
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        mi.name = "Method1";
        this.requestor.enterMethod(mi);
        this.requestor.exitMethod(10);
        this.requestor.exitType(10);
        mi.name = "Procedure1";
        this.requestor.enterMethod(mi);
        this.requestor.exitMethod(11);
        this.requestor.exitModule(20);
    }

    private void parsePseudo(String file) {
        if (this.requestor == null) {
            return;
        }
        this.requestor.enterModule();
        String[] lines = file.split("\n");
        int currentLineOffset = 0;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String[] split = line.split("\\s+");
            if (split.length > 0) {
                String arg;
                String cmd = split[0];
                String string = arg = split.length > 1 ? split[1] : null;
                if (cmd.equals("enterType")) {
                    ISourceElementRequestor.TypeInfo ti = new ISourceElementRequestor.TypeInfo();
                    ti.name = arg;
                    ti.declarationStart = currentLineOffset;
                    ti.nameSourceStart = currentLineOffset;
                    ti.nameSourceEnd = currentLineOffset + line.length();
                    this.requestor.enterType(ti);
                } else if (cmd.equals("enterMethod")) {
                    ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
                    mi.name = arg;
                    mi.declarationStart = currentLineOffset;
                    mi.nameSourceStart = currentLineOffset;
                    mi.nameSourceEnd = currentLineOffset + line.length();
                    this.requestor.enterMethod(mi);
                } else if (cmd.equals("exitType")) {
                    this.requestor.exitType(currentLineOffset + line.length());
                } else if (cmd.equals("exitMethod")) {
                    this.requestor.exitMethod(currentLineOffset + line.length());
                }
            }
            currentLineOffset += line.length() + 1;
            ++i;
        }
        this.requestor.exitModule(file.length());
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    public void setReporter(IProblemReporter reporter) {
    }
}

