/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.tcl.ast.ArgumentMatch;
import org.eclipse.dltk.tcl.ast.AstFactory;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Constant;
import org.eclipse.dltk.tcl.definitions.Group;
import org.eclipse.dltk.tcl.definitions.Switch;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.dltk.tcl.internal.parser.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;
import org.eclipse.dltk.tcl.parser.ITclParserOptions;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclParserUtils
implements ITclParserOptions {
    public static final Pattern VERSION_PATTERN = Pattern.compile("([\\(\\[][^\\(\\)]*[\\)\\]])");
    public static final Pattern INTERVAL_PATTERN = Pattern.compile("([\\(\\[])(.*)[:;](.*)([\\)\\]])");
    public static final Pattern VALID_VERSION_PATTERN = Pattern.compile("([\\(\\[](([0-9]+(\\.[0-9]+)*)|-)[;:](([0-9]+(\\.[0-9]+)*)|-)[\\)\\]]\\s*)*");
    static final int SUBCOMMAND = 0;
    static final int OPTIONS = 1;
    static final int MODE = 2;
    static final int REGULAR = 3;

    public static boolean isVersionValid(String version) {
        if (version == null || version.equals("")) {
            return true;
        }
        version = version.trim();
        Matcher matcher = VALID_VERSION_PATTERN.matcher(version);
        return matcher.matches();
    }

    public static boolean parseVersion(String version, String currentVersion) {
        if (version == null || version.equals("")) {
            return false;
        }
        Matcher versionMatcher = VERSION_PATTERN.matcher(version);
        boolean isValid = false;
        while (versionMatcher.find()) {
            boolean isIntervalValid = true;
            String interval = versionMatcher.group(1);
            Matcher intervalMatcher = INTERVAL_PATTERN.matcher(interval);
            while (intervalMatcher.find()) {
                String lowerType = intervalMatcher.group(1);
                String lowerVersion = intervalMatcher.group(2);
                String upperVersion = intervalMatcher.group(3);
                String upperType = intervalMatcher.group(4);
                if (!lowerVersion.equals("-")) {
                    if (lowerType.equals("(") && TclParserUtils.compareVersions(currentVersion, lowerVersion) <= 0) {
                        isIntervalValid = false;
                        continue;
                    }
                    if (lowerType.equals("[") && TclParserUtils.compareVersions(currentVersion, lowerVersion) < 0) {
                        isIntervalValid = false;
                        continue;
                    }
                }
                if (upperVersion.equals("-")) continue;
                if (upperType.equals(")") && TclParserUtils.compareVersions(currentVersion, upperVersion) >= 0) {
                    isIntervalValid = false;
                    continue;
                }
                if (!upperType.equals("]") || TclParserUtils.compareVersions(currentVersion, upperVersion) <= 0) continue;
                isIntervalValid = false;
            }
            if (!isIntervalValid) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public static int compareVersions(String v1, String v2) {
        String[] splited1 = v1.split("\\.");
        String[] splited2 = v2.split("\\.");
        int res = splited1.length - splited2.length;
        int min = splited1.length < splited2.length ? splited1.length : splited2.length;
        int i = 0;
        while (i < min) {
            if (Integer.parseInt(splited1[i]) > Integer.parseInt(splited2[i])) {
                return 1;
            }
            if (Integer.parseInt(splited1[i]) < Integer.parseInt(splited2[i])) {
                return -1;
            }
            ++i;
        }
        return res;
    }

    public static List<TclArgument> parseCommandArguments(int offset, String content, List<Integer> blockArguments) {
        ArrayList<TclArgument> results = new ArrayList<TclArgument>();
        try {
            TclScript script;
            AstFactory factory = AstFactory.eINSTANCE;
            SimpleTclParser parser = new SimpleTclParser();
            try {
                script = parser.parse(content);
            }
            catch (TclParseException e) {
                e.printStackTrace();
                return results;
            }
            List<TclCommand> commands = script.getCommands();
            int i = 0;
            while (i < commands.size()) {
                TclCommand command = commands.get(i);
                List<TclWord> words = command.getWords();
                int start = -1;
                for (TclWord word : words) {
                    TclElement bs;
                    String wordText = null;
                    if (start == -1) {
                        start = word.getStart();
                    }
                    StringArgument exp = null;
                    Object o = word.getContents().get(0);
                    if (o instanceof QuotesSubstitution) {
                        wordText = content.substring(word.getStart(), word.getEnd() + 1);
                        QuotesSubstitution qs = (QuotesSubstitution)o;
                        StringArgument literal = factory.createStringArgument();
                        literal.setStart(offset + qs.getStart());
                        literal.setEnd(offset + qs.getEnd() + 1);
                        literal.setValue(wordText);
                        exp = literal;
                    } else if (o instanceof BracesSubstitution) {
                        wordText = content.substring(word.getStart(), word.getEnd() + 1);
                        bs = (BracesSubstitution)o;
                        StringArgument block = factory.createStringArgument();
                        block.setStart(offset + bs.getStart());
                        block.setEnd(offset + bs.getEnd() + 1);
                        block.setValue(wordText);
                        exp = block;
                    } else if (o instanceof CommandSubstitution && word.getContents().size() == 1) {
                        wordText = content.substring(word.getStart(), word.getEnd() + 1);
                        bs = (CommandSubstitution)o;
                        StringArgument bl = factory.createStringArgument();
                        bl.setStart(offset + bs.getStart());
                        bl.setEnd(offset + bs.getEnd() + 1);
                        bl.setValue(wordText);
                        if (blockArguments != null) {
                            blockArguments.add(results.size());
                        }
                        exp = bl;
                    } else {
                        wordText = content.substring(word.getStart(), word.getEnd() + 1);
                        StringArgument reference = factory.createStringArgument();
                        reference.setStart(offset + word.getStart());
                        reference.setEnd(offset + word.getEnd() + 1);
                        reference.setValue(wordText);
                        exp = reference;
                    }
                    results.add(exp);
                }
                ++i;
            }
            return results;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return results;
        }
    }

    public static <T> void traverse(List<T> nodes, TclVisitor visitor) {
        int i = 0;
        while (i < nodes.size()) {
            TclArgument list;
            Node nde = (Node)nodes.get(i);
            if (nde instanceof Script) {
                Script script = (Script)nde;
                if (visitor.visit(script)) {
                    TclParserUtils.traverse(script.getCommands(), visitor);
                    visitor.endVisit(script);
                }
            } else if (nde instanceof Substitution) {
                Substitution substitution = (Substitution)nde;
                if (visitor.visit(substitution)) {
                    TclParserUtils.traverse(substitution.getCommands(), visitor);
                    visitor.endVisit(substitution);
                }
            } else if (nde instanceof org.eclipse.dltk.tcl.ast.TclCommand) {
                org.eclipse.dltk.tcl.ast.TclCommand command = (org.eclipse.dltk.tcl.ast.TclCommand)nde;
                if (visitor.visit(command)) {
                    TclParserUtils.traverse(command.getArguments(), visitor);
                    visitor.endVisit(command);
                }
            } else if (nde instanceof StringArgument) {
                StringArgument argument = (StringArgument)nde;
                if (visitor.visit(argument)) {
                    visitor.endVisit(argument);
                }
            } else if (nde instanceof TclArgumentList) {
                list = (TclArgumentList)nde;
                if (visitor.visit((TclArgumentList)list)) {
                    TclParserUtils.traverse(list.getArguments(), visitor);
                    visitor.endVisit((TclArgumentList)list);
                }
            } else if (nde instanceof ComplexString) {
                list = (ComplexString)nde;
                if (visitor.visit((ComplexString)list)) {
                    TclParserUtils.traverse(list.getArguments(), visitor);
                    visitor.endVisit((ComplexString)list);
                }
            } else if (nde instanceof VariableReference && visitor.visit((VariableReference)(list = (VariableReference)nde))) {
                TclArgument index = list.getIndex();
                if (index != null) {
                    ArrayList<TclArgument> l = new ArrayList<TclArgument>();
                    l.add(index);
                    TclParserUtils.traverse(l, visitor);
                }
                visitor.endVisit((VariableReference)list);
            }
            ++i;
        }
    }

    public static String getSynopsis(Command command) {
        if (command == null) {
            return null;
        }
        List<StringBuilder> list = new ArrayList<StringBuilder>();
        StringBuilder synopsis = new StringBuilder();
        String name = command.getName();
        if (name != null && !name.equals("")) {
            list.add(new StringBuilder(name));
        }
        int i = 0;
        while (i < command.getArguments().size()) {
            Argument arg = (Argument)command.getArguments().get(i);
            list = TclParserUtils.concatSynopsises(list, TclParserUtils.getSynopsisArgInfo(arg, i));
            ++i;
        }
        boolean first = true;
        for (StringBuilder str : list) {
            if (!first) {
                synopsis.append("\n");
            } else {
                first = false;
            }
            synopsis.append(str.toString());
        }
        return synopsis.toString();
    }

    private static List<StringBuilder> getSynopsisArgInfo(Argument arg, int pos) {
        List<StringBuilder> list = new ArrayList<StringBuilder>();
        if (arg instanceof Constant) {
            list.add(new StringBuilder(((Constant)arg).getName()));
        } else if (arg instanceof TypedArgument) {
            list.add(new StringBuilder(((TypedArgument)arg).getName()));
        } else if (arg instanceof Group) {
            String constant = ((Group)arg).getConstant();
            if (constant != null && !constant.equals("")) {
                list.add(new StringBuilder(constant));
            }
            for (Object sub : ((Group)arg).getArguments()) {
                list = TclParserUtils.concatSynopsises(list, TclParserUtils.getSynopsisArgInfo((Argument)sub, pos + 1));
            }
        } else if (arg instanceof ComplexArgument) {
            for (Object sub : ((ComplexArgument)arg).getArguments()) {
                list = TclParserUtils.concatSynopsises(list, TclParserUtils.getSynopsisArgInfo((Argument)sub, pos + 1));
            }
            for (Object sub : list) {
                ((StringBuilder)sub).insert(0, "{");
                ((StringBuilder)sub).append("}");
            }
        } else if (arg instanceof Switch) {
            int type = 3;
            String constant = null;
            if (((Switch)arg).getGroups() != null && (constant = ((Group)((Switch)arg).getGroups().get(0)).getConstant()) != null && !constant.equals("")) {
                type = constant.startsWith("-") ? 1 : (pos == 0 ? 0 : 2);
            }
            switch (type) {
                case 3: {
                    if (arg.getLowerBound() == 0) {
                        list.add(new StringBuilder(""));
                    }
                }
                case 0: {
                    for (Group group : ((Switch)arg).getGroups()) {
                        list.addAll(TclParserUtils.getSynopsisArgInfo(group, pos + 1));
                    }
                    return list;
                }
                case 1: 
                case 2: {
                    boolean first = true;
                    StringBuilder options = new StringBuilder();
                    options.append("<");
                    for (Group group : ((Switch)arg).getGroups()) {
                        for (StringBuilder str : TclParserUtils.getSynopsisArgInfo(group, pos + 1)) {
                            if (!first) {
                                options.append("|");
                            } else {
                                first = false;
                            }
                            options.append((CharSequence)str);
                        }
                    }
                    options.append(">");
                    list.add(options);
                }
            }
        }
        for (StringBuilder res : list) {
            String value;
            if (arg.getUpperBound() == 0) continue;
            if (arg.getUpperBound() == -1) {
                if (arg.getLowerBound() == 0) {
                    res.append(" ...");
                    res.insert(0, "?");
                    res.append("?");
                    continue;
                }
                value = res.toString();
                int i = 0;
                while (i < arg.getUpperBound() - 1) {
                    res.append(" ").append(value);
                    ++i;
                }
                res.append(" ?").append(value).append(" ...?");
                continue;
            }
            if (arg.getUpperBound() == 1) {
                if (arg.getLowerBound() != 0) continue;
                res.insert(0, "?");
                res.append("?");
                continue;
            }
            value = res.toString();
            int i = 0;
            while (i < arg.getUpperBound()) {
                res.append(" ").append(value);
                ++i;
            }
        }
        return list;
    }

    private static List<StringBuilder> concatSynopsises(List<StringBuilder> prefixes, List<StringBuilder> ss) {
        ArrayList<StringBuilder> newList = new ArrayList<StringBuilder>();
        if (prefixes.size() == 0) {
            return ss;
        }
        for (StringBuilder prefix : prefixes) {
            for (StringBuilder s : ss) {
                StringBuilder str = new StringBuilder(prefix);
                newList.add(str.append(" ").append(s.toString()));
            }
        }
        return newList;
    }

    public static TclArgument[] getTypedMatch(org.eclipse.dltk.tcl.ast.TclCommand command, String name) {
        EList<ArgumentMatch> matches = command.getMatches();
        ArrayList<TclArgument> results = new ArrayList<TclArgument>();
        for (ArgumentMatch argumentMatch : matches) {
            TypedArgument arg;
            Argument definition = argumentMatch.getDefinition();
            if (!(definition instanceof TypedArgument) || !name.equals((arg = (TypedArgument)definition).getName())) continue;
            results.addAll((Collection<TclArgument>)argumentMatch.getArguments());
        }
        return results.toArray(new TclArgument[results.size()]);
    }
}

