/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;

public class ProjectIndexerManager {
    private static final String EXTPOINT = "org.eclipse.dltk.core.projectIndexer";
    private static final String NATURE_ATTR = "nature";
    private static final String CLASS_ATTR = "class";
    private static Map indexers;

    private static synchronized void initialize() {
        if (indexers != null) {
            return;
        }
        indexers = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPOINT);
        int i = 0;
        while (i < cfg.length) {
            List<IConfigurationElement> elements;
            String nature = cfg[i].getAttribute(NATURE_ATTR);
            if (indexers.get(nature) != null) {
                elements = (List)indexers.get(nature);
                elements.add(cfg[i]);
            } else {
                elements = new ArrayList();
                elements.add(cfg[i]);
                indexers.put(nature, elements);
            }
            ++i;
        }
    }

    public static IProjectIndexer[] getIndexers(String natureId) {
        ProjectIndexerManager.initialize();
        IProjectIndexer[] nature = ProjectIndexerManager.getByNature(natureId);
        IProjectIndexer[] all = ProjectIndexerManager.getByNature("#");
        if (all == null) {
            return nature;
        }
        if (nature == null) {
            return all;
        }
        IProjectIndexer[] result = new IProjectIndexer[nature.length + all.length];
        System.arraycopy(nature, 0, result, 0, nature.length);
        System.arraycopy(all, 0, result, nature.length, all.length);
        return result;
    }

    public static IProjectIndexer[] getAllIndexers() {
        ProjectIndexerManager.initialize();
        ArrayList<IProjectIndexer> result = new ArrayList<IProjectIndexer>();
        String[] natures = indexers.keySet().toArray(new String[indexers.size()]);
        int i = 0;
        while (i < natures.length) {
            IProjectIndexer[] byNature = ProjectIndexerManager.getByNature(natures[i]);
            if (byNature != null) {
                int j = 0;
                while (j < byNature.length) {
                    result.add(byNature[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (!result.isEmpty()) {
            return result.toArray(new IProjectIndexer[result.size()]);
        }
        return null;
    }

    private static IProjectIndexer[] getByNature(String natureId) {
        Object ext = indexers.get(natureId);
        if (ext != null) {
            if (ext instanceof IProjectIndexer[]) {
                return (IProjectIndexer[])ext;
            }
            if (ext instanceof List) {
                List elements = (List)ext;
                ArrayList result = new ArrayList(elements.size());
                int i = 0;
                while (i < elements.size()) {
                    Object e = elements.get(i);
                    if (e instanceof IProjectIndexer) {
                        result.add(e);
                    } else {
                        IConfigurationElement cfg = (IConfigurationElement)e;
                        try {
                            IProjectIndexer builder = (IProjectIndexer)cfg.createExecutableExtension(CLASS_ATTR);
                            result.add(builder);
                        }
                        catch (CoreException ex) {
                            DLTKCore.error("Error creating ProjectIndexer", ex);
                        }
                    }
                    ++i;
                }
                if (!result.isEmpty()) {
                    IProjectIndexer[] array = result.toArray(new IProjectIndexer[result.size()]);
                    indexers.put(natureId, array);
                    return array;
                }
                indexers.remove(natureId);
                return null;
            }
        }
        return null;
    }

    private static IProjectIndexer[] getIndexers(IScriptProject project) {
        return ProjectIndexerManager.getIndexers(project, true);
    }

    private static IProjectIndexer[] getIndexers(IScriptProject project, boolean checkEnable) {
        if (checkEnable && !ProjectIndexerManager.isIndexerEnabled(project.getProject())) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit == null) {
            return null;
        }
        return ProjectIndexerManager.getIndexers(toolkit.getNatureId());
    }

    public static boolean isIndexerEnabled(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.dltk.core").getBoolean("org.eclipse.dltk.core.indexer", true);
    }

    public static void removeLibrary(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeLibrary(project, path);
                ++i;
            }
        }
    }

    public static void removeProject(IPath projectPath) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getAllIndexers();
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeProject(projectPath);
                ++i;
            }
        }
    }

    public static void indexLibrary(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexLibrary(project, path);
                ++i;
            }
        }
    }

    public static void removeProjectFragment(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeProjectFragment(project, path);
                ++i;
            }
        }
    }

    public static void indexProjectFragment(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexProjectFragment(project, path);
                ++i;
            }
        }
    }

    public static void indexProject(IProject project) {
        if (ProjectIndexerManager.isIndexerEnabled(project)) {
            ProjectIndexerManager.indexProject(project, DLTKCore.create(project));
        }
    }

    public static void indexProject(IScriptProject scriptProject) {
        IProject project = scriptProject.getProject();
        if (ProjectIndexerManager.isIndexerEnabled(project)) {
            ProjectIndexerManager.indexProject(project, scriptProject);
        }
    }

    private static void indexProject(IProject project, IScriptProject scriptProject) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(scriptProject, false);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexProject(scriptProject);
                ++i;
            }
        }
    }

    public static void removeSourceModule(IScriptProject project, String path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeSourceModule(project, path);
                ++i;
            }
        }
    }

    public static void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(toolkit.getNatureId());
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexSourceModule(module, toolkit);
                ++i;
            }
        }
    }

    public static void reconciled(ISourceModule workingCopy) {
        IScriptProject project = workingCopy.getScriptProject();
        if (project == null) {
            return;
        }
        if (!ProjectIndexerManager.isIndexerEnabled(project.getProject())) {
            return;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit == null) {
            return;
        }
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(toolkit.getNatureId());
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].reconciled(workingCopy, toolkit);
                ++i;
            }
        }
    }

    public static void startIndexing() {
        IProjectIndexer[] indexers = ProjectIndexerManager.getAllIndexers();
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].startIndexing();
                ++i;
            }
        }
    }
}

