/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.core.ModelManager;

public class ParserBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    private String natureId = null;

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        ISourceParser parser;
        if (this.natureId != null && (parser = DLTKLanguageManager.getSourceParser(project.getProject(), this.natureId)) != null) {
            return new ParserBuildParticipant(parser);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class ParserBuildParticipant
    implements IBuildParticipant {
        private final ISourceParser parser;

        public ParserBuildParticipant(ISourceParser parser) {
            this.parser = parser;
        }

        public void build(IBuildContext context) throws CoreException {
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            if (moduleDeclaration != null) {
                return;
            }
            ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = ModelManager.getModelManager().getSourceModuleInfoCache().get(context.getSourceModule());
            moduleDeclaration = SourceParserUtil.getModuleFromCache(cacheEntry, 0, context.getProblemReporter());
            if (moduleDeclaration != null) {
                context.set(IBuildContext.ATTR_MODULE_DECLARATION, moduleDeclaration);
                return;
            }
            ProblemCollector problemCollector = new ProblemCollector();
            moduleDeclaration = this.parser.parse(context.getSourceModule().getPath().toString().toCharArray(), context.getContents(), context.getProblemReporter());
            SourceParserUtil.putModuleToCache(cacheEntry, moduleDeclaration, 0, problemCollector);
            problemCollector.copyTo(context.getProblemReporter());
        }
    }
}

